/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.sceneManager;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.profiling.GLProfiler;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import org.lwjgl.opengl.GL41;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.RDXFocusBasedCamera;
import us.ihmc.rdx.input.RDXInputMode;
import us.ihmc.rdx.sceneManager.RDX3DScene;
import us.ihmc.rdx.sceneManager.RDX3DSceneTools;
import us.ihmc.rdx.sceneManager.RDXSceneLevel;
import us.ihmc.rdx.tools.LibGDXTools;

public class RDX3DBareBonesScene {
    private final RDX3DScene scene = new RDX3DScene();
    private InputMultiplexer inputMultiplexer;
    private RDXFocusBasedCamera camera3D;
    private ScreenViewport viewport;
    private int x = 0;
    private int y = 0;
    private int width = -1;
    private int height = -1;
    private boolean firstRenderStarted = false;
    private boolean addFocusSphere = true;
    private Runnable onCreate;
    private GLProfiler glProfiler;

    public void create() {
        this.create(RDXInputMode.libGDX, RDXSceneLevel.MODEL, RDXSceneLevel.VIRTUAL);
    }

    public void create(RDXInputMode inputMode, RDXSceneLevel ... sceneLevels) {
        if (LibGDXTools.ENABLE_OPENGL_DEBUGGER) {
            this.glProfiler = LibGDXTools.createGLProfiler();
        }
        LibGDXTools.syncLogLevelWithLogTools();
        this.camera3D = new RDXFocusBasedCamera();
        if (inputMode == RDXInputMode.libGDX) {
            this.inputMultiplexer = new InputMultiplexer();
            Gdx.input.setInputProcessor((InputProcessor)this.inputMultiplexer);
            this.inputMultiplexer.addProcessor(this.camera3D.setInputForLibGDX());
        }
        this.scene.create(sceneLevels);
        if (this.addFocusSphere) {
            this.scene.addModelInstance(this.camera3D.getFocusPointSphere(), RDXSceneLevel.VIRTUAL);
        }
        this.viewport = new ScreenViewport((Camera)this.camera3D);
        this.viewport.setUnitsPerPixel(1.0f);
        this.scene.addDefaultLighting();
        if (this.onCreate != null) {
            this.onCreate.run();
        }
    }

    public void renderShadowMap() {
        this.renderShadowMap(this.width, this.height);
    }

    public void renderShadowMap(int x, int y) {
        this.scene.renderShadowMap(this.camera3D, x, y);
    }

    public void render() {
        this.preRender();
        this.scene.render();
        this.scene.postRender(this.camera3D, RDXSceneLevel.VIRTUAL.SINGLETON_SET);
        if (LibGDXTools.ENABLE_OPENGL_DEBUGGER) {
            this.glProfiler.reset();
        }
    }

    private void preRender() {
        if (!this.firstRenderStarted) {
            this.firstRenderStarted = true;
            LogTools.info((String)"Starting first render.");
        }
        if (this.width < 0) {
            this.width = this.getCurrentWindowWidth();
        }
        if (this.height < 0) {
            this.height = this.getCurrentWindowHeight();
        }
        this.viewport.update(this.width, this.height);
        this.scene.preRender(this.camera3D);
        GL41.glViewport((int)this.x, (int)this.y, (int)this.width, (int)this.height);
        RDX3DSceneTools.glClearGray();
    }

    public void dispose() {
        this.scene.dispose();
        ExceptionTools.handle(() -> this.camera3D.dispose(), (ExceptionHandler)DefaultExceptionHandler.PRINT_MESSAGE);
    }

    public boolean closeRequested() {
        return true;
    }

    public void addModelInstance(ModelInstance modelInstance) {
        this.scene.addModelInstance(modelInstance);
    }

    public void addModelInstance(ModelInstance modelInstance, RDXSceneLevel sceneLevel) {
        this.scene.addModelInstance(modelInstance, sceneLevel);
    }

    public void addCoordinateFrame(double size) {
        this.scene.addCoordinateFrame(size);
    }

    public void addRenderableProvider(RenderableProvider renderableProvider) {
        this.scene.addRenderableProvider(renderableProvider);
    }

    public void addRenderableProvider(RenderableProvider renderableProvider, RDXSceneLevel sceneLevel) {
        this.scene.addRenderableProvider(renderableProvider, sceneLevel);
    }

    public void setViewportBoundsToWindow() {
        this.setViewportBounds(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public void setViewportBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.scene.getShadowManager().setViewportBounds(x, y, width, height);
    }

    public int getCurrentWindowWidth() {
        return Gdx.graphics.getWidth();
    }

    public int getCurrentWindowHeight() {
        return Gdx.graphics.getHeight();
    }

    public RDXFocusBasedCamera getCamera3D() {
        return this.camera3D;
    }

    public void addLibGDXInputProcessor(InputProcessor inputProcessor) {
        if (this.inputMultiplexer != null) {
            this.inputMultiplexer.addProcessor(inputProcessor);
        } else {
            LogTools.error((int)1, (Object)"libGDX is not being used for input!");
        }
    }

    public void setAddFocusSphere(boolean addFocusSphere) {
        this.addFocusSphere = addFocusSphere;
    }

    public void setOnCreate(Runnable onCreate) {
        this.onCreate = onCreate;
    }

    public RDX3DScene getScene() {
        return this.scene;
    }
}

