/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.sceneManager;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.OrthographicCamera;
import imgui.internal.ImGui;
import us.ihmc.commons.MathTools;
import us.ihmc.rdx.input.ImGui2DViewInput;

public class RDX2DOrthographicCamera
extends OrthographicCamera {
    private double zoomSpeedFactor = 0.1;
    private double mouseTranslateSpeedFactor = 0.02;
    private double keyboardTranslateSpeedFactor = 10.0;
    private double minTranslationX = -100.0;
    private double minTranslationY = -100.0;
    private double maxTranslationX = 100.0;
    private double maxTranslationY = 100.0;
    private double maxZoom = 2.0;
    private double minZoom = 0.1;
    private boolean libGDXInputMode = false;
    private boolean isWPressed = false;
    private boolean isAPressed = false;
    private boolean isSPressed = false;
    private boolean isDPressed = false;

    public RDX2DOrthographicCamera() {
        this.viewportWidth = Gdx.graphics.getWidth();
        this.viewportHeight = Gdx.graphics.getHeight();
        this.update(true);
    }

    public InputProcessor setInputForLibGDX() {
        this.libGDXInputMode = true;
        return new InputAdapter(){
            int lastDragX = 0;
            int lastDragY = 0;

            public boolean scrolled(float amountX, float amountY) {
                RDX2DOrthographicCamera.this.scrolled(amountY);
                return false;
            }

            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                this.lastDragX = screenX;
                this.lastDragY = screenY;
                return false;
            }

            public boolean touchDragged(int screenX, int screenY, int pointer) {
                int deltaX = screenX - this.lastDragX;
                int deltaY = screenY - this.lastDragY;
                this.lastDragX = screenX;
                this.lastDragY = screenY;
                if (Gdx.input.isButtonPressed(0)) {
                    RDX2DOrthographicCamera.this.mouseDragged(deltaX, deltaY);
                }
                return false;
            }
        };
    }

    public void processImGuiInput(ImGui2DViewInput input) {
        this.isWPressed = input.isWindowHovered() && ImGui.isKeyDown((int)87);
        this.isSPressed = input.isWindowHovered() && ImGui.isKeyDown((int)83);
        this.isAPressed = input.isWindowHovered() && ImGui.isKeyDown((int)65);
        boolean bl = this.isDPressed = input.isWindowHovered() && ImGui.isKeyDown((int)68);
        if (input.isDragging(0)) {
            this.mouseDragged(input.getMouseDraggedX(0), input.getMouseDraggedY(0));
        }
        if (input.isWindowHovered() && !ImGui.getIO().getKeyCtrl()) {
            this.scrolled(input.getMouseWheelDelta());
        }
    }

    private void mouseDragged(float deltaX, float deltaY) {
        this.translate((float)(-this.mouseTranslateSpeedFactor) * this.zoom * deltaX, (float)this.mouseTranslateSpeedFactor * this.zoom * deltaY);
    }

    private void scrolled(float amountY) {
        this.zoom = (float)((double)this.zoom + (double)(Math.signum(amountY) * this.zoom) * this.zoomSpeedFactor);
        this.zoom = (float)MathTools.clamp((double)this.zoom, (double)this.minZoom, (double)this.maxZoom);
    }

    public void update() {
        float tpf = Gdx.app.getGraphics().getDeltaTime();
        if (this.libGDXInputMode) {
            this.isWPressed = Gdx.input.isKeyPressed(51);
            this.isSPressed = Gdx.input.isKeyPressed(47);
            this.isAPressed = Gdx.input.isKeyPressed(29);
            this.isDPressed = Gdx.input.isKeyPressed(32);
        }
        if (this.isWPressed) {
            this.translate(0.0f, (float)this.getKeyboardTranslateSpeedFactor() * tpf);
        }
        if (this.isSPressed) {
            this.translate(0.0f, (float)(-this.getKeyboardTranslateSpeedFactor()) * tpf);
        }
        if (this.isAPressed) {
            this.translate((float)(-this.getKeyboardTranslateSpeedFactor()) * tpf, 0.0f);
        }
        if (this.isDPressed) {
            this.translate((float)this.getKeyboardTranslateSpeedFactor() * tpf, 0.0f);
        }
        this.position.x = (float)MathTools.clamp((double)this.position.x, (double)this.minTranslationX, (double)this.maxTranslationX);
        this.position.y = (float)MathTools.clamp((double)this.position.y, (double)this.minTranslationY, (double)this.maxTranslationY);
        this.update(true);
    }

    private double getKeyboardTranslateSpeedFactor() {
        return this.keyboardTranslateSpeedFactor * (double)this.zoom;
    }

    public double getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(double minZoom) {
        this.minZoom = minZoom;
    }

    public double getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(double maxZoom) {
        this.maxZoom = maxZoom;
    }

    public double getMinTranslationX() {
        return this.minTranslationX;
    }

    public void setMinTranslationX(double minTranslationX) {
        this.minTranslationX = minTranslationX;
    }

    public double getMaxTranslationX() {
        return this.maxTranslationX;
    }

    public void setMaxTranslationX(double maxTranslationX) {
        this.maxTranslationX = maxTranslationX;
    }

    public double getMinTranslationY() {
        return this.minTranslationY;
    }

    public void setMinTranslationY(double minTranslationY) {
        this.minTranslationY = minTranslationY;
    }

    public double getMaxTranslationY() {
        return this.maxTranslationY;
    }

    public void setMaxTranslationY(double maxTranslationY) {
        this.maxTranslationY = maxTranslationY;
    }

    public double getZoomSpeedFactor() {
        return this.zoomSpeedFactor;
    }

    public void setZoomSpeedFactor(double zoomSpeedFactor) {
        this.zoomSpeedFactor = zoomSpeedFactor;
    }

    public double getMouseTranslateSpeedFactor() {
        return this.mouseTranslateSpeedFactor;
    }

    public void setKeyboardTranslateSpeedFactor(double keyboardTranslateSpeedFactor) {
        this.keyboardTranslateSpeedFactor = keyboardTranslateSpeedFactor;
    }
}

