/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.lighting;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;

public class RDXShadowSceneShader
extends BaseShader {
    private Renderable renderable;
    private ShaderProgram program;

    public RDXShadowSceneShader(Renderable renderable, ShaderProgram shaderProgram) {
        this.renderable = renderable;
        this.program = shaderProgram;
        this.register(DefaultShader.Inputs.worldTrans, DefaultShader.Setters.worldTrans);
        this.register(DefaultShader.Inputs.projViewTrans, DefaultShader.Setters.projViewTrans);
        this.register(DefaultShader.Inputs.normalMatrix, DefaultShader.Setters.normalMatrix);
        this.register(DefaultShader.Inputs.diffuseTexture, DefaultShader.Setters.diffuseTexture);
    }

    public void init() {
        ShaderProgram program = this.program;
        this.program = null;
        this.init(program, this.renderable);
        this.renderable = null;
    }

    public void begin(Camera camera, RenderContext context) {
        super.begin(camera, context);
        context.setDepthTest(515);
        context.setCullFace(1029);
    }

    public int compareTo(Shader other) {
        return 0;
    }

    public boolean canRender(Renderable instance) {
        return true;
    }

    public void render(Renderable renderable) {
        Material material = renderable.material;
        this.context.setBlending(material.has(BlendingAttribute.Type), 770, 771);
        if (!material.has(TextureAttribute.Diffuse)) {
            Pixmap map = new Pixmap(100, 100, Pixmap.Format.RGBA8888);
            map.setColor(((ColorAttribute)material.get((long)ColorAttribute.Diffuse)).color);
            map.drawRectangle(0, 0, 100, 100);
            material.set((Attribute)TextureAttribute.createDiffuse((Texture)new Texture(map)));
            map.dispose();
        }
        super.render(renderable);
    }
}

