/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.lighting;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import org.lwjgl.opengl.GL41;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.rdx.lighting.AccessibleFrameBufferCubemap;
import us.ihmc.rdx.lighting.RDXDepthMapShader;
import us.ihmc.rdx.tools.LibGDXTools;

public class RDXPointLight {
    public static final int DEPTHMAP_SIZE = 4096;
    public static final float CAMERA_NEAR = 0.1f;
    public static final float CAMERA_FAR = 100.0f;
    protected ModelBatch modelBatch;
    private final Camera camera;
    private final Point3D position = new Point3D();
    private AccessibleFrameBufferCubemap framebuffer;
    private Cubemap depthMap;
    private PointLight attribute;

    public RDXPointLight() {
        this.camera = new PerspectiveCamera(90.0f, 4096.0f, 4096.0f);
        this.modelBatch = new ModelBatch((ShaderProvider)new DefaultShaderProvider(){

            protected Shader createShader(Renderable renderable) {
                return new RDXDepthMapShader(renderable);
            }
        });
        this.update();
    }

    public void update() {
        this.camera.near = 0.1f;
        this.camera.far = 100.0f;
        LibGDXTools.toLibGDX((Tuple3DReadOnly)this.position, this.camera.position);
        this.camera.update();
        if (this.attribute != null) {
            LibGDXTools.toLibGDX((Tuple3DReadOnly)this.position, this.attribute.position);
        }
    }

    public <T extends RenderableProvider> void render(Iterable<T> renderableProviders) {
        if (this.framebuffer == null) {
            this.framebuffer = new AccessibleFrameBufferCubemap(Pixmap.Format.RGBA8888, 4096, 4096, true);
        }
        ShaderProgram shaderProgram = RDXDepthMapShader.getOrLoadShaderProgram();
        shaderProgram.begin();
        shaderProgram.setUniformf("u_cameraFar", this.camera.far);
        shaderProgram.setUniformf("u_lightPosition_x", this.position.getX32());
        shaderProgram.setUniformf("u_lightPosition_y", this.position.getY32());
        shaderProgram.setUniformf("u_lightPosition_z", this.position.getZ32());
        shaderProgram.end();
        this.framebuffer.begin();
        for (int sideIndex = 0; sideIndex < 6; ++sideIndex) {
            Cubemap.CubemapSide side = Cubemap.CubemapSide.values()[sideIndex];
            this.framebuffer.bindSide(side, this.camera);
            GL41.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL41.glClear((int)16640);
            this.modelBatch.begin(this.camera);
            this.modelBatch.render(renderableProviders);
            this.modelBatch.end();
        }
        this.framebuffer.end();
        this.depthMap = (Cubemap)this.framebuffer.getColorBufferTexture();
    }

    public void apply(ShaderProgram shader) {
        shader.begin();
        int textureNum = this.depthMap.getTextureObjectHandle();
        this.depthMap.bind(textureNum);
        shader.setUniformf("u_type", 2.0f);
        shader.setUniformi("u_depthMapCube", textureNum);
        shader.setUniformf("u_cameraFar", this.camera.far);
        shader.setUniformf("u_lightPosition_x", this.position.getX32());
        shader.setUniformf("u_lightPosition_y", this.position.getY32());
        shader.setUniformf("u_lightPosition_z", this.position.getZ32());
        shader.end();
    }

    public Point3D getPosition() {
        return this.position;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setAttribute(PointLight attribute) {
        this.attribute = attribute;
    }

    public PointLight getAttribute() {
        return this.attribute;
    }
}

