/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.input;

import imgui.ImGui;

public class ImGuiMouseDragData {
    private final int button;
    private boolean dragging = false;
    private boolean dragJustStarted = false;
    private float lastMousePositionX;
    private float lastMousePositionY;
    private float mouseDraggedX = 0.0f;
    private float mouseDraggedY = 0.0f;
    private Object objectBeingDragged;

    public ImGuiMouseDragData(int button) {
        this.button = button;
    }

    public void update() {
        boolean mouseDown = ImGui.isMouseDown((int)this.button);
        float mousePositionX = ImGui.getMousePosX();
        float mousePositionY = ImGui.getMousePosY();
        float mouseDragDeltaX = mousePositionX - this.lastMousePositionX;
        float mouseDragDeltaY = mousePositionY - this.lastMousePositionY;
        if (!mouseDown) {
            this.dragging = false;
            this.objectBeingDragged = null;
        } else {
            this.dragJustStarted = !this.dragging;
            this.dragging = true;
            this.mouseDraggedX = mouseDragDeltaX;
            this.mouseDraggedY = mouseDragDeltaY;
        }
        this.lastMousePositionX = mousePositionX;
        this.lastMousePositionY = mousePositionY;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean getDragJustStarted() {
        return this.dragJustStarted;
    }

    public float getMouseDraggedX() {
        return this.mouseDraggedX;
    }

    public float getMouseDraggedY() {
        return this.mouseDraggedY;
    }

    public void setObjectBeingDragged(Object objectBeingDragged) {
        this.objectBeingDragged = objectBeingDragged;
    }

    public Object getObjectBeingDragged() {
        return this.objectBeingDragged;
    }
}

