/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import com.badlogic.gdx.graphics.Texture;
import imgui.internal.ImGui;
import us.ihmc.rdx.imgui.ImGuiPanel;

public class ImGuiVideoPanel
extends ImGuiPanel {
    public static final boolean FLIP_Y = true;
    public static final boolean DO_NOT_FLIP_Y = false;
    private Texture texture;
    private final boolean flipY;
    private float mouseXRightFromLeft;
    private float mouseYDownFromTop;
    private Runnable userImGuiImageInteraction;

    public ImGuiVideoPanel(String name, boolean flipY) {
        super(name);
        this.setRenderMethod(this::renderImGuiWidgets);
        this.flipY = flipY;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
        this.setFirstTimeWidth(texture.getWidth());
        this.setFirstTimeHeight(texture.getHeight());
    }

    public void renderImGuiWidgets() {
        float rawWindowPosX = ImGui.getWindowPosX();
        float rawWindowPosY = ImGui.getWindowPosY();
        this.mouseXRightFromLeft = ImGui.getMousePosX() - rawWindowPosX;
        this.mouseYDownFromTop = ImGui.getMousePosY() - rawWindowPosY;
        if (this.userImGuiImageInteraction != null) {
            this.userImGuiImageInteraction.run();
        }
        if (this.texture != null) {
            float tableHeader = 22.0f;
            float posX = rawWindowPosX;
            float posY = rawWindowPosY + tableHeader;
            float sizeX = ImGui.getWindowSizeX();
            float sizeY = ImGui.getWindowSizeY() - tableHeader;
            float windowAspect = sizeX / sizeY;
            float cameraAspect = (float)this.texture.getWidth() / (float)this.texture.getHeight();
            float drawSizeX = sizeX;
            float drawSizeY = sizeY;
            float centeringX = 0.0f;
            float centeringY = 0.0f;
            if (windowAspect > cameraAspect) {
                drawSizeX = drawSizeY * cameraAspect;
                centeringX = (sizeX - drawSizeX) / 2.0f;
            } else {
                drawSizeY = drawSizeX / cameraAspect;
                centeringY = (sizeY - drawSizeY) / 2.0f;
            }
            float startX = posX + centeringX;
            float startY = this.flipY ? posY + centeringY + drawSizeY : posY + centeringY;
            float endX = posX + centeringX + drawSizeX;
            float endY = this.flipY ? posY + centeringY : posY + centeringY + drawSizeY;
            ImGui.getWindowDrawList().addImage(this.texture.getTextureObjectHandle(), startX, startY, endX, endY);
        }
    }

    public void setUserImGuiImageInteraction(Runnable userImGuiImageInteraction) {
        this.userImGuiImageInteraction = userImGuiImageInteraction;
    }

    public float getMouseXRightFromLeft() {
        return this.mouseXRightFromLeft;
    }

    public float getMouseYDownFromTop() {
        return this.mouseYDownFromTop;
    }
}

