/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.internal.ImGui;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import us.ihmc.rdx.imgui.ImGuiTools;

public class ImGuiPlot {
    private static final AtomicInteger ID = new AtomicInteger();
    private final String name;
    private final int bufferSize;
    private final float[] values;
    private final int width;
    private final int height;
    private int index = 0;

    public ImGuiPlot(String name) {
        this(name, 1000);
    }

    public ImGuiPlot(String name, int bufferSize) {
        this(name, bufferSize, 230, 50);
    }

    public ImGuiPlot(String name, int bufferSize, int width, int height) {
        this.name = ImGuiTools.uniqueLabel(this.getClass().getSimpleName() + ID.getAndIncrement(), name);
        this.bufferSize = bufferSize;
        this.values = new float[bufferSize];
        this.width = width;
        this.height = height;
        Arrays.fill(this.values, Float.NaN);
    }

    public void setValue(double newValue) {
        this.setValue((float)newValue);
    }

    public void setValue(float newValue) {
        this.values[this.index] = newValue;
    }

    public void render(double newValue) {
        this.render((float)newValue);
    }

    public void render(float newValue) {
        this.setValue(newValue);
        this.render();
    }

    public void render() {
        ImGui.plotLines((String)this.name, (float[])this.values, (int)this.bufferSize, (int)0, (String)("" + this.values[this.index]), (float)Float.MAX_VALUE, (float)Float.MAX_VALUE, (float)this.width, (float)this.height);
        ++this.index;
        if (this.index >= this.bufferSize - 1) {
            this.index = 0;
        }
        this.values[this.index] = Float.NaN;
    }
}

