/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import us.ihmc.rdx.imgui.ImGuiDockspacePanel;
import us.ihmc.rdx.imgui.ImGuiPanel;

public class ImGuiPanelManager {
    private final TreeSet<ImGuiPanel> panels = new TreeSet<ImGuiPanel>(Comparator.comparing(ImGuiPanel::getPanelName));
    private final ConcurrentLinkedQueue<ImGuiPanel> removalQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ImGuiPanel> addQueue = new ConcurrentLinkedQueue();

    public void addPanel(ImGuiPanel panel) {
        this.panels.add(panel);
    }

    public void addPanel(String windowName, Runnable render) {
        this.panels.add(new ImGuiPanel(windowName, render));
    }

    public void addSelfManagedPanel(String windowName) {
        this.panels.add(new ImGuiPanel(windowName));
    }

    public void queueRemovePanel(ImGuiPanel panel) {
        this.removalQueue.add(panel);
    }

    public void queueAddPanel(ImGuiPanel panel) {
        this.addQueue.add(panel);
    }

    public void renderPanelMenu() {
        for (ImGuiPanel panel : this.panels) {
            panel.renderMenuItem();
        }
    }

    public void renderPanels(ImGuiDockspacePanel justClosedPanel) {
        while (!this.removalQueue.isEmpty()) {
            this.panels.remove(this.removalQueue.poll());
        }
        while (!this.addQueue.isEmpty()) {
            this.panels.add(this.addQueue.poll());
        }
        for (ImGuiPanel panel : this.panels) {
            panel.renderPanelAndChildren(justClosedPanel);
        }
    }

    public void loadConfiguration(JsonNode jsonNode) {
        JsonNode windowsNode = jsonNode.get("windows");
        Iterator it = windowsNode.fields();
        while (it.hasNext()) {
            Map.Entry panelEntry = (Map.Entry)it.next();
            for (ImGuiPanel panel : this.panels) {
                panel.load(panelEntry);
            }
        }
    }

    public void saveConfiguration(ObjectNode root) {
        ObjectNode anchorJSON = root.putObject("windows");
        for (ImGuiPanel panel : this.panels) {
            panel.save(anchorJSON);
        }
    }
}

