/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import imgui.internal.ImGui;
import imgui.type.ImBoolean;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.imgui.ImGuiDockspacePanel;
import us.ihmc.rdx.imgui.ImGuiPanelSizeHandler;

public class ImGuiPanel
extends ImGuiPanelSizeHandler {
    private final String panelName;
    private Runnable render;
    private final ImBoolean isShowing;
    private final boolean hasMenuBar;
    private final TreeSet<ImGuiPanel> children = new TreeSet<ImGuiPanel>(Comparator.comparing(ImGuiPanel::getPanelName));
    private final ConcurrentLinkedQueue<ImGuiPanel> removalQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ImGuiPanel> additionQueue = new ConcurrentLinkedQueue();
    private int lastDockID = -1;

    public ImGuiPanel(String panelName) {
        this(panelName, null, false);
    }

    public ImGuiPanel(String panelName, Runnable render) {
        this(panelName, render, false);
    }

    public ImGuiPanel(String panelName, Runnable render, boolean isShowing) {
        this(panelName, render, isShowing, false);
    }

    public ImGuiPanel(String panelName, Runnable render, boolean isShowing, boolean hasMenuBar) {
        this.panelName = panelName;
        this.render = render;
        this.isShowing = new ImBoolean(isShowing);
        this.hasMenuBar = hasMenuBar;
    }

    void renderMenuItem() {
        this.renderMenuItem("");
    }

    void renderMenuItem(String indent) {
        ImGui.menuItem((String)(indent + this.panelName), (String)"", (ImBoolean)this.isShowing);
        for (ImGuiPanel child : this.children) {
            child.renderMenuItem(indent + "\t");
        }
    }

    void renderPanelAndChildren(ImGuiDockspacePanel justClosedPanel) {
        while (!this.removalQueue.isEmpty()) {
            this.children.remove(this.removalQueue.poll());
        }
        while (!this.additionQueue.isEmpty()) {
            this.children.add(this.additionQueue.poll());
        }
        if (this.isShowing.get() && this.render != null) {
            this.handleSizeBeforeBegin();
            int windowFlags = 0;
            if (this.hasMenuBar) {
                windowFlags |= 0x400;
            }
            ImGui.begin((String)this.panelName, (ImBoolean)this.isShowing, (int)windowFlags);
            this.handleSizeAfterBegin();
            int windowDockID = ImGui.getWindowDockID();
            if (this.lastDockID != windowDockID) {
                LogTools.debug((String)"Dock ID changed. {}: {} -> {}", (Object)this.panelName, (Object)this.lastDockID, (Object)windowDockID);
                if (justClosedPanel != null) {
                    LogTools.info((String)"Closing \"{}\" because containing dockspace \"{}\" closed", (Object)this.panelName, (Object)justClosedPanel.getName());
                    this.isShowing.set(false);
                }
            }
            this.lastDockID = windowDockID;
            this.render.run();
            ImGui.end();
        }
        for (ImGuiPanel child : this.children) {
            child.renderPanelAndChildren(justClosedPanel);
        }
    }

    public void addChild(ImGuiPanel child) {
        this.children.add(child);
    }

    public void queueRemoveChild(ImGuiPanel panel) {
        this.removalQueue.add(panel);
    }

    public void queueAddChild(ImGuiPanel panel) {
        this.additionQueue.add(panel);
    }

    void load(Map.Entry<String, JsonNode> panelEntry) {
        if (this.panelName.equals(panelEntry.getKey())) {
            this.isShowing.set(panelEntry.getValue().asBoolean());
        }
        for (ImGuiPanel child : this.children) {
            child.load(panelEntry);
        }
    }

    void save(ObjectNode anchorJSON) {
        anchorJSON.put(this.panelName, this.isShowing.get());
        for (ImGuiPanel child : this.children) {
            child.save(anchorJSON);
        }
    }

    public void setRenderMethod(Runnable render) {
        this.render = render;
    }

    public ImBoolean getIsShowing() {
        return this.isShowing;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public TreeSet<ImGuiPanel> getChildren() {
        return this.children;
    }
}

