/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.internal.ImGui;
import imgui.type.ImBoolean;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.imgui.ImGuiPanelSizeHandler;

public class ImGuiDockspacePanel
extends ImGuiPanelSizeHandler {
    private final String name;
    private final ImBoolean isShowing = new ImBoolean(true);
    private int dockspaceID = -1;
    private boolean wasJustClosed = false;
    private boolean shownLastTick = false;

    public ImGuiDockspacePanel(String name) {
        this.name = name;
    }

    public void renderPanel() {
        boolean shownThisTick = this.isShowing.get();
        if (shownThisTick) {
            ImGui.pushStyleVar((int)2, (float)0.0f, (float)0.0f);
            this.handleSizeBeforeBegin();
            ImGui.begin((String)this.name, (ImBoolean)this.isShowing);
            this.handleSizeAfterBegin();
            ImGui.popStyleVar();
            int dockNodeFlags = 0;
            dockNodeFlags += 8;
            int id = ImGui.getID((String)this.name);
            if (this.dockspaceID != id) {
                LogTools.info((String)"Dockspace ID changed. {}: {} -> {}", (Object)this.name, (Object)this.dockspaceID, (Object)id);
            }
            this.dockspaceID = id;
            ImGui.dockSpace((int)id, (float)0.0f, (float)0.0f, (int)dockNodeFlags);
            ImGui.end();
        }
        this.wasJustClosed = !shownThisTick && this.shownLastTick;
        this.shownLastTick = shownThisTick;
    }

    public void renderMenuItem() {
        ImGui.checkbox((String)(this.name + "###DockspacePanel" + this.name), (ImBoolean)this.isShowing);
    }

    public ImBoolean getIsShowing() {
        return this.isShowing;
    }

    public boolean getWasJustClosed() {
        return this.wasJustClosed;
    }

    public String getName() {
        return this.name;
    }
}

