/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import imgui.internal.ImGui;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.rdx.input.ImGui3DViewInput;
import us.ihmc.rdx.input.ImGuiMouseDragData;
import us.ihmc.rdx.mesh.RDXMultiColorMeshBuilder;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;

public class RDXFocusBasedCamera
extends Camera {
    private boolean inputEnabled = true;
    private boolean useMiddleClickViewOrbit = false;
    private final FramePose3D cameraPose = new FramePose3D();
    private final RigidBodyTransform transformToParent = new RigidBodyTransform();
    private final ReferenceFrame cameraFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransform)this.transformToParent);
    private final FrameVector3D euclidDirection = new FrameVector3D();
    private final FrameVector3D euclidUp = new FrameVector3D();
    private final AxisAngle latitudeAxisAngle = new AxisAngle();
    private final AxisAngle focusPointAxisAngle = new AxisAngle();
    private final double zoomSpeedFactor = 0.1;
    private final double latitudeSpeed = 0.005;
    private final double longitudeSpeed = 0.005;
    private final double translateSpeedFactor = 0.5;
    private final FramePose3D focusPointPose;
    private float verticalFieldOfView = 45.0f;
    private double latitude = 0.0;
    private double longitude = 0.0;
    private double zoom = 10.0;
    private final Model focusPointModel;
    private final ModelInstance focusPointSphere;
    private final Vector3D NEGATIVE_Z = new Vector3D(0.0, 0.0, -1.0);
    private boolean libGDXInputMode = false;
    private boolean isWPressed = false;
    private boolean isAPressed = false;
    private boolean isSPressed = false;
    private boolean isDPressed = false;
    private boolean isQPressed = false;
    private boolean isZPressed = false;
    private boolean isCPressed = false;
    private boolean isEPressed = false;
    final Vector3 tmp = new Vector3();

    public RDXFocusBasedCamera() {
        this.focusPointPose = new FramePose3D(ReferenceFrame.getWorldFrame());
        this.viewportWidth = Gdx.graphics.getWidth();
        this.viewportHeight = Gdx.graphics.getHeight();
        this.near = 0.05f;
        this.far = 2000.0f;
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.begin();
        modelBuilder.node().id = "focusPointSphere";
        RDXMultiColorMeshBuilder meshBuilder = new RDXMultiColorMeshBuilder();
        meshBuilder.addSphere(1.0f, (Tuple3DReadOnly)new Point3D(0.0, 0.0, 0.0), new Color(0.54509807f, 0.0f, 0.0f, 1.0f));
        Mesh mesh = meshBuilder.generateMesh();
        MeshPart meshPart = new MeshPart("xyz", mesh, 0, mesh.getNumIndices(), 4);
        Material material = new Material();
        Texture paletteTexture = RDXMultiColorMeshBuilder.loadPaletteTexture();
        material.set((Attribute)TextureAttribute.createDiffuse((Texture)paletteTexture));
        material.set((Attribute)ColorAttribute.createDiffuse((Color)Color.WHITE));
        modelBuilder.part(meshPart, material);
        this.focusPointModel = modelBuilder.end();
        this.focusPointSphere = new ModelInstance(this.focusPointModel);
        this.changeCameraPosition(-2.0, 0.7, 1.0);
        this.updateCameraPose();
        this.update(true);
    }

    public InputProcessor setInputForLibGDX() {
        this.libGDXInputMode = true;
        return new InputAdapter(){
            int lastDragX = 0;
            int lastDragY = 0;

            public boolean scrolled(float amountX, float amountY) {
                RDXFocusBasedCamera.this.scrolled(amountY);
                return false;
            }

            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                this.lastDragX = screenX;
                this.lastDragY = screenY;
                return false;
            }

            public boolean touchDragged(int screenX, int screenY, int pointer) {
                int deltaX = screenX - this.lastDragX;
                int deltaY = screenY - this.lastDragY;
                this.lastDragX = screenX;
                this.lastDragY = screenY;
                if (Gdx.input.isButtonPressed(0)) {
                    RDXFocusBasedCamera.this.mouseDragged(deltaX, deltaY);
                }
                return false;
            }
        };
    }

    public ModelInstance getFocusPointSphere() {
        return this.focusPointSphere;
    }

    public void changeCameraPosition(double x, double y, double z) {
        Point3D desiredCameraPosition = new Point3D(x, y, z);
        this.zoom = desiredCameraPosition.distance((Point3DReadOnly)this.focusPointPose.getPosition());
        Vector3D fromFocusToCamera = new Vector3D();
        fromFocusToCamera.sub((Tuple3DReadOnly)desiredCameraPosition, (Tuple3DReadOnly)this.focusPointPose.getPosition());
        fromFocusToCamera.normalize();
        Vector3D fromCameraToFocus = new Vector3D();
        fromCameraToFocus.setAndNegate((Tuple3DReadOnly)fromFocusToCamera);
        fromCameraToFocus.scaleAdd(-fromCameraToFocus.dot((Tuple3DReadOnly)this.NEGATIVE_Z), (Tuple3DReadOnly)this.NEGATIVE_Z, (Tuple3DReadOnly)fromCameraToFocus);
        this.latitude = 1.5707963267948966 - fromFocusToCamera.angle((Vector3DReadOnly)this.NEGATIVE_Z);
        this.longitude = fromCameraToFocus.angle((Vector3DReadOnly)Axis3D.X);
        Vector3D cross = new Vector3D();
        cross.cross((Tuple3DReadOnly)fromCameraToFocus, (Tuple3DReadOnly)Axis3D.X);
        if (cross.dot((Tuple3DReadOnly)this.NEGATIVE_Z) > 0.0) {
            this.longitude = -this.longitude;
        }
    }

    public void translateCameraFocusPoint(Tuple3DReadOnly translation) {
        this.focusPointPose.getPosition().add(translation);
    }

    public void setCameraFocusPoint(Tuple3DReadOnly translation) {
        this.focusPointPose.getPosition().set(translation);
    }

    public void updateCameraPose() {
        this.zoom = MathTools.clamp((double)this.zoom, (double)0.1, (double)100.0);
        this.latitude = MathTools.clamp((double)this.latitude, (double)1.5707963267948966);
        this.longitude = EuclidCoreTools.trimAngleMinusPiToPi((double)this.longitude);
        this.focusPointAxisAngle.set((Vector3DReadOnly)Axis3D.Z, -this.longitude);
        this.focusPointPose.getOrientation().set((Orientation3DReadOnly)this.focusPointAxisAngle);
        LibGDXTools.toLibGDX((Tuple3DReadOnly)this.focusPointPose.getPosition(), ((Node)this.focusPointSphere.nodes.get((int)0)).translation);
        ((Node)this.focusPointSphere.nodes.get((int)0)).scale.set((float)(0.0035 * this.zoom), (float)(0.0035 * this.zoom), (float)(0.0035 * this.zoom));
        this.focusPointSphere.calculateTransforms();
        this.cameraPose.setIncludingFrame((FramePose3DReadOnly)this.focusPointPose);
        this.latitudeAxisAngle.set((Vector3DReadOnly)Axis3D.Y, -this.latitude);
        this.cameraPose.appendRotation((Orientation3DReadOnly)this.latitudeAxisAngle);
        this.cameraPose.appendTranslation(-this.zoom, 0.0, 0.0);
        this.euclidDirection.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)Axis3D.X);
        this.cameraPose.getOrientation().transform((FixedFrameTuple3DBasics)this.euclidDirection);
        this.euclidUp.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)Axis3D.Z);
        this.cameraPose.getOrientation().transform((FixedFrameTuple3DBasics)this.euclidUp);
        LibGDXTools.toLibGDX((Tuple3DReadOnly)this.cameraPose.getPosition(), this.position);
        LibGDXTools.toLibGDX((Tuple3DReadOnly)this.euclidDirection, this.direction);
        LibGDXTools.toLibGDX((Tuple3DReadOnly)this.euclidUp, this.up);
        this.cameraPose.get((RigidBodyTransformBasics)this.transformToParent);
        this.cameraFrame.update();
    }

    public void processImGuiInput(ImGui3DViewInput input) {
        boolean panDrag;
        this.isWPressed = input.isWindowHovered() && ImGui.isKeyDown((int)87);
        this.isSPressed = input.isWindowHovered() && ImGui.isKeyDown((int)83);
        this.isAPressed = input.isWindowHovered() && ImGui.isKeyDown((int)65);
        this.isDPressed = input.isWindowHovered() && ImGui.isKeyDown((int)68);
        this.isQPressed = input.isWindowHovered() && ImGui.isKeyDown((int)81);
        this.isZPressed = input.isWindowHovered() && ImGui.isKeyDown((int)90);
        this.isCPressed = input.isWindowHovered() && ImGui.isKeyDown((int)67);
        this.isEPressed = input.isWindowHovered() && ImGui.isKeyDown((int)69);
        int orbitMouseButton = this.useMiddleClickViewOrbit ? 2 : 0;
        ImGuiMouseDragData orbitDragData = input.getMouseDragData(orbitMouseButton);
        boolean dragJustStarted = ImGui.isWindowHovered() && orbitDragData.getDragJustStarted();
        ImGuiMouseDragData panDragData = !this.useMiddleClickViewOrbit ? input.getMouseDragData(2) : null;
        boolean bl = panDrag = ImGui.isWindowHovered() && panDragData != null && panDragData.getDragJustStarted();
        if (!this.useMiddleClickViewOrbit) {
            dragJustStarted &= input.getClosestPick() == null;
        }
        if (dragJustStarted) {
            orbitDragData.setObjectBeingDragged((Object)this);
        }
        if (orbitDragData.isDragging() && orbitDragData.getObjectBeingDragged() == this) {
            this.mouseDragged(orbitDragData.getMouseDraggedX(), orbitDragData.getMouseDraggedY());
        }
        if (panDrag) {
            panDragData.setObjectBeingDragged((Object)this);
        }
        if (panDragData != null && panDragData.isDragging() && panDragData.getObjectBeingDragged() == this) {
            this.mousePanned(panDragData.getMouseDraggedX(), panDragData.getMouseDraggedY());
        }
        if (input.isWindowHovered() && !ImGui.getIO().getKeyCtrl()) {
            this.scrolled(input.getMouseWheelDelta());
        }
    }

    private void mouseDragged(float deltaX, float deltaY) {
        this.latitude -= 0.005 * (double)deltaY;
        this.longitude += 0.005 * (double)deltaX;
    }

    private void mousePanned(float deltaX, float deltaY) {
        this.focusPointPose.appendTranslation(0.0, 0.005 * (double)deltaX, 0.0);
        this.focusPointPose.appendTranslation(0.005 * (double)deltaY, 0.0, 0.0);
        this.updateCameraPose();
    }

    private void scrolled(float amountY) {
        this.zoom += (double)Math.signum(amountY) * this.zoom * 0.1;
    }

    public void update() {
        if (this.inputEnabled) {
            float deltaTime = Gdx.app.getGraphics().getDeltaTime();
            if (this.libGDXInputMode) {
                this.isWPressed = Gdx.input.isKeyPressed(51);
                this.isSPressed = Gdx.input.isKeyPressed(47);
                this.isAPressed = Gdx.input.isKeyPressed(29);
                this.isDPressed = Gdx.input.isKeyPressed(32);
                this.isQPressed = Gdx.input.isKeyPressed(45);
                this.isZPressed = Gdx.input.isKeyPressed(54);
                this.isCPressed = Gdx.input.isKeyPressed(31);
                this.isEPressed = Gdx.input.isKeyPressed(33);
            }
            boolean ctrlHeld = ImGui.getIO().getKeyCtrl();
            boolean shiftHeld = ImGui.getIO().getKeyShift();
            if (ctrlHeld) {
                double zoomAmount = 5.0 * (double)deltaTime;
                double orbitAmount = 500.0 * (double)deltaTime;
                if (shiftHeld) {
                    zoomAmount *= 0.2;
                    orbitAmount *= 0.2;
                }
                if (this.isEPressed) {
                    this.zoom -= zoomAmount;
                }
                if (this.isCPressed) {
                    this.zoom += zoomAmount;
                }
                if (this.isAPressed) {
                    this.longitude += 0.005 * orbitAmount;
                }
                if (this.isDPressed) {
                    this.longitude -= 0.005 * orbitAmount;
                }
                if (this.isSPressed) {
                    this.latitude += 0.005 * orbitAmount;
                }
                if (this.isWPressed) {
                    this.latitude -= 0.005 * orbitAmount;
                }
            } else {
                double translateAmount = 0.5 * this.zoom * (double)deltaTime;
                if (shiftHeld) {
                    translateAmount *= 0.2;
                }
                if (this.isWPressed) {
                    this.focusPointPose.appendTranslation(translateAmount, 0.0, 0.0);
                }
                if (this.isSPressed) {
                    this.focusPointPose.appendTranslation(-translateAmount, 0.0, 0.0);
                }
                if (this.isAPressed) {
                    this.focusPointPose.appendTranslation(0.0, translateAmount, 0.0);
                }
                if (this.isDPressed) {
                    this.focusPointPose.appendTranslation(0.0, -translateAmount, 0.0);
                }
                if (this.isQPressed) {
                    this.focusPointPose.appendTranslation(0.0, 0.0, translateAmount);
                }
                if (this.isZPressed) {
                    this.focusPointPose.appendTranslation(0.0, 0.0, -translateAmount);
                }
            }
            this.updateCameraPose();
        }
        this.update(true);
    }

    public void update(boolean updateFrustum) {
        float widthOverHeightRatio = this.viewportWidth / this.viewportHeight;
        this.projection.setToProjection(Math.abs(this.near), Math.abs(this.far), this.verticalFieldOfView, widthOverHeightRatio);
        this.view.setToLookAt(this.position, this.tmp.set(this.position).add(this.direction), this.up);
        this.combined.set(this.projection);
        Matrix4.mul((float[])this.combined.val, (float[])this.view.val);
        if (updateFrustum) {
            this.invProjectionView.set(this.combined);
            Matrix4.inv((float[])this.invProjectionView.val);
            this.frustum.update(this.invProjectionView);
        }
    }

    public void setPose(RigidBodyTransform transformToWorld) {
        this.cameraPose.set((RigidBodyTransformReadOnly)transformToWorld);
        this.euclidDirection.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)Axis3D.X);
        this.cameraPose.getOrientation().transform((FixedFrameTuple3DBasics)this.euclidDirection);
        this.euclidUp.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)Axis3D.Z);
        this.cameraPose.getOrientation().transform((FixedFrameTuple3DBasics)this.euclidUp);
        LibGDXTools.toLibGDX((Tuple3DReadOnly)this.cameraPose.getPosition(), this.position);
        LibGDXTools.toLibGDX((Tuple3DReadOnly)this.euclidDirection, this.direction);
        LibGDXTools.toLibGDX((Tuple3DReadOnly)this.euclidUp, this.up);
        this.cameraPose.get((RigidBodyTransformBasics)this.transformToParent);
        this.cameraFrame.update();
    }

    public void dispose() {
        this.focusPointModel.dispose();
    }

    public ReferenceFrame getCameraFrame() {
        return this.cameraFrame;
    }

    public FramePose3D getCameraPose() {
        return this.cameraPose;
    }

    public FramePose3DReadOnly getFocusPointPose() {
        return this.focusPointPose;
    }

    public void setInputEnabled(boolean inputEnabled) {
        this.inputEnabled = inputEnabled;
    }

    public void setVerticalFieldOfView(double verticalFieldOfView) {
        this.verticalFieldOfView = (float)verticalFieldOfView;
    }

    public float getVerticalFieldOfView() {
        return this.verticalFieldOfView;
    }

    public void setUseMiddleClickViewOrbit(boolean useMiddleClickViewOrbit) {
        this.useMiddleClickViewOrbit = useMiddleClickViewOrbit;
    }

    public void setFocusPointPose(RigidBodyTransform rigidBodyTransform) {
        this.focusPointPose.set((RigidBodyTransformReadOnly)rigidBodyTransform);
        this.updateCameraPose();
    }
}

