/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import org.apache.commons.math3.util.Pair;
import us.ihmc.log.LogTools;

public class RDX3DSituatedText
implements RenderableProvider {
    private static final HashMap<Pair<String, String>, Model> MODELS = new HashMap();
    private static final HashMap<Model, Pair<Integer, Integer>> MODEL_SIZES = new HashMap();
    private static final HashMap<Model, Integer> MODEL_USAGES = new HashMap();
    private static final Timer TIMER = new Timer();
    private static final ModelBuilder BUILDER = new ModelBuilder();
    private static final Font DEFAULT_FONT = new Font("Arial", 0, 72);
    private static boolean enableCaching = true;
    private final Model model;
    private final ModelInstance modelInstance;

    public RDX3DSituatedText(String text) {
        this(text, DEFAULT_FONT);
    }

    public RDX3DSituatedText(String text, String font) {
        this(text, new Font(font, 0, 72));
    }

    public RDX3DSituatedText(String text, Font font) {
        this.model = RDX3DSituatedText.getModel(text, font);
        this.modelInstance = new ModelInstance(this.model);
        this.setSize(0.1f);
    }

    public void setSize(float width, float height) {
        Pair<Integer, Integer> modelSize = MODEL_SIZES.get(this.model);
        this.modelInstance.transform.setToScaling(width / (float)((Integer)modelSize.getKey()).intValue(), height / (float)((Integer)modelSize.getValue()).intValue(), 1.0f);
    }

    public void setSize(float height) {
        Pair<Integer, Integer> modelSize = MODEL_SIZES.get(this.model);
        float scale = height / (float)((Integer)modelSize.getValue()).intValue();
        this.modelInstance.transform.setToScaling(scale, scale, scale);
    }

    public void scale(float height) {
        Pair<Integer, Integer> modelSize = MODEL_SIZES.get(this.model);
        float scale = height / (float)((Integer)modelSize.getValue()).intValue();
        this.modelInstance.transform.scale(scale, scale, scale);
    }

    public ModelInstance getModelInstance() {
        return this.modelInstance;
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.modelInstance != null) {
            this.modelInstance.getRenderables(renderables, pool);
        }
    }

    protected void finalize() throws Throwable {
        MODEL_USAGES.computeIfPresent(this.model, (m, integer) -> {
            Integer n = integer;
            integer = integer - 1;
            return n;
        });
        if (this.model != null && MODEL_USAGES.get(this.model) == 0) {
            TIMER.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (MODEL_USAGES.get(RDX3DSituatedText.this.model) == 0) {
                        Pair<String, String> key = null;
                        for (Map.Entry<Pair<String, String>, Model> e : MODELS.entrySet()) {
                            if (!e.getValue().equals(RDX3DSituatedText.this.model)) continue;
                            key = e.getKey();
                            break;
                        }
                        if (key != null) {
                            MODELS.remove(key);
                        }
                        MODEL_SIZES.remove(RDX3DSituatedText.this.model);
                        MODEL_USAGES.remove(RDX3DSituatedText.this.model);
                    }
                }
            }, 120000L);
        }
        super.finalize();
    }

    public static boolean isCachingEnabled() {
        return enableCaching;
    }

    public static void setCachingEnabled(boolean value) {
        enableCaching = value;
    }

    public static void clearCache() {
        MODELS.clear();
        MODEL_USAGES.clear();
    }

    private static Model createModel(String text, Font font) {
        Texture texture;
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setFont(font != null ? font : DEFAULT_FONT);
        FontMetrics fm = g2d.getFontMetrics();
        int width = fm.stringWidth(text);
        int height = fm.getHeight();
        g2d.dispose();
        image = new BufferedImage(width, height, 2);
        g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setFont(font != null ? font : DEFAULT_FONT);
        fm = g2d.getFontMetrics();
        g2d.setColor(Color.BLACK);
        g2d.drawString(text, 0, fm.getAscent());
        g2d.dispose();
        try {
            File temp = File.createTempFile("GDXTextObject", ".png");
            ImageIO.write((RenderedImage)image, "png", temp);
            texture = new Texture(new FileHandle(temp));
        }
        catch (IOException ex) {
            LogTools.error((String)"Could not create model for GDXTextObject");
            LogTools.error((Object)ex);
            return null;
        }
        Material material = new Material(new Attribute[]{TextureAttribute.createDiffuse((Texture)texture), ColorAttribute.createSpecular((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f), new BlendingAttribute(770, 771)});
        long attributes = 25L;
        Model model = BUILDER.createRect(0.0f, 0.0f, 0.0f, (float)width, 0.0f, 0.0f, (float)width, (float)height, 0.0f, 0.0f, (float)height, 0.0f, 0.0f, 0.0f, 1.0f, material, attributes);
        MODEL_SIZES.put(model, (Pair<Integer, Integer>)new Pair((Object)width, (Object)height));
        return model;
    }

    private static Model getModel(String text, Font font) {
        Pair modelPair = new Pair((Object)text, (Object)font.getName());
        if (MODELS.containsKey(modelPair)) {
            return MODELS.get(modelPair);
        }
        Model model = RDX3DSituatedText.createModel(text, font);
        if (enableCaching && model != null) {
            MODELS.put((Pair<String, String>)modelPair, model);
            MODEL_USAGES.compute(model, (m, integer) -> {
                Integer n;
                if (integer == null) {
                    n = integer = Integer.valueOf(1);
                } else {
                    Integer n2 = integer;
                    integer = integer + 1;
                    n = n2;
                }
                return n;
            });
        }
        return model;
    }
}

