/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tests.g3d.shadows.system.classical;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.tests.g3d.shadows.system.classical.ClassicalShadowSystem;

public class MainShader
extends DefaultShader {
    protected static ClassicalShadowSystem shadowSystem;
    private static String defaultVertexShader;
    private static String defaultFragmentShader;

    public static String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.files.classpath("com/badlogic/gdx/tests/g3d/shadows/system/classical/main.vertex.glsl").readString();
        }
        return defaultVertexShader;
    }

    public static String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.files.classpath("com/badlogic/gdx/tests/g3d/shadows/system/classical/main.fragment.glsl").readString();
        }
        return defaultFragmentShader;
    }

    public static String createPrefix(Renderable renderable, Config config) {
        return DefaultShader.createPrefix((Renderable)renderable, (DefaultShader.Config)config);
    }

    public MainShader(Renderable renderable, Config config) {
        this(renderable, config, MainShader.createPrefix(renderable, config));
    }

    public MainShader(Renderable renderable, Config config, String prefix) {
        this(renderable, config, prefix, MainShader.getDefaultVertexShader(), MainShader.getDefaultFragmentShader());
    }

    public MainShader(Renderable renderable, Config config, String prefix, String vertexShader, String fragmentShader) {
        this(renderable, config, new ShaderProgram(prefix + vertexShader, prefix + fragmentShader));
    }

    public MainShader(Renderable renderable, Config config, ShaderProgram shaderProgram) {
        super(renderable, (DefaultShader.Config)config, shaderProgram);
        shadowSystem = config.shadowSystem;
        this.register(Inputs.shadowTexture, Setters.shadowTexture);
        this.register(Inputs.resolution, Setters.resolution);
    }

    static {
        defaultVertexShader = null;
        defaultFragmentShader = null;
    }

    public static class Config
    extends DefaultShader.Config {
        public ClassicalShadowSystem shadowSystem;

        public Config(ClassicalShadowSystem shadowSystem) {
            this.numBones = 12;
            this.numPointLights = 2;
            this.numSpotLights = 5;
            this.numDirectionalLights = 2;
            this.shadowSystem = shadowSystem;
        }
    }

    public static class Inputs
    extends DefaultShader.Inputs {
        public static final BaseShader.Uniform shadowTexture = new BaseShader.Uniform("u_shadowTexture");
        public static final BaseShader.Uniform resolution = new BaseShader.Uniform("u_resolution");
    }

    public static class Setters
    extends DefaultShader.Setters {
        public static final BaseShader.Setter shadowTexture = new BaseShader.GlobalSetter(){

            public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, (GLTexture)shadowSystem.getMainTexture());
            }
        };
        public static final BaseShader.Setter resolution = new BaseShader.GlobalSetter(){

            public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, (float)Gdx.graphics.getBackBufferWidth(), (float)Gdx.graphics.getBackBufferHeight());
            }
        };
    }
}

