/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.visualizers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.ArrayList;
import java.util.function.Function;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.gdx.mesh.GDXIDMappedColorFunction;
import us.ihmc.gdx.mesh.GDXMeshGraphicTools;
import us.ihmc.gdx.mesh.GDXMultiColorMeshBuilder;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;

public class GDXPlanarRegionsGraphic
implements RenderableProvider {
    private final ModelBuilder modelBuilder = new ModelBuilder();
    private Function<Integer, Color> colorFunction = new GDXIDMappedColorFunction();
    private boolean drawAreaText = false;
    private boolean drawBoundingBox = false;
    private boolean drawNormal;
    private volatile Runnable buildMeshAndCreateModelInstance = null;
    private ModelInstance modelInstance;
    private Model lastModel;
    private final ResettableExceptionHandlingExecutorService executorService = MissingThreadTools.newSingleThreadExecutor((String)this.getClass().getSimpleName(), (boolean)true, (int)1);

    public void generateFlatGround() {
        this.generateMeshes(PlanarRegionsList.flatGround((double)20.0));
    }

    public void update() {
        if (this.buildMeshAndCreateModelInstance != null) {
            this.buildMeshAndCreateModelInstance.run();
            this.buildMeshAndCreateModelInstance = null;
        }
    }

    public void generateMeshesAsync(PlanarRegionsList planarRegionsList) {
        this.executorService.clearQueueAndExecute(() -> this.generateMeshes(planarRegionsList));
    }

    public synchronized void generateMeshes(PlanarRegionsList planarRegionsList) {
        ArrayList<GDXMultiColorMeshBuilder> meshBuilders = new ArrayList<GDXMultiColorMeshBuilder>();
        for (PlanarRegion planarRegion : planarRegionsList.getPlanarRegionsAsList()) {
            GDXMultiColorMeshBuilder meshBuilder = new GDXMultiColorMeshBuilder();
            meshBuilders.add(meshBuilder);
            this.singleRegionMeshBuilder(planarRegion, meshBuilder);
        }
        this.buildMeshAndCreateModelInstance = () -> {
            this.modelBuilder.begin();
            Material material = new Material();
            Texture paletteTexture = GDXMultiColorMeshBuilder.loadPaletteTexture();
            material.set((Attribute)TextureAttribute.createDiffuse((Texture)paletteTexture));
            material.set((Attribute)ColorAttribute.createDiffuse((Color)new Color(0.7f, 0.7f, 0.7f, 1.0f)));
            for (GDXMultiColorMeshBuilder meshBuilder : meshBuilders) {
                Mesh mesh = meshBuilder.generateMesh();
                MeshPart meshPart = new MeshPart("xyz", mesh, 0, mesh.getNumIndices(), 4);
                this.modelBuilder.part(meshPart, material);
            }
            if (this.lastModel != null) {
                this.lastModel.dispose();
            }
            this.lastModel = this.modelBuilder.end();
            this.modelInstance = new ModelInstance(this.lastModel);
        };
    }

    private void singleRegionMeshBuilder(PlanarRegion planarRegion, GDXMultiColorMeshBuilder meshBuilder) {
        RigidBodyTransform transformToWorld = planarRegion.getTransformToWorldCopy();
        Color color = this.colorFunction.apply(planarRegion.getRegionId());
        meshBuilder.addMultiLine((RigidBodyTransformReadOnly)transformToWorld, planarRegion.getConcaveHull(), 0.01, color, true);
        double totalArea = 0.0;
        for (ConvexPolygon2D convexPolygon : planarRegion.getConvexPolygons()) {
            meshBuilder.addPolygon((RigidBodyTransformReadOnly)transformToWorld, (ConvexPolygon2DReadOnly)convexPolygon, color);
            totalArea += convexPolygon.getArea();
        }
        if (this.drawBoundingBox) {
            GDXMeshGraphicTools.drawBoxEdges(meshBuilder, (Box3DReadOnly)PlanarRegionTools.getLocalBoundingBox3DInWorld((PlanarRegion)planarRegion, (double)0.1), 0.005, color);
        }
        if (this.drawNormal) {
            Point3DReadOnly centroid = PlanarRegionTools.getCentroid3DInWorld((PlanarRegion)planarRegion);
            double length = 0.07;
            double radius = 0.004;
            double cylinderToConeLengthRatio = 0.8;
            double coneDiameterMultiplier = 1.8;
            GDXMeshGraphicTools.drawArrow(meshBuilder, (Tuple3DReadOnly)centroid, (Orientation3DReadOnly)transformToWorld.getRotation(), length, radius, cylinderToConeLengthRatio, coneDiameterMultiplier, color);
        }
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.modelInstance != null) {
            this.modelInstance.getRenderables(renderables, pool);
        }
    }

    public void destroy() {
        this.executorService.destroy();
    }

    public void setDrawAreaText(boolean drawAreaText) {
        this.drawAreaText = drawAreaText;
    }

    public void setDrawBoundingBox(boolean drawBoundingBox) {
        this.drawBoundingBox = drawBoundingBox;
    }

    public void setDrawNormal(boolean drawNormal) {
        this.drawNormal = drawNormal;
    }

    public void setColorFunction(Function<Integer, Color> colorFunction) {
        this.colorFunction = colorFunction;
    }
}

