/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.ui.gizmo;

import java.util.function.Function;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.gdx.ui.gizmo.SphereRayIntersection;

public class StepCheckIsPointInsideAlgorithm {
    private final SphereRayIntersection boundingSphereIntersection = new SphereRayIntersection();
    private final Point3D interpolatedPoint = new Point3D();

    public void setup(double radius, RigidBodyTransformReadOnly transform) {
        this.boundingSphereIntersection.setup(radius, transform);
    }

    public void setup(double radius, Point3DReadOnly offset, RigidBodyTransformReadOnly transform) {
        this.boundingSphereIntersection.setup(radius, offset, transform);
    }

    public void setup(double radius, Point3DReadOnly positionInWorld) {
        this.boundingSphereIntersection.setup(radius, positionInWorld);
    }

    public double intersect(Line3DReadOnly pickRay, int resolution, Function<Point3DReadOnly, Boolean> isPointInside) {
        if (this.boundingSphereIntersection.intersect(pickRay)) {
            for (int i = 0; i < resolution; ++i) {
                this.interpolatedPoint.interpolate((Tuple3DReadOnly)this.boundingSphereIntersection.getFirstIntersectionToPack(), (Tuple3DReadOnly)this.boundingSphereIntersection.getSecondIntersectionToPack(), (double)i / (double)resolution);
                if (!isPointInside.apply((Point3DReadOnly)this.interpolatedPoint).booleanValue()) continue;
                return this.interpolatedPoint.distance(pickRay.getPoint());
            }
        }
        return Double.NaN;
    }

    public Point3D getClosestIntersection() {
        return this.interpolatedPoint;
    }
}

