/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.ui.gizmo;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import imgui.internal.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImFloat;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.gdx.FocusBasedGDXCamera;
import us.ihmc.gdx.imgui.ImGuiPanel;
import us.ihmc.gdx.imgui.ImGuiTools;
import us.ihmc.gdx.input.ImGui3DViewInput;
import us.ihmc.gdx.mesh.GDXMeshBuilder;
import us.ihmc.gdx.mesh.GDXMeshDataInterpreter;
import us.ihmc.gdx.mesh.GDXMultiColorMeshBuilder;
import us.ihmc.gdx.tools.GDXTools;
import us.ihmc.gdx.ui.gizmo.Axis3DRotations;
import us.ihmc.gdx.ui.gizmo.ClockFaceRotation3DMouseDragAlgorithm;
import us.ihmc.gdx.ui.gizmo.DiscreteArrowRayIntersection;
import us.ihmc.gdx.ui.gizmo.DiscreteTorusRayIntersection;
import us.ihmc.gdx.ui.gizmo.DynamicGDXModel;
import us.ihmc.gdx.ui.gizmo.GDXGizmoTools;
import us.ihmc.gdx.ui.gizmo.Line3DMouseDragAlgorithm;
import us.ihmc.gdx.ui.gizmo.SixDoFSelection;
import us.ihmc.gdx.ui.gizmo.SphereRayIntersection;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.robotics.robotSide.RobotSide;

public class GDXPose3DGizmo
implements RenderableProvider {
    private final ImFloat torusRadius = new ImFloat(0.5f);
    private final ImFloat torusCameraSize = new ImFloat(0.067f);
    private final ImFloat torusTubeRadiusRatio = new ImFloat(0.074f);
    private final ImFloat arrowLengthRatio = new ImFloat(0.431f);
    private final ImFloat arrowHeadBodyLengthRatio = new ImFloat(0.48f);
    private final ImFloat arrowHeadBodyRadiusRatio = new ImFloat(2.0f);
    private final ImFloat arrowSpacingFactor = new ImFloat(2.22f);
    private final ImBoolean resizeAutomatically = new ImBoolean(true);
    private double animationSpeed = 0.7853981633974483;
    private double arrowBodyRadius;
    private double arrowLength;
    private double arrowBodyLength;
    private double arrowHeadRadius;
    private double arrowHeadLength;
    private double arrowSpacing;
    private final Material[] normalMaterials = new Material[3];
    private final Material[] highlightedMaterials = new Material[3];
    private final Axis3DRotations axisRotations = new Axis3DRotations();
    private final DynamicGDXModel[] arrowModels = new DynamicGDXModel[3];
    private final DynamicGDXModel[] torusModels = new DynamicGDXModel[3];
    private final Point3D closestCollision = new Point3D();
    private SixDoFSelection closestCollisionSelection;
    private final SphereRayIntersection boundingSphereIntersection = new SphereRayIntersection();
    private final DiscreteTorusRayIntersection torusIntersection = new DiscreteTorusRayIntersection();
    private final DiscreteArrowRayIntersection arrowIntersection = new DiscreteArrowRayIntersection();
    private final Pose3D pose = new Pose3D();
    private final RigidBodyTransform transform = new RigidBodyTransform();
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private static final YawPitchRoll FLIP_180 = new YawPitchRoll(0.0, Math.PI, 0.0);
    private boolean dragging = false;
    private final Line3DMouseDragAlgorithm lineDragAlgorithm = new Line3DMouseDragAlgorithm();
    private final ClockFaceRotation3DMouseDragAlgorithm clockFaceDragAlgorithm = new ClockFaceRotation3DMouseDragAlgorithm();
    private FocusBasedGDXCamera camera3D;
    private final Point3D cameraPosition = new Point3D();
    private double lastDistanceToCamera = -1.0;

    public void create(FocusBasedGDXCamera camera3D) {
        this.camera3D = camera3D;
        for (Axis3D axis : Axis3D.values) {
            Color color = GDXGizmoTools.AXIS_COLORS[axis.ordinal()];
            this.normalMaterials[axis.ordinal()] = new Material();
            this.normalMaterials[axis.ordinal()].set((Attribute)TextureAttribute.createDiffuse((Texture)GDXMultiColorMeshBuilder.loadPaletteTexture()));
            this.normalMaterials[axis.ordinal()].set((Attribute)new BlendingAttribute(true, color.a));
            this.highlightedMaterials[axis.ordinal()] = new Material();
            this.highlightedMaterials[axis.ordinal()].set((Attribute)TextureAttribute.createDiffuse((Texture)GDXMultiColorMeshBuilder.loadPaletteTexture()));
            this.highlightedMaterials[axis.ordinal()].set((Attribute)new BlendingAttribute(true, GDXGizmoTools.AXIS_SELECTED_COLORS[axis.ordinal()].a));
            this.arrowModels[axis.ordinal()] = new DynamicGDXModel();
            this.arrowModels[axis.ordinal()].setMesh(meshBuilder -> {
                meshBuilder.addCylinder(this.arrowBodyLength, this.arrowBodyRadius, (Tuple3DReadOnly)new Point3D(0.0, 0.0, 0.5 * this.arrowSpacing), color);
                meshBuilder.addCone(this.arrowHeadLength, this.arrowHeadRadius, (Tuple3DReadOnly)new Point3D(0.0, 0.0, 0.5 * this.arrowSpacing + this.arrowBodyLength), color);
                meshBuilder.addCylinder(this.arrowBodyLength, this.arrowBodyRadius, (Tuple3DReadOnly)new Point3D(0.0, 0.0, -0.5 * this.arrowSpacing), (Orientation3DReadOnly)FLIP_180, color);
            });
            this.torusModels[axis.ordinal()] = new DynamicGDXModel();
            int resolution = 25;
            this.torusModels[axis.ordinal()].setMesh(meshBuilder -> meshBuilder.addArcTorus(0.0, Math.PI * 2, this.torusRadius.get(), this.torusTubeRadiusRatio.get() * this.torusRadius.get(), resolution, color));
        }
        this.recreateGraphics();
    }

    public void process3DViewInput(ImGui3DViewInput input) {
        Line3DReadOnly pickRay;
        this.updateFromSourceTransform();
        boolean rightMouseDown = ImGui.getIO().getMouseDown(1);
        boolean isWindowHovered = ImGui.isWindowHovered();
        if (!rightMouseDown) {
            this.dragging = false;
        }
        if (isWindowHovered && !this.dragging) {
            pickRay = input.getPickRayInWorld();
            this.determineCurrentSelectionFromPickRay(pickRay);
            if (rightMouseDown && this.closestCollisionSelection != null) {
                this.dragging = true;
                this.clockFaceDragAlgorithm.reset();
            }
        }
        if (this.dragging) {
            pickRay = input.getPickRayInWorld();
            if (this.closestCollisionSelection.isLinear()) {
                Vector3DReadOnly linearMotion = this.lineDragAlgorithm.calculate(pickRay, this.closestCollision, this.axisRotations.get(this.closestCollisionSelection.toAxis3D()), (RigidBodyTransformReadOnly)this.transform);
                this.transform.getTranslation().add((Tuple3DReadOnly)linearMotion);
                this.closestCollision.add((Tuple3DReadOnly)linearMotion);
            } else if (this.closestCollisionSelection.isAngular() && this.clockFaceDragAlgorithm.calculate(pickRay, this.closestCollision, this.axisRotations.get(this.closestCollisionSelection.toAxis3D()), (RigidBodyTransformReadOnly)this.transform)) {
                this.clockFaceDragAlgorithm.getMotion().transform(this.transform.getRotation());
            }
        }
        this.updateFromSourceTransform();
        if (this.resizeAutomatically.get()) {
            GDXTools.toEuclid(this.camera3D.position, (Point3DBasics)this.cameraPosition);
            double distanceToCamera = this.cameraPosition.distance((Point3DReadOnly)this.pose.getPosition());
            if (this.lastDistanceToCamera != distanceToCamera) {
                this.lastDistanceToCamera = distanceToCamera;
                this.recreateGraphics();
                this.updateFromSourceTransform();
            }
        }
    }

    private void updateFromSourceTransform() {
        for (Axis3D axis : Axis3D.values) {
            this.pose.set((RigidBodyTransformReadOnly)this.transform);
            this.tempTransform.set(this.transform);
            this.tempTransform.appendOrientation((Orientation3DReadOnly)this.axisRotations.get(axis));
            GDXTools.toGDX(this.tempTransform, this.arrowModels[axis.ordinal()].getOrCreateModelInstance().transform);
            GDXTools.toGDX(this.tempTransform, this.torusModels[axis.ordinal()].getOrCreateModelInstance().transform);
        }
    }

    private void determineCurrentSelectionFromPickRay(Line3DReadOnly pickRay) {
        this.closestCollisionSelection = null;
        double closestCollisionDistance = Double.POSITIVE_INFINITY;
        this.boundingSphereIntersection.setup(1.5 * (double)this.torusRadius.get(), (RigidBodyTransformReadOnly)this.transform);
        if (this.boundingSphereIntersection.intersect(pickRay)) {
            for (Axis3D axis : Axis3D.values) {
                GDXTools.toEuclid(this.torusModels[axis.ordinal()].getOrCreateModelInstance().transform, this.tempTransform);
                this.torusIntersection.setupTorus(this.torusRadius.get(), this.torusTubeRadiusRatio.get() * this.torusRadius.get(), (RigidBodyTransformReadOnly)this.tempTransform);
                double distance = this.torusIntersection.intersect(pickRay, 100);
                if (Double.isNaN(distance) || !(distance < closestCollisionDistance)) continue;
                closestCollisionDistance = distance;
                this.closestCollisionSelection = SixDoFSelection.toAngularSelection(axis);
                this.closestCollision.set(this.torusIntersection.getClosestIntersection());
            }
            for (Axis3D axis : Axis3D.values) {
                GDXTools.toEuclid(this.arrowModels[axis.ordinal()].getOrCreateModelInstance().transform, this.tempTransform);
                for (RobotSide side : RobotSide.values) {
                    double zOffset = side.negateIfRightSide(0.5 * this.arrowSpacing + 0.5 * this.arrowBodyLength);
                    this.arrowIntersection.setupShapes(this.arrowBodyLength, this.arrowBodyRadius, this.arrowHeadRadius, this.arrowHeadLength, zOffset, (RigidBodyTransformReadOnly)this.tempTransform);
                    double distance = this.arrowIntersection.intersect(pickRay, 100, side == RobotSide.LEFT);
                    if (Double.isNaN(distance) || !(distance < closestCollisionDistance)) continue;
                    closestCollisionDistance = distance;
                    this.closestCollisionSelection = SixDoFSelection.toLinearSelection(axis);
                    this.closestCollision.set(this.arrowIntersection.getIntersection());
                }
            }
        }
        this.updateMaterialHighlighting();
    }

    private void updateMaterialHighlighting() {
        for (Axis3D axis : Axis3D.values) {
            if (this.closestCollisionSelection != null && this.closestCollisionSelection.isAngular() && this.closestCollisionSelection.toAxis3D() == axis) {
                this.torusModels[axis.ordinal()].setMaterial(this.highlightedMaterials[axis.ordinal()]);
            } else {
                this.torusModels[axis.ordinal()].setMaterial(this.normalMaterials[axis.ordinal()]);
            }
            if (this.closestCollisionSelection != null && this.closestCollisionSelection.isLinear() && this.closestCollisionSelection.toAxis3D() == axis) {
                this.arrowModels[axis.ordinal()].setMaterial(this.highlightedMaterials[axis.ordinal()]);
                continue;
            }
            this.arrowModels[axis.ordinal()].setMaterial(this.normalMaterials[axis.ordinal()]);
        }
    }

    public ImGuiPanel createTunerPanel(String name) {
        return new ImGuiPanel("Pose3D Gizmo Tuner (" + name + ")", this::renderImGuiTuner);
    }

    public void renderImGuiTuner() {
        ImGui.text((String)"Use the right mouse button to manipulate the widget.");
        if (ImGui.button((String)"Reset")) {
            this.transform.setToZero();
        }
        ImGui.checkbox((String)"Resize based on camera distance", (ImBoolean)this.resizeAutomatically);
        ImGui.pushItemWidth((float)100.0f);
        boolean proportionsChanged = false;
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Torus radius"), (float[])this.torusRadius.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Torus camera size"), (float[])this.torusCameraSize.getData(), (float)0.001f, (float)0.0f, (float)1.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Torus tube radius ratio"), (float[])this.torusTubeRadiusRatio.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Arrow length ratio"), (float[])this.arrowLengthRatio.getData(), (float)0.001f, (float)0.0f, (float)1.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Arrow head body length ratio"), (float[])this.arrowHeadBodyLengthRatio.getData(), (float)0.001f, (float)0.0f, (float)1.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Arrow head body radius ratio"), (float[])this.arrowHeadBodyRadiusRatio.getData(), (float)0.001f, (float)0.0f, (float)3.0f);
        ImGui.popItemWidth();
        if (proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Arrow spacing factor"), (float[])this.arrowSpacingFactor.getData(), (float)0.001f, (float)0.0f, (float)1000.0f)) {
            this.recreateGraphics();
        }
        this.updateFromSourceTransform();
    }

    private void recreateGraphics() {
        if (this.lastDistanceToCamera > 0.0) {
            this.torusRadius.set(this.torusCameraSize.get() * (float)this.lastDistanceToCamera);
        } else {
            this.torusRadius.set(this.torusCameraSize.get());
        }
        this.arrowBodyRadius = this.torusTubeRadiusRatio.get() * this.torusRadius.get();
        this.arrowLength = this.arrowLengthRatio.get() * this.torusRadius.get();
        this.arrowBodyLength = (1.0 - (double)this.arrowHeadBodyLengthRatio.get()) * this.arrowLength;
        this.arrowHeadRadius = (double)this.arrowHeadBodyRadiusRatio.get() * this.arrowBodyRadius;
        this.arrowHeadLength = (double)this.arrowHeadBodyLengthRatio.get() * this.arrowLength;
        this.arrowSpacing = this.arrowSpacingFactor.get() * (this.torusRadius.get() + this.torusTubeRadiusRatio.get() * this.torusRadius.get());
        this.updateMaterialHighlighting();
        for (Axis3D axis : Axis3D.values) {
            this.arrowModels[axis.ordinal()].invalidateMesh();
            this.torusModels[axis.ordinal()].invalidateMesh();
        }
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        for (Axis3D axis : Axis3D.values) {
            this.arrowModels[axis.ordinal()].getOrCreateModelInstance().getRenderables(renderables, pool);
            this.torusModels[axis.ordinal()].getOrCreateModelInstance().getRenderables(renderables, pool);
        }
    }

    public Pose3DReadOnly getPose() {
        return this.pose;
    }

    public RigidBodyTransform getTransform() {
        return this.transform;
    }

    public static Mesh angularHighlightMesh(double majorRadius, double minorRadius) {
        return GDXPose3DGizmo.tetrahedronRingMesh(1.75 * minorRadius, 1.25 * minorRadius, 5);
    }

    public static Mesh linearControlHighlightMesh(double bodyRadius, double bodyLength, double spacing) {
        GDXMeshBuilder meshBuilder = new GDXMeshBuilder();
        int numberOfHighlights = 5;
        Point3D center = new Point3D(0.0, 0.0, 0.5 * spacing + 0.33 * bodyLength);
        MeshDataHolder ringMesh = GDXPose3DGizmo.tetrahedronRingMeshDataHolder(1.75 * bodyRadius, 1.25 * bodyRadius, numberOfHighlights);
        meshBuilder.addMesh(ringMesh, (Tuple3DReadOnly)center);
        center.negate();
        meshBuilder.addMesh(ringMesh, (Tuple3DReadOnly)center);
        return meshBuilder.generateMesh();
    }

    public static Mesh tetrahedronRingMesh(double ringRadius, double tetrahedronSize, int numberOfTetrahedrons) {
        return GDXMeshDataInterpreter.interpretMeshData(GDXPose3DGizmo.tetrahedronRingMeshDataHolder(ringRadius, tetrahedronSize, numberOfTetrahedrons));
    }

    public static MeshDataHolder tetrahedronRingMeshDataHolder(double ringRadius, double tetrahedronSize, int numberOfTetrahedrons) {
        GDXMeshBuilder meshBuilder = new GDXMeshBuilder();
        Point3D position = new Point3D();
        Point3D offset = new Point3D();
        Quaternion orientation = new Quaternion();
        for (int i = 0; i < numberOfTetrahedrons; ++i) {
            MeshDataHolder tetrahedron = MeshDataGenerator.Tetrahedron((double)tetrahedronSize);
            orientation.setToYawOrientation((double)i * 2.0 * Math.PI / (double)numberOfTetrahedrons);
            orientation.appendPitchRotation(1.5707963267948966);
            offset.set(0.0, 0.0, ringRadius);
            orientation.transform((Tuple3DBasics)offset);
            position.set(offset);
            meshBuilder.addMesh(tetrahedron, (Tuple3DReadOnly)position, (Orientation3DReadOnly)orientation);
        }
        return meshBuilder.generateMeshDataHolder();
    }

    public void setResizeAutomatically(boolean resizeAutomatically) {
        this.resizeAutomatically.set(resizeAutomatically);
    }
}

