/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.ui.gizmo;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import imgui.internal.ImGui;
import imgui.type.ImFloat;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.gdx.FocusBasedGDXCamera;
import us.ihmc.gdx.imgui.ImGuiPanel;
import us.ihmc.gdx.imgui.ImGuiTools;
import us.ihmc.gdx.input.ImGui3DViewInput;
import us.ihmc.gdx.mesh.GDXMultiColorMeshBuilder;
import us.ihmc.gdx.tools.GDXTools;
import us.ihmc.gdx.ui.gizmo.DiscreteIsoscelesTriangularPrismRayIntersection;
import us.ihmc.gdx.ui.gizmo.DynamicGDXModel;
import us.ihmc.gdx.ui.gizmo.HollowCylinderRayIntersection;

public class GDXFootstepPlannerGoalGizmo
implements RenderableProvider {
    public static final Color LIGHT_GRAY = new Color().fromHsv(0.0f, 0.0f, 0.836f);
    public static final Color LIGHTER_GRAY = new Color().fromHsv(0.0f, 0.0f, 0.95f);
    public static final Color YELLOW_HIGHLIGHT = new Color().fromHsv(61.5f, 0.783f, 0.892f);
    public static final Color DISC_NORMAL_COLOR = LIGHT_GRAY;
    public static final Color DISC_HIGHLIGHTED_COLOR = LIGHTER_GRAY;
    public static final Color ARROW_NORMAL_COLOR = LIGHT_GRAY;
    public static final Color ARROW_HIGHLIGHTED_COLOR = LIGHTER_GRAY;
    private final double QUARTER_TURN = 1.5707963267948966;
    private final ImFloat discOuterRadius = new ImFloat(0.426f);
    private final ImFloat discInnerRadius = new ImFloat(0.29f);
    private final ImFloat discThickness = new ImFloat(0.014f);
    private final ImFloat arrowWidth = new ImFloat(0.257f);
    private final ImFloat arrowHeight = new ImFloat(0.137f);
    private final ImFloat arrowSpacing = new ImFloat(0.079f);
    private Material normalDiscMaterial;
    private Material normalArrowMaterial;
    private Material highlightedDiscMaterial;
    private Material highlightedArrowMaterial;
    private DynamicGDXModel discModel = new DynamicGDXModel();
    private DynamicGDXModel positiveXArrowModel = new DynamicGDXModel();
    private DynamicGDXModel positiveYArrowModel = new DynamicGDXModel();
    private DynamicGDXModel negativeXArrowModel = new DynamicGDXModel();
    private DynamicGDXModel negativeYArrowModel = new DynamicGDXModel();
    private final Point3D closestCollision = new Point3D();
    private int closestCollisionSelection = -1;
    private final HollowCylinderRayIntersection hollowCylinderIntersection = new HollowCylinderRayIntersection();
    private final DiscreteIsoscelesTriangularPrismRayIntersection positiveXArrowIntersection = new DiscreteIsoscelesTriangularPrismRayIntersection();
    private final DiscreteIsoscelesTriangularPrismRayIntersection positiveYArrowIntersection = new DiscreteIsoscelesTriangularPrismRayIntersection();
    private final DiscreteIsoscelesTriangularPrismRayIntersection negativeXArrowIntersection = new DiscreteIsoscelesTriangularPrismRayIntersection();
    private final DiscreteIsoscelesTriangularPrismRayIntersection negativeYArrowIntersection = new DiscreteIsoscelesTriangularPrismRayIntersection();
    private final Pose3D pose = new Pose3D();
    private final RigidBodyTransform transform = new RigidBodyTransform();
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private boolean dragging = false;
    private FocusBasedGDXCamera camera3D;
    private final Point3D cameraPosition = new Point3D();
    private double lastDistanceToCamera = -1.0;
    private final Plane3D dragPlane = new Plane3D();
    private final Point3D dragPoint = new Point3D();
    private final Vector3D dragVector = new Vector3D();

    public void create(FocusBasedGDXCamera camera3D) {
        this.camera3D = camera3D;
        this.normalDiscMaterial = new Material();
        this.normalDiscMaterial.set((Attribute)TextureAttribute.createDiffuse((Texture)GDXMultiColorMeshBuilder.loadPaletteTexture()));
        this.normalDiscMaterial.set((Attribute)new BlendingAttribute(true, GDXFootstepPlannerGoalGizmo.DISC_NORMAL_COLOR.a));
        this.normalArrowMaterial = new Material();
        this.normalArrowMaterial.set((Attribute)TextureAttribute.createDiffuse((Texture)GDXMultiColorMeshBuilder.loadPaletteTexture()));
        this.normalArrowMaterial.set((Attribute)new BlendingAttribute(true, GDXFootstepPlannerGoalGizmo.ARROW_NORMAL_COLOR.a));
        this.highlightedDiscMaterial = new Material();
        this.highlightedDiscMaterial.set((Attribute)TextureAttribute.createDiffuse((Texture)GDXMultiColorMeshBuilder.loadPaletteTexture()));
        this.highlightedDiscMaterial.set((Attribute)new BlendingAttribute(true, GDXFootstepPlannerGoalGizmo.DISC_HIGHLIGHTED_COLOR.a));
        this.highlightedArrowMaterial = new Material();
        this.highlightedArrowMaterial.set((Attribute)TextureAttribute.createDiffuse((Texture)GDXMultiColorMeshBuilder.loadPaletteTexture()));
        this.highlightedArrowMaterial.set((Attribute)new BlendingAttribute(true, GDXFootstepPlannerGoalGizmo.ARROW_HIGHLIGHTED_COLOR.a));
        this.discModel.setMesh(meshBuilder -> meshBuilder.addHollowCylinder(this.discThickness.get(), this.discOuterRadius.get(), this.discInnerRadius.get(), (Tuple3DReadOnly)new Point3D(0.0, 0.0, (double)(-this.discThickness.get()) / 2.0), DISC_NORMAL_COLOR));
        this.positiveXArrowModel.setMesh(meshBuilder -> meshBuilder.addIsoscelesTriangularPrism(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D((double)(this.discOuterRadius.get() + this.arrowSpacing.get()), 0.0, 0.0), (Orientation3DReadOnly)new YawPitchRoll(-1.5707963267948966, 0.0, -1.5707963267948966), ARROW_NORMAL_COLOR));
        this.positiveYArrowModel.setMesh(meshBuilder -> meshBuilder.addIsoscelesTriangularPrism(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D(0.0, (double)(this.discOuterRadius.get() + this.arrowSpacing.get()), 0.0), (Orientation3DReadOnly)new YawPitchRoll(0.0, 0.0, -1.5707963267948966), ARROW_NORMAL_COLOR));
        this.negativeXArrowModel.setMesh(meshBuilder -> meshBuilder.addIsoscelesTriangularPrism(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D((double)(-this.discOuterRadius.get() - this.arrowSpacing.get()), 0.0, 0.0), (Orientation3DReadOnly)new YawPitchRoll(1.5707963267948966, 0.0, -1.5707963267948966), ARROW_NORMAL_COLOR));
        this.negativeYArrowModel.setMesh(meshBuilder -> meshBuilder.addIsoscelesTriangularPrism(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D(0.0, (double)(-this.discOuterRadius.get() - this.arrowSpacing.get()), 0.0), (Orientation3DReadOnly)new YawPitchRoll(0.0, 0.0, 1.5707963267948966), ARROW_NORMAL_COLOR));
        this.recreateGraphics();
    }

    public void process3DViewInput(ImGui3DViewInput input) {
        Line3DReadOnly pickRay;
        this.updateFromSourceTransform();
        boolean rightMouseDown = ImGui.getIO().getMouseDown(1);
        boolean isWindowHovered = ImGui.isWindowHovered();
        if (!rightMouseDown) {
            this.dragging = false;
        }
        if (isWindowHovered && !this.dragging) {
            pickRay = input.getPickRayInWorld();
            this.determineCurrentSelectionFromPickRay(pickRay);
            if (rightMouseDown) {
                this.dragging = true;
            }
        }
        if (this.dragging) {
            pickRay = input.getPickRayInWorld();
            if (this.closestCollisionSelection == 0) {
                this.dragPlane.set((Point3DReadOnly)this.closestCollision, (Vector3DReadOnly)Axis3D.Z);
                this.dragPlane.intersectionWith(pickRay, (Point3DBasics)this.dragPoint);
                this.dragVector.sub((Tuple3DReadOnly)this.dragPoint, (Tuple3DReadOnly)this.closestCollision);
                this.transform.getTranslation().add((Tuple3DReadOnly)this.dragVector);
                this.closestCollision.add((Tuple3DReadOnly)this.dragVector);
            }
        }
        this.updateFromSourceTransform();
        GDXTools.toEuclid(this.camera3D.position, (Point3DBasics)this.cameraPosition);
        double distanceToCamera = this.cameraPosition.distance((Point3DReadOnly)this.pose.getPosition());
        if (this.lastDistanceToCamera != distanceToCamera) {
            this.lastDistanceToCamera = distanceToCamera;
            this.recreateGraphics();
            this.updateFromSourceTransform();
        }
    }

    private void updateFromSourceTransform() {
        this.pose.set((RigidBodyTransformReadOnly)this.transform);
        GDXTools.toGDX(this.transform, this.discModel.getOrCreateModelInstance().transform);
        GDXTools.toGDX(this.transform, this.positiveXArrowModel.getOrCreateModelInstance().transform);
        GDXTools.toGDX(this.transform, this.positiveYArrowModel.getOrCreateModelInstance().transform);
        GDXTools.toGDX(this.transform, this.negativeXArrowModel.getOrCreateModelInstance().transform);
        GDXTools.toGDX(this.transform, this.negativeYArrowModel.getOrCreateModelInstance().transform);
    }

    private void determineCurrentSelectionFromPickRay(Line3DReadOnly pickRay) {
        this.closestCollisionSelection = -1;
        double closestCollisionDistance = Double.POSITIVE_INFINITY;
        this.hollowCylinderIntersection.setup(this.discThickness.get(), this.discOuterRadius.get(), this.discInnerRadius.get(), 0.0, (RigidBodyTransformReadOnly)this.transform);
        double distance = this.hollowCylinderIntersection.intersect(pickRay);
        if (!Double.isNaN(distance) && distance < closestCollisionDistance) {
            closestCollisionDistance = distance;
            this.closestCollisionSelection = 0;
            this.closestCollision.set(this.hollowCylinderIntersection.getClosestIntersection());
        }
        this.positiveXArrowIntersection.setup(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D((double)(this.discOuterRadius.get() + this.arrowSpacing.get()), 0.0, 0.0), (Orientation3DReadOnly)new YawPitchRoll(-1.5707963267948966, 0.0, -1.5707963267948966), (RigidBodyTransformReadOnly)this.transform);
        distance = this.positiveXArrowIntersection.intersect(pickRay, 100);
        if (!Double.isNaN(distance) && distance < closestCollisionDistance) {
            closestCollisionDistance = distance;
            this.closestCollisionSelection = 1;
            this.closestCollision.set(this.positiveXArrowIntersection.getClosestIntersection());
        }
        this.positiveYArrowIntersection.setup(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D(0.0, (double)(this.discOuterRadius.get() + this.arrowSpacing.get()), 0.0), (Orientation3DReadOnly)new YawPitchRoll(0.0, 0.0, -1.5707963267948966), (RigidBodyTransformReadOnly)this.transform);
        distance = this.positiveYArrowIntersection.intersect(pickRay, 100);
        if (!Double.isNaN(distance) && distance < closestCollisionDistance) {
            closestCollisionDistance = distance;
            this.closestCollisionSelection = 2;
            this.closestCollision.set(this.positiveYArrowIntersection.getClosestIntersection());
        }
        this.negativeXArrowIntersection.setup(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D((double)(-this.discOuterRadius.get() - this.arrowSpacing.get()), 0.0, 0.0), (Orientation3DReadOnly)new YawPitchRoll(1.5707963267948966, 0.0, -1.5707963267948966), (RigidBodyTransformReadOnly)this.transform);
        distance = this.negativeXArrowIntersection.intersect(pickRay, 100);
        if (!Double.isNaN(distance) && distance < closestCollisionDistance) {
            closestCollisionDistance = distance;
            this.closestCollisionSelection = 3;
            this.closestCollision.set(this.negativeXArrowIntersection.getClosestIntersection());
        }
        this.negativeYArrowIntersection.setup(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D(0.0, (double)(-this.discOuterRadius.get() - this.arrowSpacing.get()), 0.0), (Orientation3DReadOnly)new YawPitchRoll(0.0, 0.0, 1.5707963267948966), (RigidBodyTransformReadOnly)this.transform);
        distance = this.negativeYArrowIntersection.intersect(pickRay, 100);
        if (!Double.isNaN(distance) && distance < closestCollisionDistance) {
            closestCollisionDistance = distance;
            this.closestCollisionSelection = 4;
            this.closestCollision.set(this.negativeYArrowIntersection.getClosestIntersection());
        }
        this.updateMaterialHighlighting();
    }

    private void updateMaterialHighlighting() {
        this.discModel.setMaterial(this.closestCollisionSelection == 0 ? this.highlightedDiscMaterial : this.normalDiscMaterial);
        this.positiveXArrowModel.setMaterial(this.closestCollisionSelection == 1 ? this.highlightedArrowMaterial : this.normalArrowMaterial);
        this.positiveYArrowModel.setMaterial(this.closestCollisionSelection == 2 ? this.highlightedArrowMaterial : this.normalArrowMaterial);
        this.negativeXArrowModel.setMaterial(this.closestCollisionSelection == 3 ? this.highlightedArrowMaterial : this.normalArrowMaterial);
        this.negativeYArrowModel.setMaterial(this.closestCollisionSelection == 4 ? this.highlightedArrowMaterial : this.normalArrowMaterial);
    }

    public ImGuiPanel createTunerPanel(String name) {
        return new ImGuiPanel("Footstep Ring Gizmo Tuner (" + name + ")", this::renderImGuiTuner);
    }

    public void renderImGuiTuner() {
        ImGui.text((String)"Use the right mouse button to manipulate the widget.");
        if (ImGui.button((String)"Reset")) {
            this.transform.setToZero();
        }
        ImGui.pushItemWidth((float)100.0f);
        boolean proportionsChanged = false;
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Disc outer radius"), (float[])this.discOuterRadius.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Disc inner radius"), (float[])this.discInnerRadius.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Disc thickness"), (float[])this.discThickness.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Arrow width"), (float[])this.arrowWidth.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Arrow height"), (float[])this.arrowHeight.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        ImGui.popItemWidth();
        if (proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Arrow spacing"), (float[])this.arrowSpacing.getData(), (float)0.001f, (float)0.0f, (float)1000.0f)) {
            this.recreateGraphics();
        }
        this.updateFromSourceTransform();
    }

    private void recreateGraphics() {
        this.updateMaterialHighlighting();
        this.discModel.invalidateMesh();
        this.positiveXArrowModel.invalidateMesh();
        this.positiveYArrowModel.invalidateMesh();
        this.negativeXArrowModel.invalidateMesh();
        this.negativeYArrowModel.invalidateMesh();
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        this.discModel.getOrCreateModelInstance().getRenderables(renderables, pool);
        this.positiveXArrowModel.getOrCreateModelInstance().getRenderables(renderables, pool);
        this.positiveYArrowModel.getOrCreateModelInstance().getRenderables(renderables, pool);
        this.negativeXArrowModel.getOrCreateModelInstance().getRenderables(renderables, pool);
        this.negativeYArrowModel.getOrCreateModelInstance().getRenderables(renderables, pool);
    }

    public Pose3DReadOnly getPose() {
        return this.pose;
    }

    public RigidBodyTransform getTransform() {
        return this.transform;
    }

    static {
        GDXFootstepPlannerGoalGizmo.DISC_NORMAL_COLOR.a = 0.4f;
        GDXFootstepPlannerGoalGizmo.ARROW_NORMAL_COLOR.a = 0.4f;
        GDXFootstepPlannerGoalGizmo.DISC_HIGHLIGHTED_COLOR.a = 0.9f;
        GDXFootstepPlannerGoalGizmo.ARROW_HIGHLIGHTED_COLOR.a = 0.9f;
    }
}

