/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.ui.gizmo;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class ClockFaceRotation3DMouseDragAlgorithm {
    private final Line3D axisLineAtObjectZero = new Line3D();
    private final Plane3D pickClockPlane = new Plane3D();
    private final Point3D clockCenter = new Point3D();
    private final Point3D clockHandTipInWorld = new Point3D();
    private final Point3D previousClockHandTipInWorld = new Point3D();
    private final Vector3D clockHand = new Vector3D();
    private final Vector3D previousClockHand = new Vector3D();
    private final Vector3D crossProduct = new Vector3D();
    private final AxisAngle axisAngleToRotateBy = new AxisAngle();

    public void reset() {
        this.previousClockHandTipInWorld.setToNaN();
    }

    public boolean calculate(Line3DReadOnly pickRay, Point3D objectRayCollision, RotationMatrix axisOrientationInObjectFrame, RigidBodyTransformReadOnly objectTransform) {
        this.axisLineAtObjectZero.getPoint().set(objectTransform.getTranslation());
        this.axisLineAtObjectZero.getDirection().set((UnitVector3DReadOnly)Axis3D.Z);
        axisOrientationInObjectFrame.transform((Tuple3DBasics)this.axisLineAtObjectZero.getDirection());
        objectTransform.getRotation().transform((Tuple3DBasics)this.axisLineAtObjectZero.getDirection());
        boolean hasMotion = false;
        if (this.previousClockHandTipInWorld.containsNaN()) {
            this.pickClockPlane.set((Point3DReadOnly)objectRayCollision, (Vector3DReadOnly)this.axisLineAtObjectZero.getDirection());
            this.pickClockPlane.intersectionWith((Line3DReadOnly)this.axisLineAtObjectZero, (Point3DBasics)this.clockCenter);
            this.pickClockPlane.getPoint().set((Tuple3DReadOnly)this.clockCenter);
            this.previousClockHandTipInWorld.set(objectRayCollision);
        } else {
            this.pickClockPlane.intersectionWith((Point3DBasics)this.clockHandTipInWorld, pickRay.getPoint(), (Vector3DReadOnly)pickRay.getDirection());
            this.clockHand.set(this.clockHandTipInWorld.getX() - this.pickClockPlane.getPoint().getX(), this.clockHandTipInWorld.getY() - this.pickClockPlane.getPoint().getY(), this.clockHandTipInWorld.getZ() - this.pickClockPlane.getPoint().getZ());
            this.previousClockHand.set(this.previousClockHandTipInWorld.getX() - this.pickClockPlane.getPoint().getX(), this.previousClockHandTipInWorld.getY() - this.pickClockPlane.getPoint().getY(), this.previousClockHandTipInWorld.getZ() - this.pickClockPlane.getPoint().getZ());
            double angleFromPreviousToCurrentHand = EuclidGeometryTools.angleFromFirstToSecondVector3D((double)this.previousClockHand.getX(), (double)this.previousClockHand.getY(), (double)this.previousClockHand.getZ(), (double)this.clockHand.getX(), (double)this.clockHand.getY(), (double)this.clockHand.getZ());
            hasMotion = !Double.isNaN(angleFromPreviousToCurrentHand);
            if (hasMotion) {
                this.crossProduct.cross((Tuple3DReadOnly)this.previousClockHand, (Tuple3DReadOnly)this.clockHand);
                if (this.crossProduct.dot((Vector3DReadOnly)this.pickClockPlane.getNormal()) < 0.0) {
                    angleFromPreviousToCurrentHand = -angleFromPreviousToCurrentHand;
                }
                this.axisAngleToRotateBy.set((Vector3DReadOnly)this.pickClockPlane.getNormal(), angleFromPreviousToCurrentHand);
            }
            this.previousClockHandTipInWorld.set(this.clockHandTipInWorld);
        }
        return hasMotion;
    }

    public AxisAngle getMotion() {
        return this.axisAngleToRotateBy;
    }
}

