/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.ui.gizmo;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.gdx.ui.gizmo.CylinderRayIntersection;
import us.ihmc.gdx.ui.gizmo.SphereRayIntersection;

public class CapsuleRayIntersection {
    private final SphereRayIntersection sphereIntersectionPositiveEnd = new SphereRayIntersection();
    private final SphereRayIntersection sphereIntersectionNegativeEnd = new SphereRayIntersection();
    private final CylinderRayIntersection cylinderIntersection = new CylinderRayIntersection();
    private final Vector3D tempVector = new Vector3D();
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();

    public void setup(double radius, double length, Point3DReadOnly position, UnitVector3DReadOnly axis, RigidBodyTransform transformToWorld) {
        this.tempTransform.set(transformToWorld);
        this.tempVector.set((Tuple3DReadOnly)axis);
        transformToWorld.transform((Vector3DBasics)this.tempVector);
        this.tempVector.scale(length / 2.0);
        this.tempTransform.appendTranslation((Tuple3DReadOnly)this.tempVector);
        this.sphereIntersectionPositiveEnd.setup(radius, (RigidBodyTransformReadOnly)this.tempTransform);
        this.tempVector.scale(-2.0);
        this.tempTransform.appendTranslation((Tuple3DReadOnly)this.tempVector);
        this.sphereIntersectionNegativeEnd.setup(radius, (RigidBodyTransformReadOnly)this.tempTransform);
        this.cylinderIntersection.setup(length, radius, (RigidBodyTransformReadOnly)transformToWorld);
    }

    public boolean intersect(Line3DReadOnly pickRay) {
        boolean intersects = false;
        intersects |= this.sphereIntersectionPositiveEnd.intersect(pickRay);
        intersects |= this.sphereIntersectionNegativeEnd.intersect(pickRay);
        double closestDistance = this.cylinderIntersection.intersect(pickRay);
        return intersects |= !Double.isNaN(closestDistance);
    }
}

