/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.ui.gizmo;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;

public class BoxRayIntersection {
    private final RigidBodyTransform boxToWorldTransform = new RigidBodyTransform();
    private final ReferenceFrame boxFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((String)"boxFrame", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)this.boxToWorldTransform);
    private final FramePoint3D rayOrigin = new FramePoint3D();
    private final FrameVector3D rayDirection = new FrameVector3D();
    private final Point3D boundingBoxMin = new Point3D();
    private final Point3D boundingBoxMax = new Point3D();
    private Point3DBasics firstIntersectionToPack;
    private Point3DBasics secondIntersectionToPack;

    public boolean intersect(double sizeX, double sizeY, double sizeZ, Pose3DReadOnly poseInWorld, Line3DReadOnly pickRay) {
        this.boxToWorldTransform.set((Orientation3DReadOnly)poseInWorld.getOrientation(), (Tuple3DReadOnly)poseInWorld.getPosition());
        this.boxFrame.update();
        this.rayOrigin.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)pickRay.getPoint());
        this.rayDirection.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)pickRay.getDirection());
        this.rayOrigin.changeFrame(this.boxFrame);
        this.rayDirection.changeFrame(this.boxFrame);
        this.boundingBoxMin.set(-sizeX / 2.0, -sizeY / 2.0, -sizeZ / 2.0);
        this.boundingBoxMax.set(sizeX / 2.0, sizeY / 2.0, sizeZ / 2.0);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)this.boundingBoxMin, (Point3DReadOnly)this.boundingBoxMax, (Point3DReadOnly)this.rayOrigin, (Vector3DReadOnly)this.rayDirection, (Point3DBasics)this.firstIntersectionToPack, (Point3DBasics)this.secondIntersectionToPack);
        return numberOfIntersections == 2;
    }

    public Point3DBasics getFirstIntersectionToPack() {
        return this.firstIntersectionToPack;
    }

    public Point3DBasics getSecondIntersectionToPack() {
        return this.secondIntersectionToPack;
    }
}

