/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import imgui.internal.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImInt;
import imgui.type.ImString;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import us.ihmc.commons.FormattingTools;
import us.ihmc.commons.nio.BasicPathVisitor;
import us.ihmc.commons.nio.PathTools;
import us.ihmc.commons.nio.PathVisitor;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.gdx.Lwjgl3ApplicationAdapter;
import us.ihmc.gdx.imgui.GDXImGuiWindowAndDockSystem;
import us.ihmc.gdx.imgui.ImGuiPanelManager;
import us.ihmc.gdx.imgui.ImGuiPanelSizeHandler;
import us.ihmc.gdx.imgui.ImGuiTools;
import us.ihmc.gdx.input.GDXInputMode;
import us.ihmc.gdx.input.ImGui3DViewInput;
import us.ihmc.gdx.sceneManager.GDX3DSceneManager;
import us.ihmc.gdx.sceneManager.GDX3DSceneTools;
import us.ihmc.gdx.sceneManager.GDXSceneLevel;
import us.ihmc.gdx.tools.GDXApplicationCreator;
import us.ihmc.gdx.tools.GDXTools;
import us.ihmc.gdx.vr.GDXVRManager;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.HybridDirectory;
import us.ihmc.tools.io.HybridFile;
import us.ihmc.tools.io.JSONFileTools;

public class GDXImGuiBasedUI {
    private static boolean RECORD_VIDEO = Boolean.parseBoolean(System.getProperty("record.video"));
    public static volatile Object ACTIVE_EDITOR;
    private static final String VIEW_3D_WINDOW_NAME = "3D View";
    private final GDX3DSceneManager sceneManager = new GDX3DSceneManager();
    private final GDXVRManager vrManager = new GDXVRManager();
    private final GDXImGuiWindowAndDockSystem imGuiWindowAndDockSystem;
    private final ArrayList<Runnable> onCloseRequestListeners = new ArrayList();
    private final Class<?> classForLoading;
    private final String directoryNameToAssumePresent;
    private final String subsequentPathToResourceFolder;
    private final String windowTitle;
    private final Path dotIHMCDirectory = Paths.get(System.getProperty("user.home"), ".ihmc");
    private String configurationExtraPath;
    private final HybridDirectory configurationBaseDirectory;
    private HybridDirectory perspectiveDirectory;
    private HybridFile libGDXSettingsFile;
    private final Stopwatch runTime = new Stopwatch().start();
    private String statusText = "";
    private final ImGuiPanelSizeHandler view3DPanelSizeHandler = new ImGuiPanelSizeHandler();
    private ImGui3DViewInput inputCalculator;
    private final ArrayList<Consumer<ImGui3DViewInput>> imGuiInputProcessors = new ArrayList();
    private GLFrameBuffer frameBuffer;
    private float sizeX;
    private float sizeY;
    private final ImInt foregroundFPS = new ImInt(240);
    private final ImBoolean vsync = new ImBoolean(false);
    private final ImInt libGDXLogLevel = new ImInt(GDXTools.toGDX(LogTools.getLevel()));
    private boolean needToReindexPerspectives = true;
    private final ImString perspectiveNameToSave = new ImString("", 100);
    private final ImBoolean perspectiveDefaultMode = new ImBoolean(false);
    private final ArrayList<String> perspectives = new ArrayList();
    private String currentPerspective = "Main";

    public GDXImGuiBasedUI(Class<?> classForLoading, String directoryNameToAssumePresent, String subsequentPathToResourceFolder) {
        this(classForLoading, directoryNameToAssumePresent, subsequentPathToResourceFolder, classForLoading.getSimpleName());
    }

    public GDXImGuiBasedUI(Class<?> classForLoading, String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String windowTitle) {
        this.classForLoading = classForLoading;
        this.directoryNameToAssumePresent = directoryNameToAssumePresent;
        this.subsequentPathToResourceFolder = subsequentPathToResourceFolder;
        this.windowTitle = windowTitle;
        this.configurationExtraPath = "/configurations/" + windowTitle.replaceAll(" ", "");
        this.configurationBaseDirectory = new HybridDirectory(this.dotIHMCDirectory, directoryNameToAssumePresent, subsequentPathToResourceFolder, classForLoading, this.configurationExtraPath);
        this.imGuiWindowAndDockSystem = new GDXImGuiWindowAndDockSystem();
        this.applyPerspectiveDirectory();
        if (RECORD_VIDEO) {
            // empty if block
        }
        this.imGuiWindowAndDockSystem.getPanelManager().addPrimaryPanel(VIEW_3D_WINDOW_NAME);
    }

    public void launchGDXApplication(Lwjgl3ApplicationAdapter applicationAdapter) {
        AtomicReference<Integer> windowWidth = new AtomicReference<Integer>(800);
        AtomicReference<Integer> windowHeight = new AtomicReference<Integer>(600);
        JSONFileTools.loadUserWithClasspathDefaultFallback((HybridFile)this.libGDXSettingsFile, jsonNode -> {
            windowWidth.set(jsonNode.get("windowWidth").asInt());
            windowHeight.set(jsonNode.get("windowHeight").asInt());
        });
        LogTools.info((String)"Launching GDX application");
        GDXApplicationCreator.launchGDXApplication(applicationAdapter, this.windowTitle, windowWidth.get().intValue(), windowHeight.get().intValue());
    }

    public void create() {
        LogTools.info((String)"create()");
        this.sceneManager.create(GDXInputMode.ImGui);
        this.inputCalculator = new ImGui3DViewInput(this.sceneManager.getCamera3D(), this::getViewportSizeX, this::getViewportSizeY);
        Gdx.input.setInputProcessor(null);
        this.imGuiInputProcessors.add(this.sceneManager.getCamera3D()::processImGuiInput);
        double isoZoomOut = 7.0;
        this.sceneManager.getCamera3D().changeCameraPosition(-isoZoomOut, -isoZoomOut, isoZoomOut);
        this.sceneManager.addCoordinateFrame(0.3);
        if (GDXVRManager.isVREnabled()) {
            this.enableVR();
        }
        this.imGuiWindowAndDockSystem.create(((Lwjgl3Graphics)Gdx.graphics).getWindow().getWindowHandle());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Gdx.app.exit(), "Exit" + this.getClass().getSimpleName()));
    }

    private void enableVR() {
        this.vrManager.create(this.sceneManager.getCamera3D());
        this.sceneManager.addRenderableProvider(this.vrManager, GDXSceneLevel.VIRTUAL);
        this.addImGui3DViewInputProcessor(this.vrManager::process3DViewInput);
    }

    public void pollVREvents() {
        if (GDXVRManager.isVREnabled()) {
            this.vrManager.pollEvents();
        }
    }

    public void renderBeforeOnScreenUI() {
        Gdx.graphics.setTitle(this.windowTitle + " - " + Gdx.graphics.getFramesPerSecond() + " FPS");
        GDX3DSceneTools.glClearGray(0.3f);
        this.imGuiWindowAndDockSystem.beforeWindowManagement();
        this.render3DView();
        this.renderMenuBar();
    }

    public void renderEnd() {
        this.imGuiWindowAndDockSystem.afterWindowManagement();
        if (GDXVRManager.isVREnabled()) {
            this.vrManager.render(this.sceneManager);
        }
    }

    private void renderMenuBar() {
        if (this.needToReindexPerspectives) {
            this.needToReindexPerspectives = false;
            Path directory = this.perspectiveDefaultMode.get() ? this.configurationBaseDirectory.getWorkspaceDirectory() : this.configurationBaseDirectory.getExternalDirectory();
            this.perspectives.clear();
            this.perspectives.add("Main");
            PathTools.walkFlat((Path)directory, (PathVisitor)new BasicPathVisitor(){

                public FileVisitResult visitPath(Path path, BasicPathVisitor.PathType pathType) {
                    String matchString;
                    String directoryName;
                    if (pathType == BasicPathVisitor.PathType.DIRECTORY && (directoryName = path.getFileName().toString()).endsWith(matchString = "Perspective")) {
                        String perspectiveName = directoryName.substring(0, directoryName.lastIndexOf(matchString));
                        LogTools.info((String)"Found perspective {}", (Object)perspectiveName);
                        GDXImGuiBasedUI.this.perspectives.add(perspectiveName);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        ImGui.beginMainMenuBar();
        if (ImGui.beginMenu((String)"Perspective")) {
            for (String perspective : this.perspectives) {
                if (ImGui.radioButton((String)perspective, (boolean)this.currentPerspective.equals(perspective))) {
                    this.currentPerspective = perspective;
                    this.applyPerspectiveDirectory();
                    this.imGuiWindowAndDockSystem.loadConfiguration(this.perspectiveDefaultMode.get());
                    Path libGDXFile = this.perspectiveDefaultMode.get() ? this.libGDXSettingsFile.getWorkspaceFile() : this.libGDXSettingsFile.getExternalFile();
                    JSONFileTools.load((Path)libGDXFile, jsonNode -> {
                        int width = jsonNode.get("windowWidth").asInt();
                        int height = jsonNode.get("windowHeight").asInt();
                        Gdx.graphics.setWindowedMode(width, height);
                    });
                }
                if (!this.currentPerspective.equals(perspective)) continue;
                ImGui.sameLine();
                if (!ImGui.button((String)"Save")) continue;
                this.saveApplicationSettings(this.perspectiveDefaultMode.get());
            }
            ImGui.text((String)"New:");
            ImGui.sameLine();
            ImGui.inputText((String)"###", (ImString)this.perspectiveNameToSave, (int)262144);
            String perpectiveNameToCreateString = this.perspectiveNameToSave.get();
            if (!perpectiveNameToCreateString.isEmpty()) {
                ImGui.sameLine();
                if (ImGui.button((String)"Create")) {
                    String sanitizedName = perpectiveNameToCreateString.replaceAll(" ", "");
                    this.perspectives.add(sanitizedName);
                    this.currentPerspective = sanitizedName;
                    this.applyPerspectiveDirectory();
                    this.perspectiveNameToSave.clear();
                }
            }
            ImGui.separator();
            ImGui.text((String)"Save location:");
            if (ImGui.radioButton((String)"User home###PerspectiveUserHomeMode", (!this.perspectiveDefaultMode.get() ? 1 : 0) != 0)) {
                this.perspectiveDefaultMode.set(false);
                this.needToReindexPerspectives = true;
            }
            ImGui.sameLine();
            if (ImGui.radioButton((String)"Version control###PerspectiveDefaultMode", (boolean)this.perspectiveDefaultMode.get())) {
                this.perspectiveDefaultMode.set(true);
                this.needToReindexPerspectives = true;
            }
            ImGui.endMenu();
        }
        if (ImGui.beginMenu((String)"Panels")) {
            this.imGuiWindowAndDockSystem.renderMenuDockPanelItems();
            ImGui.endMenu();
        }
        if (ImGui.beginMenu((String)"Settings")) {
            ImGui.pushItemWidth((float)80.0f);
            if (ImGui.inputInt((String)"Foreground FPS", (ImInt)this.foregroundFPS, (int)1)) {
                Gdx.graphics.setForegroundFPS(this.foregroundFPS.get());
            }
            if (ImGui.checkbox((String)"Vsync", (ImBoolean)this.vsync)) {
                Gdx.graphics.setVSync(this.vsync.get());
            }
            if (ImGui.inputInt((String)"libGDX log level", (ImInt)this.libGDXLogLevel, (int)1)) {
                Gdx.app.setLogLevel(this.libGDXLogLevel.get());
            }
            ImGui.popItemWidth();
            ImGui.endMenu();
        }
        ImGui.sameLine((float)(ImGui.getWindowSizeX() - 170.0f));
        ImGui.text((String)(FormattingTools.getFormattedDecimal2D((double)this.runTime.totalElapsed()) + " s"));
        ImGui.sameLine((float)(ImGui.getWindowSizeX() - 100.0f));
        if (GDXVRManager.isVREnabled()) {
            ImGui.text((String)"VR Enabled");
        } else if (ImGui.button((String)"Enable VR")) {
            this.enableVR();
        }
        if (ImGui.isItemHovered()) {
            ImGui.setTooltip((String)"It is recommended to start SteamVR and power on the VR controllers before clicking this button.");
        }
        ImGui.endMainMenuBar();
    }

    private void render3DView() {
        this.view3DPanelSizeHandler.handleSizeBeforeBegin();
        ImGui.pushStyleVar((int)1, (float)0.0f, (float)0.0f);
        int flags = 0;
        ImGui.begin((String)VIEW_3D_WINDOW_NAME, (int)flags);
        this.view3DPanelSizeHandler.handleSizeAfterBegin();
        int antiAliasing = 2;
        float posX = ImGui.getWindowPosX();
        float posY = ImGui.getWindowPosY() + ImGuiTools.TAB_BAR_HEIGHT;
        this.sizeX = ImGui.getWindowSizeX();
        this.sizeY = ImGui.getWindowSizeY() - ImGuiTools.TAB_BAR_HEIGHT;
        float renderSizeX = this.sizeX * (float)antiAliasing;
        float renderSizeY = this.sizeY * (float)antiAliasing;
        this.inputCalculator.compute();
        for (Consumer<ImGui3DViewInput> imGuiInputProcessor : this.imGuiInputProcessors) {
            imGuiInputProcessor.accept(this.inputCalculator);
        }
        if (this.frameBuffer == null || (float)this.frameBuffer.getWidth() < renderSizeX || (float)this.frameBuffer.getHeight() < renderSizeY) {
            if (this.frameBuffer != null) {
                this.frameBuffer.dispose();
            }
            int newWidth = this.frameBuffer == null ? Gdx.graphics.getWidth() * antiAliasing : this.frameBuffer.getWidth() * 2;
            int newHeight = this.frameBuffer == null ? Gdx.graphics.getHeight() * antiAliasing : this.frameBuffer.getHeight() * 2;
            LogTools.info((String)"Allocating framebuffer of size: {}x{}", (Object)newWidth, (Object)newHeight);
            GLFrameBuffer.FrameBufferBuilder frameBufferBuilder = new GLFrameBuffer.FrameBufferBuilder(newWidth, newHeight);
            frameBufferBuilder.addBasicColorTextureAttachment(Pixmap.Format.RGBA8888);
            frameBufferBuilder.addBasicStencilDepthPackedRenderBuffer();
            this.frameBuffer = frameBufferBuilder.build();
        }
        this.frameBuffer.begin();
        this.sceneManager.setViewportBounds(0, 0, (int)renderSizeX, (int)renderSizeY);
        this.sceneManager.render();
        this.frameBuffer.end();
        float percentOfFramebufferUsedX = renderSizeX / (float)this.frameBuffer.getWidth();
        float percentOfFramebufferUsedY = renderSizeY / (float)this.frameBuffer.getHeight();
        int textureId = this.frameBuffer.getColorBufferTexture().getTextureObjectHandle();
        float pMinX = posX;
        float pMinY = posY;
        float pMaxX = posX + this.sizeX;
        float pMaxY = posY + this.sizeY;
        float uvMinX = 0.0f;
        float uvMinY = percentOfFramebufferUsedY;
        float uvMaxX = percentOfFramebufferUsedX;
        float uvMaxY = 0.0f;
        ImGui.getWindowDrawList().addImage(textureId, pMinX, pMinY, pMaxX, pMaxY, uvMinX, uvMinY, uvMaxX, uvMaxY);
        ImGui.end();
        ImGui.popStyleVar();
    }

    private void applyPerspectiveDirectory() {
        this.perspectiveDirectory = new HybridDirectory(this.dotIHMCDirectory, this.directoryNameToAssumePresent, this.subsequentPathToResourceFolder, this.classForLoading, this.configurationExtraPath + (this.currentPerspective.equals("Main") ? "" : "/" + this.currentPerspective + "Perspective"));
        this.libGDXSettingsFile = new HybridFile(this.perspectiveDirectory, "GDXSettings.json");
        this.imGuiWindowAndDockSystem.setDirectory(this.perspectiveDirectory);
    }

    private void saveApplicationSettings(boolean saveDefault) {
        this.imGuiWindowAndDockSystem.saveConfiguration(saveDefault);
        Consumer<ObjectNode> rootConsumer = root -> {
            root.put("windowWidth", Gdx.graphics.getWidth());
            root.put("windowHeight", Gdx.graphics.getHeight());
        };
        if (saveDefault) {
            LogTools.info((String)"Saving libGDX settings to {}", (Object)this.libGDXSettingsFile.getWorkspaceFile().toString());
            JSONFileTools.save((Path)this.libGDXSettingsFile.getWorkspaceFile(), rootConsumer);
        } else {
            LogTools.info((String)"Saving libGDX settings to {}", (Object)this.libGDXSettingsFile.getExternalFile().toString());
            JSONFileTools.save((Path)this.libGDXSettingsFile.getExternalFile(), rootConsumer);
        }
    }

    public void dispose() {
        this.imGuiWindowAndDockSystem.dispose();
        if (GDXVRManager.isVREnabled()) {
            this.vrManager.dispose();
        }
        this.sceneManager.dispose();
    }

    public void addOnCloseRequestListener(Runnable onCloseRequest) {
        this.onCloseRequestListeners.add(onCloseRequest);
    }

    public void addImGui3DViewInputProcessor(Consumer<ImGui3DViewInput> processImGuiInput) {
        this.imGuiInputProcessors.add(processImGuiInput);
    }

    public void setStatus(String statusText) {
        this.statusText = statusText;
    }

    public ImGuiPanelManager getImGuiPanelManager() {
        return this.imGuiWindowAndDockSystem.getPanelManager();
    }

    public GDX3DSceneManager get3DSceneManager() {
        return this.sceneManager;
    }

    public float getViewportSizeX() {
        return this.sizeX;
    }

    public float getViewportSizeY() {
        return this.sizeY;
    }

    public GDXVRManager getVRManager() {
        return this.vrManager;
    }
}

