/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.tools;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.nio.FloatBuffer;
import javafx.scene.paint.Color;
import org.apache.logging.log4j.Level;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.HmdMatrix44;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.log.LogTools;

public class GDXTools {
    public static void syncLogLevelWithLogTools() {
        Gdx.app.setLogLevel(GDXTools.toGDX(LogTools.getLevel()));
    }

    public static int toGDX(Level log4jLevel) {
        int gdxLogLevel = 2;
        switch (log4jLevel.getStandardLevel()) {
            case OFF: {
                gdxLogLevel = 0;
                break;
            }
            case FATAL: 
            case ERROR: {
                gdxLogLevel = 1;
                break;
            }
            case WARN: 
            case INFO: {
                gdxLogLevel = 2;
                break;
            }
            case DEBUG: 
            case TRACE: {
                gdxLogLevel = 3;
            }
        }
        return gdxLogLevel;
    }

    public static void toGDX(AffineTransform euclidAffine, Matrix4 gdxAffineToPack) {
        gdxAffineToPack.val[0] = (float)euclidAffine.getM00();
        gdxAffineToPack.val[4] = (float)euclidAffine.getM01();
        gdxAffineToPack.val[8] = (float)euclidAffine.getM02();
        gdxAffineToPack.val[1] = (float)euclidAffine.getM10();
        gdxAffineToPack.val[5] = (float)euclidAffine.getM11();
        gdxAffineToPack.val[9] = (float)euclidAffine.getM12();
        gdxAffineToPack.val[2] = (float)euclidAffine.getM20();
        gdxAffineToPack.val[6] = (float)euclidAffine.getM21();
        gdxAffineToPack.val[10] = (float)euclidAffine.getM22();
        gdxAffineToPack.val[12] = (float)euclidAffine.getM03();
        gdxAffineToPack.val[13] = (float)euclidAffine.getM13();
        gdxAffineToPack.val[14] = (float)euclidAffine.getM23();
    }

    public static void toEuclid(Matrix4 gdxAffine, AffineTransform euclidAffine) {
        euclidAffine.getLinearTransform().setM00((double)gdxAffine.val[0]);
        euclidAffine.getLinearTransform().setM01((double)gdxAffine.val[4]);
        euclidAffine.getLinearTransform().setM02((double)gdxAffine.val[8]);
        euclidAffine.getLinearTransform().setM10((double)gdxAffine.val[1]);
        euclidAffine.getLinearTransform().setM11((double)gdxAffine.val[5]);
        euclidAffine.getLinearTransform().setM12((double)gdxAffine.val[9]);
        euclidAffine.getLinearTransform().setM20((double)gdxAffine.val[2]);
        euclidAffine.getLinearTransform().setM21((double)gdxAffine.val[6]);
        euclidAffine.getLinearTransform().setM22((double)gdxAffine.val[10]);
        euclidAffine.getLinearTransform().normalize();
        euclidAffine.getTranslation().setX((double)gdxAffine.val[12]);
        euclidAffine.getTranslation().setY((double)gdxAffine.val[13]);
        euclidAffine.getTranslation().setZ((double)gdxAffine.val[14]);
    }

    public static void toEuclid(Matrix4 gdxAffine, RotationMatrix euclidRotationMatrix) {
        euclidRotationMatrix.setAndNormalize((double)gdxAffine.val[0], (double)gdxAffine.val[4], (double)gdxAffine.val[8], (double)gdxAffine.val[1], (double)gdxAffine.val[5], (double)gdxAffine.val[9], (double)gdxAffine.val[2], (double)gdxAffine.val[6], (double)gdxAffine.val[10]);
    }

    public static void toGDX(RigidBodyTransform rigidBodyTransform, Matrix4 gdxAffineToPack) {
        gdxAffineToPack.val[0] = (float)rigidBodyTransform.getM00();
        gdxAffineToPack.val[4] = (float)rigidBodyTransform.getM01();
        gdxAffineToPack.val[8] = (float)rigidBodyTransform.getM02();
        gdxAffineToPack.val[1] = (float)rigidBodyTransform.getM10();
        gdxAffineToPack.val[5] = (float)rigidBodyTransform.getM11();
        gdxAffineToPack.val[9] = (float)rigidBodyTransform.getM12();
        gdxAffineToPack.val[2] = (float)rigidBodyTransform.getM20();
        gdxAffineToPack.val[6] = (float)rigidBodyTransform.getM21();
        gdxAffineToPack.val[10] = (float)rigidBodyTransform.getM22();
        gdxAffineToPack.val[12] = (float)rigidBodyTransform.getM03();
        gdxAffineToPack.val[13] = (float)rigidBodyTransform.getM13();
        gdxAffineToPack.val[14] = (float)rigidBodyTransform.getM23();
    }

    public static void toGDX(HmdMatrix44 openVRProjectionMatrix, Matrix4 gdxProjectionMatrixToPack) {
        FloatBuffer openVRValueBuffer = openVRProjectionMatrix.m();
        gdxProjectionMatrixToPack.val[0] = openVRValueBuffer.get(0);
        gdxProjectionMatrixToPack.val[1] = openVRValueBuffer.get(4);
        gdxProjectionMatrixToPack.val[2] = openVRValueBuffer.get(8);
        gdxProjectionMatrixToPack.val[3] = openVRValueBuffer.get(12);
        gdxProjectionMatrixToPack.val[4] = openVRValueBuffer.get(1);
        gdxProjectionMatrixToPack.val[5] = openVRValueBuffer.get(5);
        gdxProjectionMatrixToPack.val[6] = openVRValueBuffer.get(9);
        gdxProjectionMatrixToPack.val[7] = openVRValueBuffer.get(13);
        gdxProjectionMatrixToPack.val[8] = openVRValueBuffer.get(2);
        gdxProjectionMatrixToPack.val[9] = openVRValueBuffer.get(6);
        gdxProjectionMatrixToPack.val[10] = openVRValueBuffer.get(10);
        gdxProjectionMatrixToPack.val[11] = openVRValueBuffer.get(14);
        gdxProjectionMatrixToPack.val[12] = openVRValueBuffer.get(3);
        gdxProjectionMatrixToPack.val[13] = openVRValueBuffer.get(7);
        gdxProjectionMatrixToPack.val[14] = openVRValueBuffer.get(11);
        gdxProjectionMatrixToPack.val[15] = openVRValueBuffer.get(15);
    }

    public static void toGDX(HmdMatrix34 openVRRigidBodyTransform, Matrix4 gdxAffineToPack) {
        FloatBuffer openVRValueBuffer = openVRRigidBodyTransform.m();
        gdxAffineToPack.val[0] = openVRValueBuffer.get(0);
        gdxAffineToPack.val[1] = openVRValueBuffer.get(4);
        gdxAffineToPack.val[2] = openVRValueBuffer.get(8);
        gdxAffineToPack.val[3] = 0.0f;
        gdxAffineToPack.val[4] = openVRValueBuffer.get(1);
        gdxAffineToPack.val[5] = openVRValueBuffer.get(5);
        gdxAffineToPack.val[6] = openVRValueBuffer.get(9);
        gdxAffineToPack.val[7] = 0.0f;
        gdxAffineToPack.val[8] = openVRValueBuffer.get(2);
        gdxAffineToPack.val[9] = openVRValueBuffer.get(6);
        gdxAffineToPack.val[10] = openVRValueBuffer.get(10);
        gdxAffineToPack.val[11] = 0.0f;
        gdxAffineToPack.val[12] = openVRValueBuffer.get(3);
        gdxAffineToPack.val[13] = openVRValueBuffer.get(7);
        gdxAffineToPack.val[14] = openVRValueBuffer.get(11);
        gdxAffineToPack.val[15] = 1.0f;
    }

    public static void toEuclid(HmdMatrix34 openVRRigidBodyTransform, RigidBodyTransform rigidBodyTransformToPack) {
        FloatBuffer openVRValueBuffer = openVRRigidBodyTransform.m();
        rigidBodyTransformToPack.getRotation().setAndNormalize((double)openVRValueBuffer.get(0), (double)openVRValueBuffer.get(1), (double)openVRValueBuffer.get(2), (double)openVRValueBuffer.get(4), (double)openVRValueBuffer.get(5), (double)openVRValueBuffer.get(6), (double)openVRValueBuffer.get(8), (double)openVRValueBuffer.get(9), (double)openVRValueBuffer.get(10));
        rigidBodyTransformToPack.getTranslation().setX((double)openVRValueBuffer.get(3));
        rigidBodyTransformToPack.getTranslation().setY((double)openVRValueBuffer.get(7));
        rigidBodyTransformToPack.getTranslation().setZ((double)openVRValueBuffer.get(11));
    }

    public static void toEuclid(HmdMatrix34 openVRRigidBodyTransform, Pose3DBasics poseToPack) {
        FloatBuffer openVRValueBuffer = openVRRigidBodyTransform.m();
        poseToPack.getOrientation().setRotationMatrix((double)openVRValueBuffer.get(0), (double)openVRValueBuffer.get(1), (double)openVRValueBuffer.get(2), (double)openVRValueBuffer.get(4), (double)openVRValueBuffer.get(5), (double)openVRValueBuffer.get(6), (double)openVRValueBuffer.get(8), (double)openVRValueBuffer.get(9), (double)openVRValueBuffer.get(10));
        poseToPack.getOrientation().normalize();
        poseToPack.getPosition().setX((double)openVRValueBuffer.get(3));
        poseToPack.getPosition().setY((double)openVRValueBuffer.get(7));
        poseToPack.getPosition().setZ((double)openVRValueBuffer.get(11));
    }

    public static void toEuclid(HmdMatrix34 openVRAffineTransform, AffineTransform euclidAffine) {
        FloatBuffer openVRValueBuffer = openVRAffineTransform.m();
        euclidAffine.getLinearTransform().setM00((double)openVRValueBuffer.get(0));
        euclidAffine.getLinearTransform().setM01((double)openVRValueBuffer.get(1));
        euclidAffine.getLinearTransform().setM02((double)openVRValueBuffer.get(2));
        euclidAffine.getLinearTransform().setM10((double)openVRValueBuffer.get(4));
        euclidAffine.getLinearTransform().setM11((double)openVRValueBuffer.get(5));
        euclidAffine.getLinearTransform().setM12((double)openVRValueBuffer.get(6));
        euclidAffine.getLinearTransform().setM20((double)openVRValueBuffer.get(8));
        euclidAffine.getLinearTransform().setM21((double)openVRValueBuffer.get(9));
        euclidAffine.getLinearTransform().setM22((double)openVRValueBuffer.get(10));
        euclidAffine.getLinearTransform().normalize();
        euclidAffine.getTranslation().setX((double)openVRValueBuffer.get(3));
        euclidAffine.getTranslation().setY((double)openVRValueBuffer.get(7));
        euclidAffine.getTranslation().setZ((double)openVRValueBuffer.get(11));
    }

    public static void toEuclid(Matrix4 gdxAffine, RigidBodyTransform rigidBodyTransform) {
        rigidBodyTransform.getRotation().setAndNormalize((double)gdxAffine.val[0], (double)gdxAffine.val[4], (double)gdxAffine.val[8], (double)gdxAffine.val[1], (double)gdxAffine.val[5], (double)gdxAffine.val[9], (double)gdxAffine.val[2], (double)gdxAffine.val[6], (double)gdxAffine.val[10]);
        rigidBodyTransform.getTranslation().setX((double)gdxAffine.val[12]);
        rigidBodyTransform.getTranslation().setY((double)gdxAffine.val[13]);
        rigidBodyTransform.getTranslation().setZ((double)gdxAffine.val[14]);
    }

    public static void toGDX(RotationMatrix euclidRotationMatrix, Matrix4 gdxRotationMatrix) {
        gdxRotationMatrix.val[0] = (float)euclidRotationMatrix.getM00();
        gdxRotationMatrix.val[4] = (float)euclidRotationMatrix.getM01();
        gdxRotationMatrix.val[8] = (float)euclidRotationMatrix.getM02();
        gdxRotationMatrix.val[1] = (float)euclidRotationMatrix.getM10();
        gdxRotationMatrix.val[5] = (float)euclidRotationMatrix.getM11();
        gdxRotationMatrix.val[9] = (float)euclidRotationMatrix.getM12();
        gdxRotationMatrix.val[2] = (float)euclidRotationMatrix.getM20();
        gdxRotationMatrix.val[6] = (float)euclidRotationMatrix.getM21();
        gdxRotationMatrix.val[10] = (float)euclidRotationMatrix.getM22();
    }

    public static Vector3 toGDX(Tuple3DReadOnly euclidTuple) {
        return new Vector3(euclidTuple.getX32(), euclidTuple.getY32(), euclidTuple.getZ32());
    }

    public static Vector2 toGDX(Tuple2DReadOnly euclidTuple) {
        return new Vector2(euclidTuple.getX32(), euclidTuple.getY32());
    }

    public static void toGDX(Tuple3DReadOnly euclidTuple, Vector3 gdxVector3) {
        gdxVector3.set(euclidTuple.getX32(), euclidTuple.getY32(), euclidTuple.getZ32());
    }

    public static void toEuclid(Vector3 gdxVector3, Vector3DBasics euclidVector3D32) {
        euclidVector3D32.set((double)gdxVector3.x, (double)gdxVector3.y, (double)gdxVector3.z);
    }

    public static void toEuclid(Vector3 gdxVector3, Point3DBasics euclidPoint3D32) {
        euclidPoint3D32.set((double)gdxVector3.x, (double)gdxVector3.y, (double)gdxVector3.z);
    }

    public static void toEuclid(Matrix4 gdxAffine, Point3DBasics euclidPoint) {
        euclidPoint.set((double)gdxAffine.val[12], (double)gdxAffine.val[13], (double)gdxAffine.val[14]);
    }

    public static void toGDX(Point3DReadOnly euclidPoint, Matrix4 gdxAffine) {
        gdxAffine.setTranslation(euclidPoint.getX32(), euclidPoint.getY32(), euclidPoint.getZ32());
    }

    public static void toGDX(Pose3DReadOnly euclidPose, RigidBodyTransform tempTransform, Matrix4 gdxAffine) {
        euclidPose.get((RigidBodyTransformBasics)tempTransform);
        GDXTools.toGDX(tempTransform, gdxAffine);
    }

    public static void toGDX(Color javaFXColor, com.badlogic.gdx.graphics.Color gdxColor) {
        gdxColor.set((float)javaFXColor.getRed(), (float)javaFXColor.getGreen(), (float)javaFXColor.getBlue(), (float)javaFXColor.getOpacity());
    }

    public static com.badlogic.gdx.graphics.Color toGDX(Color javaFXColor) {
        return new com.badlogic.gdx.graphics.Color((float)javaFXColor.getRed(), (float)javaFXColor.getGreen(), (float)javaFXColor.getBlue(), (float)javaFXColor.getOpacity());
    }

    public static Color toJavaFX(com.badlogic.gdx.graphics.Color gdxColor) {
        return Color.color((double)gdxColor.r, (double)gdxColor.g, (double)gdxColor.b, (double)gdxColor.a);
    }

    public static com.badlogic.gdx.graphics.Color hueSaturationValue(double hue, double saturation, double value) {
        return new com.badlogic.gdx.graphics.Color().fromHsv((float)hue, (float)saturation, (float)value);
    }

    public static com.badlogic.gdx.graphics.Color toGDX(AppearanceDefinition appearanceDefinition) {
        com.badlogic.gdx.graphics.Color gdxColor = new com.badlogic.gdx.graphics.Color(1.0f, 1.0f, 1.0f, 1.0f);
        GDXTools.toGDX(appearanceDefinition, gdxColor);
        return gdxColor;
    }

    public static com.badlogic.gdx.graphics.Color toGDX(double red, double green, double blue, double alpha) {
        return new com.badlogic.gdx.graphics.Color((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void toGDX(AppearanceDefinition appearanceDefinition, com.badlogic.gdx.graphics.Color gdxColor) {
        gdxColor.r = appearanceDefinition.getColor().getX();
        gdxColor.g = appearanceDefinition.getColor().getY();
        gdxColor.b = appearanceDefinition.getColor().getZ();
        gdxColor.a = 1.0f - (float)appearanceDefinition.getTransparency();
    }

    public static void setTransparency(ModelInstance modelInstance, float transparency) {
        ((Material)modelInstance.materials.get(0)).set((Attribute)new BlendingAttribute(true, transparency));
    }
}

