/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.tools;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.loader.G3dModelLoader;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.JsonReader;
import java.util.HashMap;

public class GDXModelLoader {
    private static final GDXModelLoader modelLoader = new GDXModelLoader();
    private final HashMap<String, Model> loadedModels = new HashMap();

    private GDXModelLoader() {
    }

    private Model loadOrGetModel(String modelFileName) {
        Model model = this.loadedModels.get(modelFileName);
        if (model == null) {
            FileHandle fileHandle = Gdx.files.internal(modelFileName);
            try {
                Model loadedModel = new G3dModelLoader((BaseJsonReader)new JsonReader()).loadModel(fileHandle);
                this.loadedModels.put(modelFileName, loadedModel);
                return loadedModel;
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        return model;
    }

    private void destroyInternal() {
        for (Model loadedModel : this.loadedModels.values()) {
            loadedModel.dispose();
        }
        this.loadedModels.clear();
    }

    public static String modifyFileName(String modelFileName) {
        if (!modelFileName.endsWith(".obj")) {
            return null;
        }
        String[] splitSlash = modelFileName.split("/");
        String objFileName = splitSlash[splitSlash.length - 1];
        String modifiedFileName = objFileName.replace(".obj", "") + ".g3dj";
        return modifiedFileName;
    }

    public static Model loadG3DModel(String modelFileName) {
        return modelLoader.loadOrGetModel(modelFileName);
    }

    public static void destroy() {
        modelLoader.destroyInternal();
    }
}

