/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.simulation;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.graphics.glutils.SensorFrameBuffer;
import com.badlogic.gdx.graphics.glutils.SensorFrameBufferBuilder;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import imgui.internal.ImGui;
import imgui.type.ImFloat;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Random;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.gdx.imgui.ImGuiTools;
import us.ihmc.gdx.imgui.ImGuiVideoPanel;
import us.ihmc.gdx.sceneManager.GDX3DSceneManager;
import us.ihmc.gdx.sceneManager.GDXSceneLevel;
import us.ihmc.gdx.tools.GDXTools;
import us.ihmc.tools.Timer;
import us.ihmc.tools.UnitConversions;

public class GDXLowLevelDepthSensorSimulator {
    private final String depthWindowName;
    private final String colorWindowName;
    private final Random random = new Random();
    private final float fieldOfViewY;
    private final int imageWidth;
    private final int imageHeight;
    private final float minRange;
    private final float maxRange;
    private final double updatePeriod;
    private final Timer throttleTimer = new Timer();
    private final Vector3 depthPoint = new Vector3();
    private final Vector3D32 noiseVector = new Vector3D32();
    private PerspectiveCamera camera;
    private ModelBatch modelBatch;
    private ScreenViewport viewport;
    private SensorFrameBuffer frameBuffer;
    private RecyclingArrayList<Point3D32> points;
    private ArrayList<Integer> colors;
    private boolean colorsAreBeingUsed = true;
    private boolean depthEnabled = true;
    private Pixmap depthWindowPixmap;
    private Texture depthWindowTexture;
    private final ImGuiVideoPanel depthPanel;
    private final ImGuiVideoPanel colorPanel;
    private float lowestValueSeen = -1.0f;
    private float highestValueSeen = -1.0f;
    private ByteBuffer rawDepthByteBuffer;
    private FloatBuffer rawDepthFloatBuffer;
    private FloatBuffer eyeDepthMetersBuffer;
    private ByteBuffer rawColorByteBuffer;
    private IntBuffer rawColorIntBuffer;
    private final ImFloat depthPitchTuner = new ImFloat(-0.027f);

    public GDXLowLevelDepthSensorSimulator(String sensorName, double fieldOfViewY, int imageWidth, int imageHeight, double minRange, double maxRange) {
        this.depthWindowName = ImGuiTools.uniqueLabel(sensorName + " Depth");
        this.colorWindowName = ImGuiTools.uniqueLabel(sensorName + " Color");
        this.fieldOfViewY = (float)fieldOfViewY;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.minRange = (float)minRange;
        this.maxRange = (float)maxRange;
        this.updatePeriod = UnitConversions.hertzToSeconds((double)30.0);
        this.depthPanel = new ImGuiVideoPanel(this.depthWindowName, false);
        this.colorPanel = new ImGuiVideoPanel(this.colorWindowName, true);
    }

    public void create() {
        this.throttleTimer.reset();
        this.camera = new PerspectiveCamera(this.fieldOfViewY, (float)this.imageWidth, (float)this.imageHeight);
        this.camera.near = this.minRange;
        this.camera.far = this.maxRange * 2.0f;
        this.viewport = new ScreenViewport((Camera)this.camera);
        this.modelBatch = new ModelBatch();
        SensorFrameBufferBuilder frameBufferBuilder = new SensorFrameBufferBuilder(this.imageWidth, this.imageHeight);
        frameBufferBuilder.addBasicColorTextureAttachment(Pixmap.Format.RGBA8888);
        frameBufferBuilder.addDepthTextureAttachment(36012, 5126);
        this.frameBuffer = frameBufferBuilder.build();
        this.rawDepthByteBuffer = BufferUtils.newByteBuffer((int)(this.imageWidth * this.imageHeight * 4));
        this.rawDepthFloatBuffer = this.rawDepthByteBuffer.asFloatBuffer();
        this.rawColorByteBuffer = BufferUtils.newByteBuffer((int)(this.imageWidth * this.imageHeight * 4));
        this.rawColorIntBuffer = this.rawColorByteBuffer.asIntBuffer();
        this.eyeDepthMetersBuffer = BufferUtils.newFloatBuffer((int)(this.imageWidth * this.imageHeight));
        this.depthWindowPixmap = new Pixmap(this.imageWidth, this.imageHeight, Pixmap.Format.RGBA8888);
        this.depthWindowTexture = new Texture((TextureData)new PixmapTextureData(this.depthWindowPixmap, null, false, false));
        this.depthPanel.setTexture(this.depthWindowTexture);
        this.colorPanel.setTexture(this.frameBuffer.getColorTexture());
        this.points = new RecyclingArrayList(this.imageWidth * this.imageHeight, Point3D32::new);
        this.colors = new ArrayList(this.imageWidth * this.imageHeight);
    }

    public void render(GDX3DSceneManager sceneManager) {
        boolean updateThisTick = this.throttleTimer.isExpired(this.updatePeriod);
        if (!updateThisTick) {
            return;
        }
        this.throttleTimer.reset();
        this.frameBuffer.begin();
        float clear = 0.0f;
        Gdx.gl.glClearColor(clear, clear, clear, 1.0f);
        Gdx.gl.glClear(16640);
        this.viewport.update(this.imageWidth, this.imageHeight);
        this.modelBatch.begin((Camera)this.camera);
        Gdx.gl.glViewport(0, 0, this.imageWidth, this.imageHeight);
        sceneManager.renderRegisteredObjectsWithEnvironment(this.modelBatch, GDXSceneLevel.REAL_ENVIRONMENT);
        this.modelBatch.end();
        if (this.depthEnabled) {
            Gdx.gl.glPixelStorei(3333, 4);
            this.rawDepthByteBuffer.rewind();
            Gdx.gl.glReadPixels(0, 0, this.imageWidth, this.imageHeight, 6402, 5126, (Buffer)this.rawDepthByteBuffer);
        }
        Gdx.gl.glPixelStorei(3333, 1);
        this.rawColorByteBuffer.rewind();
        Gdx.gl.glReadPixels(0, 0, this.imageWidth, this.imageHeight, 6408, 5121, (Buffer)this.rawColorByteBuffer);
        this.frameBuffer.end();
        this.points.clear();
        this.colors.clear();
        float twoXCameraFarNear = 2.0f * this.camera.near * this.camera.far;
        float farPlusNear = this.camera.far + this.camera.near;
        float farMinusNear = this.camera.far - this.camera.near;
        this.rawDepthFloatBuffer.rewind();
        this.eyeDepthMetersBuffer.rewind();
        if (this.depthEnabled) {
            for (int y = 0; y < this.imageHeight; ++y) {
                for (int x = 0; x < this.imageWidth; ++x) {
                    float rawDepthReading = this.rawDepthFloatBuffer.get();
                    float imageY = 2.0f * (float)y / (float)this.imageHeight - 1.0f;
                    float normalizedDeviceCoordinateZ = 2.0f * rawDepthReading - 1.0f;
                    float eyeDepth = twoXCameraFarNear / (farPlusNear - normalizedDeviceCoordinateZ * farMinusNear);
                    this.eyeDepthMetersBuffer.put(eyeDepth += imageY * this.depthPitchTuner.get());
                    if (this.depthPanel.getIsShowing().get()) {
                        if (this.highestValueSeen < 0.0f || eyeDepth > this.highestValueSeen) {
                            this.highestValueSeen = eyeDepth;
                        }
                        if (this.lowestValueSeen < 0.0f || eyeDepth < this.lowestValueSeen) {
                            this.lowestValueSeen = eyeDepth;
                        }
                        float colorRange = this.highestValueSeen - this.lowestValueSeen;
                        float grayscale = (eyeDepth - this.lowestValueSeen) / colorRange;
                        int flippedY = this.imageHeight - y;
                        this.depthWindowPixmap.drawPixel(x, flippedY, Color.rgba8888((float)grayscale, (float)grayscale, (float)grayscale, (float)1.0f));
                    }
                    if (!(eyeDepth > this.camera.near) || !(eyeDepth < this.maxRange)) continue;
                    this.depthPoint.x = 2.0f * (float)x / (float)this.imageWidth - 1.0f;
                    this.depthPoint.y = imageY;
                    this.depthPoint.z = 2.0f * rawDepthReading - 1.0f;
                    this.depthPoint.prj(this.camera.invProjectionView);
                    Point3D32 point = (Point3D32)this.points.add();
                    GDXTools.toEuclid(this.depthPoint, (Point3DBasics)point);
                    GDXTools.toEuclid(this.camera.position, (Vector3DBasics)this.noiseVector);
                    this.noiseVector.sub((Tuple3DReadOnly)point);
                    this.noiseVector.normalize();
                    this.noiseVector.scale((this.random.nextDouble() - 0.5) * 0.007);
                    point.add((Tuple3DReadOnly)this.noiseVector);
                    if (!this.colorsAreBeingUsed) continue;
                    this.colors.add(this.frameBuffer.getColorPixmap().getPixel(x, this.imageHeight - y));
                }
            }
            if (this.depthPanel.getIsShowing().get()) {
                this.depthWindowTexture.draw(this.depthWindowPixmap, 0, 0);
            }
        }
        this.colorsAreBeingUsed = false;
    }

    public void renderTuningSliders() {
        ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Depth Pitch Tuner"), (float[])this.depthPitchTuner.getData(), (float)1.0E-4f, (float)-0.05f, (float)0.05f);
    }

    public void dispose() {
        this.frameBuffer.dispose();
        this.depthWindowTexture.dispose();
        this.modelBatch.dispose();
    }

    public void setCameraWorldTransform(Matrix4 worldTransform) {
        this.camera.position.setZero();
        this.camera.up.set(0.0f, 0.0f, 1.0f);
        this.camera.direction.set(1.0f, 0.0f, 0.0f);
        this.camera.transform(worldTransform);
    }

    public PerspectiveCamera getCamera() {
        return this.camera;
    }

    public FloatBuffer getEyeDepthMetersBuffer() {
        return this.eyeDepthMetersBuffer;
    }

    public IntBuffer getColorRGB8Buffer() {
        return this.rawColorIntBuffer;
    }

    public ByteBuffer getRawColorByteBuffer() {
        return this.rawColorByteBuffer;
    }

    public Pixmap getColorPixmap() {
        return this.frameBuffer.getColorPixmap();
    }

    public float getMaxRange() {
        return this.maxRange;
    }

    public RecyclingArrayList<Point3D32> getPoints() {
        return this.points;
    }

    public ArrayList<Integer> getColors() {
        this.colorsAreBeingUsed = true;
        return this.colors;
    }

    public ImGuiVideoPanel getDepthPanel() {
        return this.depthPanel;
    }

    public ImGuiVideoPanel getColorPanel() {
        return this.colorPanel;
    }

    public void setDepthEnabled(boolean depthEnabled) {
        this.depthEnabled = depthEnabled;
    }
}

