/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.sceneManager;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DirectionalLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.PointLightsAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalShadowLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImFloat;

public class GDX3DSceneTools {
    public static final float CLEAR_COLOR = 0.5019608f;
    public static final String TUNING_WINDOW_NAME = "Lighting";
    private static ImBoolean ambientEnabled = new ImBoolean(true);
    private static ImFloat ambientColor = new ImFloat(1.0f);
    private static ImBoolean pointEnabled = new ImBoolean(true);
    private static ImFloat pointColor = new ImFloat(1.0f);
    private static ImFloat pointDistance = new ImFloat(10.0f);
    private static ImFloat pointIntensity = new ImFloat(43.28f);
    private static ImBoolean directionEnabled = new ImBoolean(false);
    private static ImFloat directionColor = new ImFloat(0.025f);
    private static ImFloat directionDistance = new ImFloat(20.0f);

    public static void glClearGray() {
        GDX3DSceneTools.glClearGray(0.5019608f);
    }

    public static void glClearGray(float color) {
        Gdx.gl.glClearColor(color, color, color, 1.0f);
        Gdx.gl.glClear(16640);
    }

    public static Environment createDefaultEnvironment() {
        Environment environment = new Environment();
        float ambientColor = GDX3DSceneTools.ambientColor.get();
        if (ambientEnabled.get()) {
            environment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, ambientColor, ambientColor, ambientColor, 1.0f));
        }
        float pointColor = GDX3DSceneTools.pointColor.get();
        float pointDistance = GDX3DSceneTools.pointDistance.get();
        float pointIntensity = GDX3DSceneTools.pointIntensity.get();
        if (pointEnabled.get()) {
            PointLightsAttribute pointLights = new PointLightsAttribute();
            pointLights.lights.add((Object)new PointLight().set(pointColor, pointColor, pointColor, pointDistance, pointDistance, pointDistance, pointIntensity));
            pointLights.lights.add((Object)new PointLight().set(pointColor, pointColor, pointColor, -pointDistance, pointDistance, pointDistance, pointIntensity));
            pointLights.lights.add((Object)new PointLight().set(pointColor, pointColor, pointColor, -pointDistance, -pointDistance, pointDistance, pointIntensity));
            pointLights.lights.add((Object)new PointLight().set(pointColor, pointColor, pointColor, pointDistance, -pointDistance, pointDistance, pointIntensity));
            environment.set((Attribute)pointLights);
        }
        float directionColor = GDX3DSceneTools.directionColor.get();
        float directionDistance = GDX3DSceneTools.directionDistance.get();
        if (directionEnabled.get()) {
            DirectionalLightsAttribute directionalLights = new DirectionalLightsAttribute();
            directionalLights.lights.add((Object)new DirectionalLight().set(directionColor, directionColor, directionColor, -directionDistance, -directionDistance, -directionDistance));
            directionalLights.lights.add((Object)new DirectionalLight().set(directionColor, directionColor, directionColor, directionDistance, -directionDistance, -directionDistance));
            directionalLights.lights.add((Object)new DirectionalLight().set(directionColor, directionColor, directionColor, directionDistance, directionDistance, -directionDistance));
            directionalLights.lights.add((Object)new DirectionalLight().set(directionColor, directionColor, directionColor, -directionDistance, directionDistance, -directionDistance));
            environment.set((Attribute)directionalLights);
        }
        return environment;
    }

    private static DirectionalShadowLight newShadowLight() {
        return new DirectionalShadowLight(1024, 1024, 30.0f, 30.0f, 1.0f, 100.0f);
    }

    public static void renderTuningSliders() {
        ImGui.checkbox((String)"Ambient enabled", (ImBoolean)ambientEnabled);
        ImGui.sliderFloat((String)"Ambient color", (float[])ambientColor.getData(), (float)0.0f, (float)1.0f);
        ImGui.checkbox((String)"Point enabled", (ImBoolean)pointEnabled);
        ImGui.sliderFloat((String)"Point color", (float[])pointColor.getData(), (float)0.0f, (float)1.0f);
        ImGui.sliderFloat((String)"Point distance", (float[])pointDistance.getData(), (float)0.0f, (float)500.0f);
        ImGui.sliderFloat((String)"Point intensity", (float[])pointIntensity.getData(), (float)0.0f, (float)500.0f);
        ImGui.checkbox((String)"Direction enabled", (ImBoolean)directionEnabled);
        ImGui.sliderFloat((String)"Direction color", (float[])directionColor.getData(), (float)0.0f, (float)1.0f);
        ImGui.sliderFloat((String)"Direction distance", (float[])directionDistance.getData(), (float)0.0f, (float)20.0f);
    }
}

