/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.mesh;

import com.badlogic.gdx.graphics.Color;
import java.util.ArrayList;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.gdx.mesh.GDXMultiColorMeshBuilder;

public class GDXMeshGraphicTools {
    public static void drawArrow(GDXMultiColorMeshBuilder meshBuilder, Tuple3DReadOnly position, Orientation3DReadOnly orientation, double length, double radius, double cylinderToConeLengthRatio, double coneDiameterMultiplier, Color color) {
        double cylinderLength = cylinderToConeLengthRatio * length;
        double coneLength = (1.0 - cylinderToConeLengthRatio) * length;
        double coneRadius = coneDiameterMultiplier * radius;
        AxisAngle axisAngle = new AxisAngle(orientation);
        meshBuilder.addCylinder(cylinderLength, radius, position, (Orientation3DReadOnly)axisAngle, color);
        Vector3D coneBaseTranslation = new Vector3D(0.0, 0.0, 1.0);
        orientation.transform((Tuple3DBasics)coneBaseTranslation);
        coneBaseTranslation.scale(length);
        coneBaseTranslation.scale(cylinderToConeLengthRatio);
        Point3D coneBase = new Point3D(position);
        coneBase.add((Tuple3DReadOnly)coneBaseTranslation);
        meshBuilder.addCone(coneLength, coneRadius, (Tuple3DReadOnly)coneBase, (Orientation3DReadOnly)axisAngle, color);
    }

    public static void drawBoxEdges(GDXMultiColorMeshBuilder meshBuilder, Box3DReadOnly box, double lineWidth, Color color) {
        ArrayList<Point3DBasics> orderedVertices = new ArrayList<Point3DBasics>();
        orderedVertices.add(box.getVertex(0));
        orderedVertices.add(box.getVertex(1));
        orderedVertices.add(box.getVertex(3));
        orderedVertices.add(box.getVertex(2));
        orderedVertices.add(box.getVertex(0));
        orderedVertices.add(box.getVertex(4));
        orderedVertices.add(box.getVertex(5));
        orderedVertices.add(box.getVertex(1));
        orderedVertices.add(box.getVertex(5));
        orderedVertices.add(box.getVertex(7));
        orderedVertices.add(box.getVertex(3));
        orderedVertices.add(box.getVertex(7));
        orderedVertices.add(box.getVertex(6));
        orderedVertices.add(box.getVertex(2));
        orderedVertices.add(box.getVertex(6));
        orderedVertices.add(box.getVertex(4));
        meshBuilder.addMultiLine(orderedVertices, lineWidth, color, false);
    }
}

