/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.imgui;

import com.badlogic.gdx.graphics.Texture;
import imgui.internal.ImGui;
import us.ihmc.gdx.imgui.ImGuiPanel;

public class ImGuiVideoPanel
extends ImGuiPanel {
    private Texture texture;
    private final boolean flipY;

    public ImGuiVideoPanel(String name, boolean flipY) {
        super(name);
        this.setRenderMethod(this::renderImGuiWidgets);
        this.flipY = flipY;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
        this.setFirstTimeWidth(texture.getWidth());
        this.setFirstTimeHeight(texture.getHeight());
    }

    public void renderImGuiWidgets() {
        if (this.texture != null) {
            float tableHeader = 22.0f;
            float posX = ImGui.getWindowPosX();
            float posY = ImGui.getWindowPosY() + tableHeader;
            float sizeX = ImGui.getWindowSizeX();
            float sizeY = ImGui.getWindowSizeY() - tableHeader;
            float windowAspect = sizeX / sizeY;
            float cameraAspect = (float)this.texture.getWidth() / (float)this.texture.getHeight();
            float drawSizeX = sizeX;
            float drawSizeY = sizeY;
            float centeringX = 0.0f;
            float centeringY = 0.0f;
            if (windowAspect > cameraAspect) {
                drawSizeX = drawSizeY * cameraAspect;
                centeringX = (sizeX - drawSizeX) / 2.0f;
            } else {
                drawSizeY = drawSizeX / cameraAspect;
                centeringY = (sizeY - drawSizeY) / 2.0f;
            }
            float startX = posX + centeringX;
            float startY = this.flipY ? posY + centeringY + drawSizeY : posY + centeringY;
            float endX = posX + centeringX + drawSizeX;
            float endY = this.flipY ? posY + centeringY : posY + centeringY + drawSizeY;
            ImGui.getWindowDrawList().addImage(this.texture.getTextureObjectHandle(), startX, startY, endX, endY);
        }
    }
}

