/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.imgui;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import us.ihmc.gdx.imgui.ImGuiTools;

public class ImGuiUniqueLabelMap {
    private static final HashMap<String, AtomicInteger> CLASS_TO_INDEX = new HashMap();
    private final HashMap<String, String> namesToLabels = new HashMap();
    private final int index;
    private final String simpleName;

    public ImGuiUniqueLabelMap(Class<?> clazz) {
        this.simpleName = clazz.getSimpleName();
        AtomicInteger classIndex = CLASS_TO_INDEX.get(this.simpleName);
        if (classIndex == null) {
            classIndex = new AtomicInteger();
            CLASS_TO_INDEX.put(this.simpleName, classIndex);
        }
        this.index = classIndex.getAndIncrement();
    }

    public String get(String name) {
        String label = this.namesToLabels.get(name);
        if (label == null) {
            label = ImGuiTools.uniqueLabel(this.simpleName + this.index, name);
            this.namesToLabels.put(name, label);
        }
        return label;
    }
}

