/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.imgui;

import imgui.ImFont;
import imgui.ImFontConfig;
import imgui.ImGui;
import imgui.ImGuiIO;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.SystemUtils;
import org.lwjgl.opengl.GL32;
import us.ihmc.euclid.geometry.BoundingBox2D;

public class ImGuiTools {
    private static final AtomicInteger GLOBAL_WIDGET_INDEX = new AtomicInteger();
    public static float TAB_BAR_HEIGHT = 20.0f;
    public static final int GDX_TO_IMGUI_KEY_CODE_OFFSET = 36;
    public static final float FLOAT_MIN = -1.7014117E38f;
    public static final float FLOAT_MAX = 1.7014117E38f;
    private static ImFont bigFont;
    private static ImFont nodeFont;

    public static int nextWidgetIndex() {
        return GLOBAL_WIDGET_INDEX.getAndIncrement();
    }

    public static void glClearDarkGray() {
        GL32.glClearColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
        GL32.glClear((int)16384);
    }

    public static String uniqueLabel(String label) {
        return label + "###GlobalWidgetIndex:" + ImGuiTools.nextWidgetIndex() + ":" + label;
    }

    public static String uniqueLabel(String id, String label) {
        return label + "###" + id + ":" + label;
    }

    public static String uniqueLabel(Object thisObject, String label) {
        return label + "###" + thisObject.getClass().getName() + ":" + label;
    }

    public static String uniqueIDOnly(Object thisObject, String label) {
        return "###" + thisObject.getClass().getName() + ":" + label;
    }

    public static ImFont setupFonts(ImGuiIO io) {
        ImFont fontToReturn;
        ImFontConfig fontConfig = new ImFontConfig();
        ImFontConfig bigFontConfig = new ImFontConfig();
        ImFontConfig nodeFontConfig = new ImFontConfig();
        float size = 14.0f;
        int fontsFlags = 0;
        fontConfig.setFontBuilderFlags(fontsFlags += 8);
        bigFontConfig.setFontBuilderFlags(fontsFlags);
        nodeFontConfig.setFontBuilderFlags(fontsFlags);
        String fontDir = SystemUtils.IS_OS_WINDOWS ? System.getenv("WINDIR") + "/Fonts" : "/usr/share/fonts/TTF/";
        Path segoeui = Paths.get(fontDir, "segoeui.ttf");
        if (Files.exists(segoeui, new LinkOption[0])) {
            fontConfig.setName("segoeui.ttf, 16px");
            fontToReturn = io.getFonts().addFontFromFileTTF(segoeui.toAbsolutePath().toString(), 16.0f, fontConfig);
            bigFontConfig.setName("segoeui.ttf, 38px");
            bigFont = io.getFonts().addFontFromFileTTF(segoeui.toAbsolutePath().toString(), 38.0f, bigFontConfig);
            nodeFontConfig.setName("segoeui.ttf, 32px 1/2");
            nodeFont = io.getFonts().addFontFromFileTTF(segoeui.toAbsolutePath().toString(), 32.0f, nodeFontConfig);
        } else {
            fontConfig.setName("DejaVuSans.ttf, 13px");
            fontToReturn = io.getFonts().addFontFromMemoryTTF(ImGuiTools.loadFromResources("dejaVu/DejaVuSans.ttf"), 13.0f, fontConfig);
            bigFontConfig.setName("DejaVuSans.ttf, 32px");
            bigFont = io.getFonts().addFontFromMemoryTTF(ImGuiTools.loadFromResources("dejaVu/DejaVuSans.ttf"), 32.0f, bigFontConfig);
            nodeFontConfig.setName("DejaVuSans.ttf, 26px 1/2");
            nodeFont = io.getFonts().addFontFromMemoryTTF(ImGuiTools.loadFromResources("dejaVu/DejaVuSans.ttf"), 26.0f, nodeFontConfig);
        }
        nodeFont.setScale(0.5f);
        ImGui.getIO().getFonts().build();
        fontConfig.destroy();
        bigFontConfig.destroy();
        nodeFontConfig.destroy();
        return fontToReturn;
    }

    public static ImFont getBigFont() {
        return bigFont;
    }

    public static ImFont getNodeFont() {
        return nodeFont;
    }

    /*
     * Exception decompiling
     */
    public static byte[] loadFromResources(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static BoundingBox2D windowBoundingBox() {
        BoundingBox2D box = new BoundingBox2D();
        int posX = (int)ImGui.getWindowPosX();
        int posY = (int)ImGui.getWindowPosY();
        box.setMin((double)posX, (double)posY);
        box.setMax((double)((float)posX + ImGui.getWindowSizeX()), (double)(posY + (int)ImGui.getWindowSizeX()));
        return box;
    }
}

