/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.imgui;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import us.ihmc.gdx.imgui.ImGuiDockspacePanel;
import us.ihmc.gdx.imgui.ImGuiPanel;

public class ImGuiPanelManager {
    private final TreeSet<ImGuiPanel> panels = new TreeSet<ImGuiPanel>(Comparator.comparing(ImGuiPanel::getPanelName));

    public void addPanel(ImGuiPanel panel) {
        this.panels.add(panel);
    }

    public void addPanel(String windowName, Runnable render) {
        this.panels.add(new ImGuiPanel(windowName, render));
    }

    public void addPrimaryPanel(String windowName) {
        this.panels.add(new ImGuiPanel(windowName));
    }

    public void renderPanelMenu() {
        for (ImGuiPanel panel : this.panels) {
            panel.renderMenuItem();
        }
    }

    public void renderPanels(ImGuiDockspacePanel justClosedPanel) {
        for (ImGuiPanel panel : this.panels) {
            panel.renderPanelAndChildren(justClosedPanel);
        }
    }

    public void loadConfiguration(JsonNode jsonNode) {
        JsonNode windowsNode = jsonNode.get("windows");
        Iterator it = windowsNode.fields();
        while (it.hasNext()) {
            Map.Entry panelEntry = (Map.Entry)it.next();
            for (ImGuiPanel panel : this.panels) {
                panel.load(panelEntry);
            }
        }
    }

    public void saveConfiguration(ObjectNode root) {
        ObjectNode anchorJSON = root.putObject("windows");
        for (ImGuiPanel panel : this.panels) {
            panel.save(anchorJSON);
        }
    }
}

