/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.imgui;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import imgui.internal.ImGui;
import imgui.type.ImBoolean;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import us.ihmc.gdx.imgui.ImGuiDockspacePanel;
import us.ihmc.gdx.imgui.ImGuiPanelSizeHandler;
import us.ihmc.log.LogTools;

public class ImGuiPanel
extends ImGuiPanelSizeHandler {
    private final String panelName;
    private Runnable render;
    private final ImBoolean isShowing;
    private final TreeSet<ImGuiPanel> children = new TreeSet<ImGuiPanel>(Comparator.comparing(ImGuiPanel::getPanelName));
    private int lastDockID = -1;

    public ImGuiPanel(String panelName) {
        this(panelName, null, false);
    }

    public ImGuiPanel(String panelName, Runnable render) {
        this(panelName, render, false);
    }

    public ImGuiPanel(String panelName, Runnable render, boolean isShowing) {
        this.panelName = panelName;
        this.render = render;
        this.isShowing = new ImBoolean(isShowing);
    }

    void renderMenuItem() {
        this.renderMenuItem("");
    }

    void renderMenuItem(String indent) {
        if (this.isTogglable()) {
            ImGui.menuItem((String)(indent + this.panelName), (String)"", (ImBoolean)this.isShowing);
            for (ImGuiPanel child : this.children) {
                child.renderMenuItem(indent + "\t");
            }
        }
    }

    void renderPanelAndChildren(ImGuiDockspacePanel justClosedPanel) {
        if (this.isTogglable() && this.isShowing.get()) {
            this.handleSizeBeforeBegin();
            ImGui.begin((String)this.panelName, (ImBoolean)this.isShowing);
            this.handleSizeAfterBegin();
            int windowDockID = ImGui.getWindowDockID();
            if (this.lastDockID != windowDockID) {
                LogTools.debug((String)"Dock ID changed. {}: {} -> {}", (Object)this.panelName, (Object)this.lastDockID, (Object)windowDockID);
                if (justClosedPanel != null) {
                    LogTools.info((String)"Closing \"{}\" because containing dockspace \"{}\" closed", (Object)this.panelName, (Object)justClosedPanel.getName());
                    this.isShowing.set(false);
                }
            }
            this.lastDockID = windowDockID;
            this.render.run();
            ImGui.end();
        }
        for (ImGuiPanel child : this.children) {
            child.renderPanelAndChildren(justClosedPanel);
        }
    }

    public void addChild(ImGuiPanel child) {
        this.children.add(child);
    }

    void load(Map.Entry<String, JsonNode> panelEntry) {
        if (this.panelName.equals(panelEntry.getKey())) {
            this.isShowing.set(panelEntry.getValue().asBoolean());
        }
        for (ImGuiPanel child : this.children) {
            child.load(panelEntry);
        }
    }

    void save(ObjectNode anchorJSON) {
        if (this.isTogglable()) {
            anchorJSON.put(this.panelName, this.isShowing.get());
        }
        for (ImGuiPanel child : this.children) {
            child.save(anchorJSON);
        }
    }

    public void setRenderMethod(Runnable render) {
        this.render = render;
    }

    public boolean isTogglable() {
        return this.render != null;
    }

    public ImBoolean getIsShowing() {
        return this.isShowing;
    }

    public String getPanelName() {
        return this.panelName;
    }
}

