/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.imgui;

import java.nio.file.Paths;
import org.lwjgl.glfw.GLFW;
import us.ihmc.gdx.imgui.GDXImGuiWindowAndDockSystem;
import us.ihmc.gdx.imgui.GlfwWindowForImGui;
import us.ihmc.gdx.imgui.ImGuiPanelManager;
import us.ihmc.gdx.imgui.ImGuiTools;
import us.ihmc.tools.io.HybridDirectory;

public class ImGuiGlfwWindow {
    private final GlfwWindowForImGui glfwWindowForImGui;
    private final Class<? extends ImGuiGlfwWindow> classForLoading = this.getClass();
    private final String directoryNameToAssumePresent = "ihmc-open-robotics-software";
    private final String subsequentPathToResourceFolder = "ihmc-graphics/src/libgdx/resources";
    private final HybridDirectory configurationDirectory = new HybridDirectory(Paths.get(System.getProperty("user.home"), ".ihmc"), "ihmc-open-robotics-software", "ihmc-graphics/src/libgdx/resources", this.classForLoading, "GLFWDemo");
    private final GDXImGuiWindowAndDockSystem imGuiDockSystem = new GDXImGuiWindowAndDockSystem();

    public ImGuiGlfwWindow(String windowTitle, int windowWidth, int windowHeight) {
        this.imGuiDockSystem.setDirectory(this.configurationDirectory);
        this.glfwWindowForImGui = new GlfwWindowForImGui(windowTitle, windowWidth, windowHeight);
    }

    public void run(Runnable render, Runnable dispose) {
        this.run(null, render, dispose);
    }

    public void run(Runnable configure, Runnable render, Runnable dispose) {
        this.glfwWindowForImGui.create();
        long windowHandle = this.glfwWindowForImGui.getWindowHandle();
        this.imGuiDockSystem.create(windowHandle);
        while (!GLFW.glfwWindowShouldClose((long)windowHandle)) {
            ImGuiTools.glClearDarkGray();
            if (configure != null) {
                configure.run();
            }
            this.imGuiDockSystem.beforeWindowManagement();
            render.run();
            this.imGuiDockSystem.afterWindowManagement();
        }
        dispose.run();
        this.imGuiDockSystem.dispose();
        this.glfwWindowForImGui.dispose();
    }

    public ImGuiPanelManager getPanelManager() {
        return this.imGuiDockSystem.getPanelManager();
    }

    public GDXImGuiWindowAndDockSystem getImGuiDockSystem() {
        return this.imGuiDockSystem;
    }
}

