/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.imgui;

import java.io.PrintStream;
import java.nio.IntBuffer;
import java.util.Objects;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.MemoryStack;

public class GlfwWindowForImGui {
    private final String windowTitle;
    private final int windowWidth;
    private final int windowHeight;
    private long windowHandle;

    public GlfwWindowForImGui(String windowTitle, int windowWidth, int windowHeight) {
        this.windowTitle = windowTitle;
        this.windowWidth = windowWidth;
        this.windowHeight = windowHeight;
    }

    public void create() {
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        long monitor = 0L;
        long share = 0L;
        this.windowHandle = GLFW.glfwCreateWindow((int)this.windowWidth, (int)this.windowHeight, (CharSequence)this.windowTitle, (long)monitor, (long)share);
        if (this.windowHandle == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowSize((long)this.windowHandle, (IntBuffer)pWidth, (IntBuffer)pHeight);
            GLFWVidMode vidmode = Objects.requireNonNull(GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor()));
            GLFW.glfwSetWindowPos((long)this.windowHandle, (int)((vidmode.width() - pWidth.get(0)) / 2), (int)((vidmode.height() - pHeight.get(0)) / 2));
        }
        GLFW.glfwMakeContextCurrent((long)this.windowHandle);
        GLFW.glfwSwapInterval((int)1);
        GLFW.glfwShowWindow((long)this.windowHandle);
        GL.createCapabilities();
    }

    public void dispose() {
        Callbacks.glfwFreeCallbacks((long)this.windowHandle);
        GLFW.glfwDestroyWindow((long)this.windowHandle);
        GLFW.glfwTerminate();
        Objects.requireNonNull(GLFW.glfwSetErrorCallback(null)).free();
    }

    public long getWindowHandle() {
        return this.windowHandle;
    }
}

