/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx.imgui;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import imgui.ImFont;
import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.ImGuiStyle;
import imgui.ImGuiViewport;
import imgui.gl3.ImGuiImplGl3;
import imgui.glfw.ImGuiImplGlfw;
import imgui.type.ImString;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.gdx.imgui.ImGuiDockspacePanel;
import us.ihmc.gdx.imgui.ImGuiPanelManager;
import us.ihmc.gdx.imgui.ImGuiTools;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.HybridDirectory;
import us.ihmc.tools.io.HybridFile;
import us.ihmc.tools.io.JSONFileTools;

public class GDXImGuiWindowAndDockSystem {
    private final ImGuiImplGlfw imGuiGlfw = new ImGuiImplGlfw();
    private final ImGuiImplGl3 imGuiGl3 = new ImGuiImplGl3();
    private String glslVersion;
    private long windowHandle;
    private ImFont imFont;
    private int dockspaceId;
    private final ImString newDockPanelName = new ImString("", 100);
    private final TreeSet<ImGuiDockspacePanel> dockPanelSet = new TreeSet<ImGuiDockspacePanel>(Comparator.comparing(ImGuiDockspacePanel::getName));
    private final ImGuiPanelManager panelManager = new ImGuiPanelManager();
    private HybridFile imGuiSettingsFile;
    private HybridFile panelsFile;
    private boolean isFirstRenderCall = true;

    public void setDirectory(HybridDirectory configurationDirectory) {
        this.imGuiSettingsFile = new HybridFile(configurationDirectory, "ImGuiSettings.ini");
        this.panelsFile = new HybridFile(configurationDirectory, "ImGuiPanels.json");
    }

    public void create(long windowHandle) {
        this.windowHandle = windowHandle;
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        imgui.internal.ImGui.createContext();
        ImGuiIO io = imgui.internal.ImGui.getIO();
        io.setIniFilename(null);
        io.addConfigFlags(64);
        io.addConfigFlags(1024);
        io.setConfigViewportsNoTaskBarIcon(true);
        io.setConfigWindowsMoveFromTitleBarOnly(true);
        io.setConfigViewportsNoDecoration(false);
        io.setConfigDockingTransparentPayload(false);
        if (!Boolean.parseBoolean(System.getProperty("imgui.dark"))) {
            imgui.internal.ImGui.styleColorsLight();
        }
        this.imFont = ImGuiTools.setupFonts(io);
        if (io.hasConfigFlags(1024)) {
            ImGuiStyle style = ImGui.getStyle();
            style.setWindowRounding(0.0f);
            style.setColor(2, ImGui.getColorU32((int)2, (float)1.0f));
        }
        this.imGuiGlfw.init(windowHandle, true);
        this.imGuiGl3.init(this.glslVersion);
    }

    public void beforeWindowManagement() {
        if (this.isFirstRenderCall) {
            this.loadUserConfigurationWithDefaultFallback();
        }
        this.imGuiGlfw.newFrame();
        imgui.internal.ImGui.newFrame();
        imgui.internal.ImGui.pushFont((ImFont)this.imFont);
        int flags = 0;
        this.dockspaceId = imgui.internal.ImGui.dockSpaceOverViewport((ImGuiViewport)imgui.internal.ImGui.getMainViewport(), (int)(flags += 8));
        ImGuiDockspacePanel justClosedPanel = null;
        for (ImGuiDockspacePanel dockspacePanel : this.dockPanelSet) {
            dockspacePanel.renderPanel();
            if (!dockspacePanel.getWasJustClosed()) continue;
            justClosedPanel = dockspacePanel;
            LogTools.debug((String)"Closed dockspace panel: {}", (Object)justClosedPanel.getName());
        }
        this.panelManager.renderPanels(justClosedPanel);
    }

    public void renderMenuDockPanelItems() {
        imgui.internal.ImGui.text((String)"New dock panel:");
        imgui.internal.ImGui.sameLine();
        imgui.internal.ImGui.pushItemWidth((float)90.0f);
        imgui.internal.ImGui.inputText((String)"###newDockPanelName", (ImString)this.newDockPanelName, (int)262144);
        imgui.internal.ImGui.popItemWidth();
        imgui.internal.ImGui.sameLine();
        if (imgui.internal.ImGui.button((String)"Create###createNewDockPanelButton") && !this.newDockPanelName.get().isEmpty()) {
            this.dockPanelSet.add(new ImGuiDockspacePanel(this.newDockPanelName.get()));
        }
        ImGuiDockspacePanel dockspacePanelToRemove = null;
        for (ImGuiDockspacePanel dockspacePanel : this.dockPanelSet) {
            dockspacePanel.renderMenuItem();
            imgui.internal.ImGui.sameLine();
            if (!imgui.internal.ImGui.button((String)("X###X" + dockspacePanel.getName()))) continue;
            dockspacePanelToRemove = dockspacePanel;
        }
        if (dockspacePanelToRemove != null) {
            this.dockPanelSet.remove(dockspacePanelToRemove);
        }
        imgui.internal.ImGui.separator();
        this.panelManager.renderPanelMenu();
    }

    private void loadUserConfigurationWithDefaultFallback() {
        boolean loaded = this.loadConfiguration(false);
        if (!loaded) {
            LogTools.info((String)"{} not found", (Object)this.imGuiSettingsFile.getExternalFile().toString());
            if (!this.loadConfiguration(true)) {
                LogTools.warn((String)"No saved settings found");
            }
        }
    }

    public boolean loadConfiguration(boolean loadDefault) {
        Path file;
        boolean success = false;
        Path path = file = loadDefault ? this.imGuiSettingsFile.getWorkspaceFile() : this.imGuiSettingsFile.getExternalFile();
        if (Files.exists(file, new LinkOption[0])) {
            LogTools.info((String)"Loading ImGui settings from {}", (Object)file.toString());
            imgui.internal.ImGui.loadIniSettingsFromDisk((String)file.toString());
            success = true;
            Path fileForDockspacePanels = loadDefault ? this.panelsFile.getWorkspaceFile() : this.panelsFile.getExternalFile();
            JSONFileTools.load((Path)fileForDockspacePanels, jsonNode -> {
                JsonNode dockspacePanelsNode = jsonNode.get("dockspacePanels");
                if (dockspacePanelsNode != null) {
                    ImGuiDockspacePanel[] priorDockpanelSet = this.dockPanelSet.toArray(new ImGuiDockspacePanel[0]);
                    this.dockPanelSet.clear();
                    Iterator it = dockspacePanelsNode.fields();
                    while (it.hasNext()) {
                        Map.Entry dockspacePanelEntry = (Map.Entry)it.next();
                        ImGuiDockspacePanel dockspacePanel = null;
                        for (ImGuiDockspacePanel otherDockspacePanel : priorDockpanelSet) {
                            if (!otherDockspacePanel.getName().equals(dockspacePanelEntry.getKey())) continue;
                            dockspacePanel = otherDockspacePanel;
                        }
                        if (dockspacePanel == null) {
                            dockspacePanel = new ImGuiDockspacePanel((String)dockspacePanelEntry.getKey());
                        }
                        this.dockPanelSet.add(dockspacePanel);
                        dockspacePanel.getIsShowing().set(((JsonNode)dockspacePanelEntry.getValue()).asBoolean());
                    }
                }
                this.panelManager.loadConfiguration((JsonNode)jsonNode);
            });
        }
        return success;
    }

    public void saveConfiguration(boolean saveDefault) {
        Path saveFile = saveDefault ? this.imGuiSettingsFile.getWorkspaceFile() : this.imGuiSettingsFile.getExternalFile();
        String settingsPathString = saveFile.toString();
        LogTools.info((String)"Saving ImGui settings to {}", (Object)settingsPathString);
        FileTools.ensureDirectoryExists((Path)saveFile.getParent(), (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        imgui.internal.ImGui.saveIniSettingsToDisk((String)settingsPathString);
        Consumer<ObjectNode> rootConsumer = root -> {
            ObjectNode anchorJSON = root.putObject("dockspacePanels");
            for (ImGuiDockspacePanel dockspacePanel : this.dockPanelSet) {
                anchorJSON.put(dockspacePanel.getName(), dockspacePanel.getIsShowing().get());
            }
            this.panelManager.saveConfiguration((ObjectNode)root);
        };
        if (saveDefault) {
            JSONFileTools.save((Path)this.panelsFile.getWorkspaceFile(), rootConsumer);
        } else {
            LogTools.info((String)"Saving ImGui windows settings to {}", (Object)this.panelsFile.getExternalFile().toString());
            JSONFileTools.save((Path)this.panelsFile.getExternalFile(), rootConsumer);
        }
    }

    public void afterWindowManagement() {
        if (this.isFirstRenderCall) {
            JSONFileTools.loadUserWithClasspathDefaultFallback((HybridFile)this.panelsFile, jsonNode -> {
                JsonNode dockspacePanelsNode = jsonNode.get("dockspacePanels");
                if (dockspacePanelsNode != null) {
                    Iterator it = dockspacePanelsNode.fields();
                    while (it.hasNext()) {
                        Map.Entry dockspacePanelEntry = (Map.Entry)it.next();
                        ImGuiDockspacePanel dockspacePanel = new ImGuiDockspacePanel((String)dockspacePanelEntry.getKey());
                        dockspacePanel.getIsShowing().set(((JsonNode)dockspacePanelEntry.getValue()).asBoolean());
                        this.dockPanelSet.add(dockspacePanel);
                    }
                }
                this.panelManager.loadConfiguration((JsonNode)jsonNode);
            });
        }
        imgui.internal.ImGui.popFont();
        imgui.internal.ImGui.render();
        this.imGuiGl3.renderDrawData(imgui.internal.ImGui.getDrawData());
        if (ImGui.getIO().hasConfigFlags(1024)) {
            long backupWindowPtr = GLFW.glfwGetCurrentContext();
            ImGui.updatePlatformWindows();
            ImGui.renderPlatformWindowsDefault();
            GLFW.glfwMakeContextCurrent((long)backupWindowPtr);
        }
        GLFW.glfwSwapBuffers((long)this.windowHandle);
        GLFW.glfwPollEvents();
        this.isFirstRenderCall = false;
    }

    public void dispose() {
        this.imGuiGl3.dispose();
        this.imGuiGlfw.dispose();
        imgui.internal.ImGui.destroyContext();
    }

    public ImGuiImplGl3 getImGuiGl3() {
        return this.imGuiGl3;
    }

    public ImGuiPanelManager getPanelManager() {
        return this.panelManager;
    }
}

