/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.Random;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.log.LogTools;

public class GDXPointCloudRenderer
implements RenderableProvider {
    private static final int SIZE_AND_ROTATION_USAGE = 512;
    private static boolean POINT_SPRITES_ENABLED = false;
    private Renderable renderable;
    private float[] vertices;
    private final VertexAttributes vertexAttributes = new VertexAttributes(new VertexAttribute[]{new VertexAttribute(1, 3, "a_position"), new VertexAttribute(2, 4, "a_color"), new VertexAttribute(512, 3, "a_sizeAndRotation")});
    private final int vertexSize = 10;
    private RecyclingArrayList<Point3D32> pointsToRender;
    private ColorProvider colorProvider;
    private float pointScale = 0.01f;

    private static void enablePointSprites() {
        Gdx.gl30.glEnable(34370);
        if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
            Gdx.gl30.glEnable(34913);
        }
        POINT_SPRITES_ENABLED = true;
    }

    public void create(int size) {
        if (!POINT_SPRITES_ENABLED) {
            GDXPointCloudRenderer.enablePointSprites();
        }
        this.renderable = new Renderable();
        this.renderable.meshPart.primitiveType = 0;
        this.renderable.meshPart.offset = 0;
        this.renderable.material = new Material(new Attribute[]{ColorAttribute.createDiffuse((Color)Color.WHITE)});
        this.vertices = new float[size * 10];
        if (this.renderable.meshPart.mesh != null) {
            this.renderable.meshPart.mesh.dispose();
        }
        this.renderable.meshPart.mesh = new Mesh(false, size, 0, this.vertexAttributes);
        ParticleShader.Config config = new ParticleShader.Config(ParticleShader.ParticleType.Point);
        String prefix = ParticleShader.createPrefix((Renderable)this.renderable, (ParticleShader.Config)config);
        ShaderProgram.pedantic = true;
        String fragmentShader = ParticleShader.getDefaultFragmentShader().replace("gl_FragColor = texture2D(u_diffuseTexture, texCoord)* v_color", "gl_FragColor = v_color");
        ShaderProgram shader = new ShaderProgram(prefix + ParticleShader.getDefaultVertexShader(), prefix + fragmentShader);
        for (String s : shader.getLog().split("\n")) {
            if (s.isEmpty()) continue;
            if (s.contains("error")) {
                LogTools.error((String)s);
                continue;
            }
            LogTools.info((String)s);
        }
        this.renderable.shader = new ParticleShader(this.renderable, config, shader);
        this.renderable.shader.init();
    }

    public void updateMesh() {
        this.updateMesh(1.0f);
    }

    public void updateMesh(float alpha) {
        if (this.pointsToRender != null && !this.pointsToRender.isEmpty()) {
            for (int i = 0; i < this.pointsToRender.size(); ++i) {
                int offset = i * 10;
                Point3D32 point = (Point3D32)this.pointsToRender.get(i);
                this.vertices[offset] = point.getX32();
                this.vertices[offset + 1] = point.getY32();
                this.vertices[offset + 2] = point.getZ32();
                this.vertices[offset + 3] = this.colorProvider.getNextR();
                this.vertices[offset + 4] = this.colorProvider.getNextG();
                this.vertices[offset + 5] = this.colorProvider.getNextB();
                this.vertices[offset + 6] = alpha;
                this.vertices[offset + 7] = this.pointScale;
                this.vertices[offset + 8] = 1.0f;
                this.vertices[offset + 9] = 0.0f;
            }
            this.renderable.meshPart.size = this.pointsToRender.size();
            this.renderable.meshPart.mesh.setVertices(this.vertices, 0, this.pointsToRender.size() * 10);
            this.renderable.meshPart.update();
        }
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        renderables.add((Object)this.renderable);
    }

    public void dispose() {
        if (this.renderable.meshPart.mesh != null) {
            this.renderable.meshPart.mesh.dispose();
        }
    }

    public void setPointsToRender(RecyclingArrayList<Point3D32> pointsToRender) {
        this.setPointsToRender(pointsToRender, new ColorProvider(){
            private final Random random = new Random(0L);

            @Override
            public float getNextR() {
                return this.random.nextFloat();
            }

            @Override
            public float getNextG() {
                return this.random.nextFloat();
            }

            @Override
            public float getNextB() {
                return this.random.nextFloat();
            }
        });
    }

    public void setPointsToRender(RecyclingArrayList<Point3D32> pointsToRender, final Color color) {
        this.setPointsToRender(pointsToRender, new ColorProvider(){

            @Override
            public float getNextR() {
                return color.r;
            }

            @Override
            public float getNextG() {
                return color.g;
            }

            @Override
            public float getNextB() {
                return color.b;
            }
        });
    }

    public void setPointsToRender(RecyclingArrayList<Point3D32> pointsToRender, ColorProvider provider) {
        this.pointsToRender = pointsToRender;
        this.colorProvider = provider;
    }

    public void setPointScale(float size) {
        this.pointScale = size;
    }

    public static interface ColorProvider {
        public float getNextR();

        public float getNextG();

        public float getNextB();
    }
}

