/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.gdx;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.SerializationException;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.gdx.tools.GDXModelLoader;
import us.ihmc.gdx.tools.GDXTools;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.instructions.ArcTorusGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CapsuleGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.ConeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CubeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CylinderGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.EllipsoidGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.ExtrudedPolygonGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddExtrusionInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddHeightMapInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddModelFileInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstructionExecutor;
import us.ihmc.graphicsDescription.instructions.Graphics3DPrimitiveInstruction;
import us.ihmc.graphicsDescription.instructions.HemiEllipsoidGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PolygonGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PrimitiveGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PyramidCubeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.SphereGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.TruncatedConeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.WedgeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DRotateInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DScaleInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DTranslateInstruction;
import us.ihmc.log.LogTools;

public class GDXGraphicsObject
extends Graphics3DInstructionExecutor
implements RenderableProvider {
    private final ArrayList<Model> models = new ArrayList();
    private final ArrayList<ModelInstance> modelInstances = new ArrayList();

    public GDXGraphicsObject(Graphics3DObject graphics3dObject) {
        this(graphics3dObject, null);
    }

    public GDXGraphicsObject(Graphics3DObject graphics3dObject, AppearanceDefinition appearance) {
        List graphics3dInstructions;
        if (graphics3dObject != null && (graphics3dInstructions = graphics3dObject.getGraphics3DInstructions()) != null) {
            for (Graphics3DPrimitiveInstruction instruction : graphics3dInstructions) {
                if (!(instruction instanceof Graphics3DInstruction)) continue;
                Graphics3DInstruction graphicsInstruction = (Graphics3DInstruction)instruction;
                if (appearance == null) continue;
                graphicsInstruction.setAppearance(appearance);
            }
            this.setUpGraphicsFromDefinition(graphics3dInstructions);
        }
    }

    protected void doAddMeshDataInstruction(Graphics3DAddMeshDataInstruction graphics3DAddMeshData) {
    }

    protected void doAddHeightMapInstruction(Graphics3DAddHeightMapInstruction graphics3DAddHeightMap) {
    }

    protected void doAddExtrusionInstruction(Graphics3DAddExtrusionInstruction graphics3DAddText) {
    }

    protected void doAddModelFileInstruction(Graphics3DAddModelFileInstruction graphics3DAddModelFile) {
        try {
            String modelFileName = graphics3DAddModelFile.getFileName();
            String modifiedFileName = GDXModelLoader.modifyFileName(modelFileName);
            if (modifiedFileName == null) {
                return;
            }
            Model model = GDXModelLoader.loadG3DModel(modifiedFileName);
            this.models.add(model);
            if (graphics3DAddModelFile.getAppearance() != null) {
                AppearanceDefinition appearance = graphics3DAddModelFile.getAppearance();
                Color color = GDXTools.toGDX(appearance);
                Material firstMaterial = (Material)model.materials.get(0);
                if (firstMaterial != null) {
                    firstMaterial.set((Attribute)ColorAttribute.createDiffuse((float)color.r, (float)color.g, (float)color.b, (float)color.a));
                    if (color.a < 1.0f) {
                        firstMaterial.set((Attribute)new BlendingAttribute(true, color.a));
                    }
                }
            }
            ModelInstance modelInstance = new ModelInstance(model);
            this.modelInstances.add(modelInstance);
        }
        catch (SerializationException e) {
            LogTools.error((String)e.getMessage());
            e.printStackTrace();
        }
    }

    protected void doIdentityInstruction() {
    }

    protected void doRotateInstruction(Graphics3DRotateInstruction rot) {
    }

    protected void doScaleInstruction(Graphics3DScaleInstruction graphics3DScale) {
    }

    protected void doTranslateInstruction(Graphics3DTranslateInstruction graphics3DTranslate) {
    }

    protected void doAddPrimitiveInstruction(PrimitiveGraphics3DInstruction primitiveInstruction) {
        if (primitiveInstruction instanceof CubeGraphics3DInstruction) {
            CubeGraphics3DInstruction cubeInstruction = (CubeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Cube((double)cubeInstruction.getLength(), (double)cubeInstruction.getWidth(), (double)cubeInstruction.getHeight(), (boolean)cubeInstruction.getCenteredInTheCenter(), (boolean[])cubeInstruction.getTextureFaces());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)cubeInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof SphereGraphics3DInstruction) {
            SphereGraphics3DInstruction sphereInstruction = (SphereGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Sphere((double)sphereInstruction.getRadius(), (int)sphereInstruction.getResolution(), (int)sphereInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)sphereInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof WedgeGraphics3DInstruction) {
            WedgeGraphics3DInstruction wedgeInstruction = (WedgeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Wedge((double)wedgeInstruction.getLengthX(), (double)wedgeInstruction.getWidthY(), (double)wedgeInstruction.getHeightZ());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)wedgeInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof CapsuleGraphics3DInstruction) {
            CapsuleGraphics3DInstruction capsuleInstruction = (CapsuleGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Capsule((double)capsuleInstruction.getHeight(), (double)capsuleInstruction.getXRadius(), (double)capsuleInstruction.getYRadius(), (double)capsuleInstruction.getZRadius(), (int)capsuleInstruction.getResolution(), (int)capsuleInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)capsuleInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof EllipsoidGraphics3DInstruction) {
            EllipsoidGraphics3DInstruction ellipsoidInstruction = (EllipsoidGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Ellipsoid((double)ellipsoidInstruction.getXRadius(), (double)ellipsoidInstruction.getYRadius(), (double)ellipsoidInstruction.getZRadius(), (int)ellipsoidInstruction.getResolution(), (int)ellipsoidInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)ellipsoidInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof CylinderGraphics3DInstruction) {
            CylinderGraphics3DInstruction cylinderInstruction = (CylinderGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Cylinder((double)cylinderInstruction.getRadius(), (double)cylinderInstruction.getHeight(), (int)cylinderInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)cylinderInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof ConeGraphics3DInstruction) {
            ConeGraphics3DInstruction coneInstruction = (ConeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Cone((double)coneInstruction.getHeight(), (double)coneInstruction.getRadius(), (int)coneInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)coneInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof TruncatedConeGraphics3DInstruction) {
            TruncatedConeGraphics3DInstruction truncatedConeInstruction = (TruncatedConeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.GenTruncatedCone((double)truncatedConeInstruction.getHeight(), (double)truncatedConeInstruction.getXBaseRadius(), (double)truncatedConeInstruction.getYBaseRadius(), (double)truncatedConeInstruction.getXTopRadius(), (double)truncatedConeInstruction.getYTopRadius(), (int)truncatedConeInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)truncatedConeInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof HemiEllipsoidGraphics3DInstruction) {
            HemiEllipsoidGraphics3DInstruction hemiEllipsoidInstruction = (HemiEllipsoidGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.HemiEllipsoid((double)hemiEllipsoidInstruction.getXRadius(), (double)hemiEllipsoidInstruction.getYRadius(), (double)hemiEllipsoidInstruction.getZRadius(), (int)hemiEllipsoidInstruction.getResolution(), (int)hemiEllipsoidInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)hemiEllipsoidInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof ArcTorusGraphics3DInstruction) {
            ArcTorusGraphics3DInstruction arcTorusInstruction = (ArcTorusGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.ArcTorus((double)arcTorusInstruction.getStartAngle(), (double)arcTorusInstruction.getEndAngle(), (double)arcTorusInstruction.getMajorRadius(), (double)arcTorusInstruction.getMinorRadius(), (int)arcTorusInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)arcTorusInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof PyramidCubeGraphics3DInstruction) {
            PyramidCubeGraphics3DInstruction pyramidInstruction = (PyramidCubeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.PyramidCube((double)pyramidInstruction.getLengthX(), (double)pyramidInstruction.getWidthY(), (double)pyramidInstruction.getHeightZ(), (double)pyramidInstruction.getPyramidHeight());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)pyramidInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof PolygonGraphics3DInstruction) {
            PolygonGraphics3DInstruction polygonInstruction = (PolygonGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Polygon((List)polygonInstruction.getPolygonPoints());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)polygonInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof ExtrudedPolygonGraphics3DInstruction) {
            ExtrudedPolygonGraphics3DInstruction extrudedPolygonInstruction = (ExtrudedPolygonGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.ExtrudedPolygon((List)extrudedPolygonInstruction.getPolygonPoints(), (double)extrudedPolygonInstruction.getExtrusionHeight());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)extrudedPolygonInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else {
            throw new RuntimeException("Need to support that primitive type! primitiveInstruction = " + primitiveInstruction);
        }
    }

    public void setWorldTransform(AffineTransform worldTransform) {
        for (ModelInstance modelInstance : this.modelInstances) {
            GDXTools.toGDX(worldTransform, modelInstance.transform);
        }
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        for (ModelInstance modelInstance : this.modelInstances) {
            modelInstance.getRenderables(renderables, pool);
        }
    }

    public void destroy() {
        for (Model model : this.models) {
            model.dispose();
        }
    }
}

