/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tests.g3d.shadows.system.classical;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DepthTestAttribute;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.tests.g3d.shadows.system.classical.ClassicalShadowSystem;

public class Pass2Shader
extends DefaultShader {
    protected static ClassicalShadowSystem shadowSystem;
    private static String defaultVertexShader;
    private static String defaultFragmentShader;
    protected BlendingAttribute blend = new BlendingAttribute(1, 1);
    protected DepthTestAttribute depth = new DepthTestAttribute(515);
    protected int lightType = -1;
    public static final int LIGHT_SPOT = 0;
    public static final int LIGHT_DIR = 1;

    public static String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.files.classpath("com/badlogic/gdx/tests/g3d/shadows/system/classical/pass2.vertex.glsl").readString();
        }
        return defaultVertexShader;
    }

    public static String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.files.classpath("com/badlogic/gdx/tests/g3d/shadows/system/classical/pass2.fragment.glsl").readString();
        }
        return defaultFragmentShader;
    }

    public Pass2Shader(Renderable renderable, Config config) {
        this(renderable, config, Pass2Shader.createPrefix(renderable, config));
    }

    public Pass2Shader(Renderable renderable, Config config, String prefix) {
        this(renderable, config, prefix, config.vertexShader != null ? config.vertexShader : Pass2Shader.getDefaultVertexShader(), config.fragmentShader != null ? config.fragmentShader : Pass2Shader.getDefaultFragmentShader());
    }

    public Pass2Shader(Renderable renderable, Config config, String prefix, String vertexShader, String fragmentShader) {
        this(renderable, config, new ShaderProgram(prefix + vertexShader, prefix + fragmentShader));
    }

    public Pass2Shader(Renderable renderable, Config config, ShaderProgram shaderProgram) {
        super(renderable, (DefaultShader.Config)config, shaderProgram);
        shadowSystem = config.shadowSystem;
        this.register(Inputs.shadowMapProjViewTrans, Setters.shadowMapProjViewTrans);
        this.register(Inputs.shadowTexture, Setters.shadowTexture);
        this.register(Inputs.uvTransform, Setters.uvTransform);
        this.register(Inputs.lightColor, Setters.lightColor);
        this.register(Inputs.lightDirection, Setters.lightDirection);
        this.register(Inputs.lightPosition, Setters.lightPosition);
        this.register(Inputs.lightIntensity, Setters.lightIntensity);
        this.register(Inputs.lightCutoffAngle, Setters.lightCutoffAngle);
        this.register(Inputs.lightExponent, Setters.lightExponent);
    }

    public static String createPrefix(Renderable renderable, Config config) {
        String prefix = DefaultShader.createPrefix((Renderable)renderable, (DefaultShader.Config)config);
        boolean dir = config.shadowSystem.getCurrentLight() instanceof DirectionalLight;
        prefix = dir ? prefix + "#define directionalLight\n" : prefix + "#define spotLight\n";
        return prefix;
    }

    public void render(Renderable renderable, Attributes combinedAttributes) {
        if (shadowSystem.isFirstCallPass2()) {
            combinedAttributes.remove(BlendingAttribute.Type);
        } else {
            combinedAttributes.set((Attribute)this.blend);
        }
        combinedAttributes.set((Attribute)this.depth);
        super.render(renderable, combinedAttributes);
    }

    public boolean canRender(Renderable renderable) {
        boolean ok = super.canRender(renderable);
        boolean dir = shadowSystem.getCurrentLight() instanceof DirectionalLight;
        if (this.lightType == -1) {
            this.lightType = 0;
            if (dir) {
                this.lightType = 1;
            }
        }
        if (dir && this.lightType != 1) {
            ok = false;
        }
        if (!dir && this.lightType != 0) {
            ok = false;
        }
        return ok;
    }

    static {
        defaultVertexShader = null;
        defaultFragmentShader = null;
    }

    public static class Setters
    extends DefaultShader.Setters {
        public static final BaseShader.Setter shadowMapProjViewTrans = new BaseShader.GlobalSetter(){

            public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, Pass2Shader.shadowSystem.getCurrentLightProperties().camera.combined);
            }
        };
        public static final BaseShader.Setter shadowTexture = new BaseShader.GlobalSetter(){

            public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
                shader.set(inputID, (GLTexture)shadowSystem.getTexture(0));
            }
        };
        public static final BaseShader.Setter uvTransform = new BaseShader.GlobalSetter(){

            public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
                TextureRegion tr = Pass2Shader.shadowSystem.getCurrentLightProperties().region;
                shader.set(inputID, tr.getU(), tr.getV(), tr.getU2() - tr.getU(), tr.getV2() - tr.getV());
            }
        };
        public static final BaseShader.Setter lightColor = new BaseShader.GlobalSetter(){

            public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
                BaseLight l = shadowSystem.getCurrentLight();
                float intensity = 1.0f;
                if (l instanceof PointLight) {
                    intensity = ((PointLight)l).intensity;
                }
                if (l instanceof SpotLight) {
                    intensity = ((SpotLight)l).intensity;
                }
                shader.set(inputID, l.color.r * intensity, l.color.g * intensity, l.color.b * intensity);
            }
        };
        public static final BaseShader.Setter lightDirection = new BaseShader.GlobalSetter(){

            public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
                BaseLight l = shadowSystem.getCurrentLight();
                if (l instanceof DirectionalLight) {
                    shader.set(inputID, ((DirectionalLight)l).direction);
                }
                if (l instanceof SpotLight) {
                    shader.set(inputID, ((SpotLight)l).direction);
                }
                if (l instanceof PointLight) {
                    shader.set(inputID, Pass2Shader.shadowSystem.getCurrentLightProperties().camera.direction);
                }
            }
        };
        public static final BaseShader.Setter lightIntensity = new BaseShader.GlobalSetter(){

            public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
                BaseLight l = shadowSystem.getCurrentLight();
                if (l instanceof PointLight) {
                    shader.set(inputID, ((PointLight)l).intensity);
                }
                if (l instanceof SpotLight) {
                    shader.set(inputID, ((SpotLight)l).intensity);
                }
            }
        };
        public static final BaseShader.Setter lightPosition = new BaseShader.GlobalSetter(){

            public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
                BaseLight l = shadowSystem.getCurrentLight();
                if (l instanceof PointLight) {
                    shader.set(inputID, ((PointLight)l).position);
                }
                if (l instanceof SpotLight) {
                    shader.set(inputID, ((SpotLight)l).position);
                }
            }
        };
        public static final BaseShader.Setter lightCutoffAngle = new BaseShader.GlobalSetter(){

            public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
                if (!(shadowSystem.getCurrentLight() instanceof DirectionalLight)) {
                    shader.set(inputID, ((PerspectiveCamera)Pass2Shader.shadowSystem.getCurrentLightProperties().camera).fieldOfView);
                }
            }
        };
        public static final BaseShader.Setter lightExponent = new BaseShader.GlobalSetter(){

            public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
                BaseLight l = shadowSystem.getCurrentLight();
                if (l instanceof SpotLight) {
                    shader.set(inputID, ((SpotLight)l).exponent);
                }
                if (l instanceof PointLight) {
                    shader.set(inputID, 0.0f);
                }
            }
        };
    }

    public static class Inputs
    extends DefaultShader.Inputs {
        public static final BaseShader.Uniform shadowMapProjViewTrans = new BaseShader.Uniform("u_shadowMapProjViewTrans");
        public static final BaseShader.Uniform shadowTexture = new BaseShader.Uniform("u_shadowTexture");
        public static final BaseShader.Uniform uvTransform = new BaseShader.Uniform("u_uvTransform");
        public static final BaseShader.Uniform lightColor = new BaseShader.Uniform("u_lightColor");
        public static final BaseShader.Uniform lightDirection = new BaseShader.Uniform("u_lightDirection");
        public static final BaseShader.Uniform lightIntensity = new BaseShader.Uniform("u_lightIntensity");
        public static final BaseShader.Uniform lightPosition = new BaseShader.Uniform("u_lightPosition");
        public static final BaseShader.Uniform lightCutoffAngle = new BaseShader.Uniform("u_lightCutoffAngle");
        public static final BaseShader.Uniform lightExponent = new BaseShader.Uniform("u_lightExponent");
    }

    public static class Config
    extends DefaultShader.Config {
        public ClassicalShadowSystem shadowSystem;

        public Config(ClassicalShadowSystem shadowSystem) {
            this.shadowSystem = shadowSystem;
        }
    }
}

