/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.plotting.artifact;

import java.awt.Color;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.Plotter2DAdapter;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;

public class PointListArtifact
extends Artifact {
    private final List<Point2D> points = new ArrayList<Point2D>();
    private int historyLength = 1;
    private Color historyColor = Color.BLUE;
    int medianFilterSize = 20;
    int meanFilterSize = 999;
    private double size = 10.0;
    private final Point2D tempPoint = new Point2D();
    private final Vector2D tempRadii = new Vector2D();

    public PointListArtifact(String id) {
        this(id, 1);
    }

    public PointListArtifact(String id, Point2D point) {
        this(id, 1);
        this.setPoint(point);
    }

    public PointListArtifact(String id, int history) {
        super(id);
        this.setType("point");
        this.setLevel(2);
        System.currentTimeMillis();
        this.historyLength = history;
        this.color = Color.red;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoint(Point2D point) {
        List<Point2D> list = this.points;
        synchronized (list) {
            this.points.add(point);
            if (this.points.size() > this.historyLength) {
                this.points.remove(0);
            }
        }
    }

    public void setSize(double size) {
        this.size = size;
    }

    public Point2D getPoint2d() {
        if (this.points.size() == 0) {
            return null;
        }
        return this.points.get(0);
    }

    public void setHistoryLength(int length) {
        this.historyLength = length;
    }

    public void setHistoryColor(Color color) {
        this.historyColor = color;
    }

    public static double getMedian(Vector<?> buffer) {
        int n = buffer.size();
        double[] unsorted = new double[n];
        double[] sorted = new double[n];
        for (int i = 0; i < n; ++i) {
            unsorted[i] = (Double)buffer.elementAt(i);
        }
        System.arraycopy(unsorted, 0, sorted, 0, n);
        Arrays.sort(sorted);
        return sorted[n / 2];
    }

    public double getMean(Vector<?> buffer) {
        int n = buffer.size();
        double mean = 0.0;
        for (int i = 0; i < n; ++i) {
            mean += ((Double)buffer.elementAt(i)).doubleValue();
        }
        return mean /= (double)n;
    }

    public double getStdDev(Vector<?> buffer, double mean) {
        int n = buffer.size();
        double sd = 0.0;
        for (int i = 0; i < n; ++i) {
            sd += Math.pow((Double)buffer.elementAt(i) - mean, 2.0);
        }
        sd = Math.sqrt(sd);
        return sd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics2DAdapter graphics) {
        Vector<Double> xMedianFliter = new Vector<Double>();
        Vector<Double> yMedianFliter = new Vector<Double>();
        Vector<Double> xMeanFilter = new Vector<Double>();
        Vector<Double> yMeanFilter = new Vector<Double>();
        Point2D coordinate = null;
        List<Point2D> list = this.points;
        synchronized (list) {
            for (int i = 0; i < this.points.size(); ++i) {
                coordinate = this.points.get(i);
                if (coordinate == null) continue;
                if (i == this.points.size() - 1) {
                    graphics.setColor(this.color);
                    this.tempPoint.set(coordinate.getX(), coordinate.getY());
                    this.tempRadii.set(this.size, this.size);
                    graphics.drawOvalFilled((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.tempRadii);
                } else {
                    graphics.setColor(this.historyColor);
                    this.tempPoint.set(coordinate.getX(), coordinate.getY());
                    this.tempRadii.set(this.size * 0.7, this.size * 0.7);
                    graphics.drawOvalFilled((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.tempRadii);
                }
                if (i >= this.points.size() - this.medianFilterSize) {
                    xMedianFliter.addElement(new Double(coordinate.getX()));
                    yMedianFliter.addElement(new Double(coordinate.getY()));
                }
                if (i < this.points.size() - this.meanFilterSize) continue;
                xMeanFilter.addElement(new Double(coordinate.getX()));
                yMeanFilter.addElement(new Double(coordinate.getY()));
            }
        }
    }

    @Override
    public void drawLegend(Plotter2DAdapter graphics, Point2D origin) {
    }

    public void save(PrintWriter printWriter) {
        for (int i = 0; i < this.points.size(); ++i) {
            Point2D coordinate = this.points.get(i);
            printWriter.println(coordinate.getX() + " " + coordinate.getY());
        }
    }

    @Override
    public void drawHistory(Graphics2DAdapter graphics) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void takeHistorySnapshot() {
        throw new RuntimeException("Not implemented!");
    }
}

