/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.conversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import us.ihmc.euclid.matrix.LinearTransform3D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.TexCoord2f;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.SDFAppearance;
import us.ihmc.graphicsDescription.appearance.YoAppearanceMaterial;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.appearance.YoAppearanceTexture;
import us.ihmc.graphicsDescription.color.MutableColor;
import us.ihmc.graphicsDescription.instructions.ArcTorusGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CapsuleGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.ConeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CubeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CylinderGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.EllipsoidGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.ExtrudedPolygonGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddExtrusionInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddHeightMapInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddModelFileInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DPrimitiveInstruction;
import us.ihmc.graphicsDescription.instructions.HemiEllipsoidGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PolygonGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PrimitiveGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PyramidCubeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.SphereGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.TruncatedConeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.WedgeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DIdentityInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DRotateInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DScaleInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DTranslateInstruction;
import us.ihmc.scs2.definition.AffineTransformDefinition;
import us.ihmc.scs2.definition.geometry.ArcTorus3DDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.ConvexPolytope3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.Ellipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.ExtrudedPolygon2DDefinition;
import us.ihmc.scs2.definition.geometry.ExtrusionDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.HemiEllipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.ModelFileGeometryDefinition;
import us.ihmc.scs2.definition.geometry.Polygon3DDefinition;
import us.ihmc.scs2.definition.geometry.PyramidBox3DDefinition;
import us.ihmc.scs2.definition.geometry.Ramp3DDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.geometry.Torus3DDefinition;
import us.ihmc.scs2.definition.geometry.TriangleMesh3DDefinition;
import us.ihmc.scs2.definition.geometry.TruncatedCone3DDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.TextureDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class VisualsConversionTools {
    public static Graphics3DObject toGraphics3DObject(Collection<? extends VisualDefinition> source) {
        Graphics3DObject output = new Graphics3DObject();
        for (VisualDefinition visualDefinition : source) {
            output.combine(VisualsConversionTools.toGraphics3DObject(visualDefinition));
        }
        return output;
    }

    public static Graphics3DObject toGraphics3DObject(VisualDefinition source) {
        List<Graphics3DPrimitiveInstruction> instructions;
        if (source == null) {
            return null;
        }
        Graphics3DObject output = new Graphics3DObject();
        AffineTransformDefinition originPose = source.getOriginPose();
        if (originPose.hasTranslation()) {
            output.translate((Tuple3DReadOnly)originPose.getTranslation());
        }
        if (originPose.hasLinearTransform()) {
            LinearTransform3D linearTransform = originPose.getLinearTransform();
            if (linearTransform.isRotationMatrix()) {
                output.rotate((Orientation3DReadOnly)linearTransform.getAsQuaternion());
            } else {
                if (!linearTransform.getPreScaleQuaternion().isZeroOrientation()) {
                    output.rotate((Orientation3DReadOnly)linearTransform.getPreScaleQuaternion());
                }
                output.scale(linearTransform.getScaleVector());
                if (!linearTransform.getPostScaleQuaternion().isZeroOrientation()) {
                    output.rotate((Orientation3DReadOnly)linearTransform.getPostScaleQuaternion());
                }
            }
        }
        if ((instructions = VisualsConversionTools.toGraphics3DPrimitiveInstruction(source.getGeometryDefinition())) == null || instructions.isEmpty()) {
            return null;
        }
        for (Graphics3DPrimitiveInstruction instruction : instructions) {
            if (instruction instanceof Graphics3DInstruction) {
                ((Graphics3DInstruction)instruction).setAppearance(VisualsConversionTools.toAppearanceDefinition(source.getMaterialDefinition()));
            }
            output.addInstruction(instruction);
        }
        return output;
    }

    public static List<Graphics3DPrimitiveInstruction> toGraphics3DPrimitiveInstruction(GeometryDefinition source) {
        if (source == null) {
            return null;
        }
        if (source instanceof ArcTorus3DDefinition) {
            ArcTorus3DDefinition arcTorus = (ArcTorus3DDefinition)source;
            return Collections.singletonList(new ArcTorusGraphics3DInstruction(arcTorus.getStartAngle(), arcTorus.getEndAngle(), arcTorus.getMajorRadius(), arcTorus.getMinorRadius(), arcTorus.getResolution()));
        }
        if (source instanceof Box3DDefinition) {
            Box3DDefinition box = (Box3DDefinition)source;
            return Collections.singletonList(new CubeGraphics3DInstruction(box.getSizeX(), box.getSizeY(), box.getSizeZ(), box.isCentered()));
        }
        if (source instanceof Capsule3DDefinition) {
            Capsule3DDefinition capsule = (Capsule3DDefinition)source;
            return Collections.singletonList(new CapsuleGraphics3DInstruction(capsule.getLength(), capsule.getRadiusX(), capsule.getRadiusY(), capsule.getRadiusZ(), capsule.getResolution()));
        }
        if (source instanceof Cone3DDefinition) {
            Cone3DDefinition cone = (Cone3DDefinition)source;
            return Collections.singletonList(new ConeGraphics3DInstruction(cone.getHeight(), cone.getRadius(), cone.getResolution()));
        }
        if (source instanceof ConvexPolytope3DDefinition) {
            return null;
        }
        if (source instanceof Cylinder3DDefinition) {
            Cylinder3DDefinition cylinder = (Cylinder3DDefinition)source;
            return Collections.singletonList(new CylinderGraphics3DInstruction(cylinder.getRadius(), cylinder.getLength(), cylinder.getResolution()));
        }
        if (source instanceof Ellipsoid3DDefinition) {
            Ellipsoid3DDefinition ellipsoid = (Ellipsoid3DDefinition)source;
            return Collections.singletonList(new EllipsoidGraphics3DInstruction(ellipsoid.getRadiusX(), ellipsoid.getRadiusY(), ellipsoid.getRadiusZ(), ellipsoid.getResolution()));
        }
        if (source instanceof ExtrudedPolygon2DDefinition) {
            ExtrudedPolygon2DDefinition polygon = (ExtrudedPolygon2DDefinition)source;
            return Collections.singletonList(new ExtrudedPolygonGraphics3DInstruction(polygon.getPolygonVertices(), polygon.getTopZ() - polygon.getBottomZ()));
        }
        if (source instanceof ExtrusionDefinition) {
            return null;
        }
        if (source instanceof HemiEllipsoid3DDefinition) {
            HemiEllipsoid3DDefinition hemiEllipsoid = (HemiEllipsoid3DDefinition)source;
            return Collections.singletonList(new HemiEllipsoidGraphics3DInstruction(hemiEllipsoid.getRadiusX(), hemiEllipsoid.getRadiusY(), hemiEllipsoid.getRadiusZ(), hemiEllipsoid.getResolution()));
        }
        if (source instanceof ModelFileGeometryDefinition) {
            ModelFileGeometryDefinition model = (ModelFileGeometryDefinition)source;
            ArrayList<Graphics3DPrimitiveInstruction> output = new ArrayList<Graphics3DPrimitiveInstruction>();
            if (model.getScale() != null) {
                output.add(new Graphics3DScaleInstruction((Vector3DReadOnly)model.getScale()));
            }
            if (model.getSubmeshes() == null || model.getSubmeshes().isEmpty()) {
                output.add(new Graphics3DAddModelFileInstruction(model.getFileName(), null, model.getResourceDirectories(), model.getResourceClassLoader()));
            } else {
                output.add(new Graphics3DAddModelFileInstruction(model.getFileName(), ((ModelFileGeometryDefinition.SubMeshDefinition)model.getSubmeshes().get(0)).getName(), ((ModelFileGeometryDefinition.SubMeshDefinition)model.getSubmeshes().get(0)).getCenter(), null, model.getResourceDirectories(), model.getResourceClassLoader()));
            }
            return output;
        }
        if (source instanceof PyramidBox3DDefinition) {
            PyramidBox3DDefinition pyramidBox = (PyramidBox3DDefinition)source;
            return Collections.singletonList(new PyramidCubeGraphics3DInstruction(pyramidBox.getBoxSizeX(), pyramidBox.getBoxSizeY(), pyramidBox.getBoxSizeZ(), pyramidBox.getPyramidHeight()));
        }
        if (source instanceof Ramp3DDefinition) {
            Ramp3DDefinition ramp = (Ramp3DDefinition)source;
            return Collections.singletonList(new WedgeGraphics3DInstruction(ramp.getSizeX(), ramp.getSizeY(), ramp.getSizeZ()));
        }
        if (source instanceof Sphere3DDefinition) {
            Sphere3DDefinition sphere = (Sphere3DDefinition)source;
            return Collections.singletonList(new SphereGraphics3DInstruction(sphere.getRadius(), sphere.getResolution()));
        }
        if (source instanceof Torus3DDefinition) {
            Torus3DDefinition torus = (Torus3DDefinition)source;
            return Collections.singletonList(new ArcTorusGraphics3DInstruction(0.0, Math.PI * 2, torus.getMajorRadius(), torus.getMinorRadius(), torus.getResolution()));
        }
        if (source instanceof TriangleMesh3DDefinition) {
            TriangleMesh3DDefinition mesh = (TriangleMesh3DDefinition)source;
            return Collections.singletonList(new Graphics3DAddMeshDataInstruction(new MeshDataHolder(mesh.getVertices(), mesh.getTextures() == null ? null : (TexCoord2f[])Arrays.stream(mesh.getTextures()).map(t -> new TexCoord2f(t.getX32(), t.getY32())).toArray(TexCoord2f[]::new), mesh.getTriangleIndices(), mesh.getNormals()), null));
        }
        if (source instanceof TruncatedCone3DDefinition) {
            TruncatedCone3DDefinition cone = (TruncatedCone3DDefinition)source;
            return Collections.singletonList(new TruncatedConeGraphics3DInstruction(cone.getHeight(), cone.getBaseRadiusX(), cone.getBaseRadiusY(), cone.getTopRadiusX(), cone.getTopRadiusY(), cone.getResolution()));
        }
        throw new IllegalArgumentException("Unsupported geometry type: " + source.getClass().getName());
    }

    public static AppearanceDefinition toAppearanceDefinition(MaterialDefinition source) {
        if (source == null) {
            return null;
        }
        ColorDefinition diffuseColor = source.getDiffuseColor();
        ColorDefinition specularColor = source.getSpecularColor();
        ColorDefinition ambientColor = source.getAmbientColor();
        if (diffuseColor != null) {
            if (specularColor != null && ambientColor != null) {
                YoAppearanceMaterial output = new YoAppearanceMaterial();
                output.setDiffuseColor((float)diffuseColor.getRed(), (float)diffuseColor.getGreen(), (float)diffuseColor.getBlue());
                output.setSpecularColor((float)specularColor.getRed(), (float)specularColor.getGreen(), (float)specularColor.getBlue());
                output.setAmbientColor((float)ambientColor.getRed(), (float)ambientColor.getGreen(), (float)ambientColor.getBlue());
                output.setShininess((float)source.getShininess());
                return output;
            }
            return new YoAppearanceRGBColor(diffuseColor.getRed(), diffuseColor.getGreen(), diffuseColor.getBlue(), 1.0 - diffuseColor.getAlpha());
        }
        TextureDefinition diffuseMap = source.getDiffuseMap();
        if (diffuseMap == null) {
            return null;
        }
        if (diffuseMap.getFilename() != null) {
            return new YoAppearanceTexture(diffuseMap.getFilename());
        }
        if (diffuseMap.getFileURL() != null) {
            return new YoAppearanceTexture(diffuseMap.getFileURL().toExternalForm());
        }
        if (diffuseMap.getImage() != null) {
            return new YoAppearanceTexture(diffuseMap.getImage());
        }
        return null;
    }

    public static ColorDefinition toColorDefinition(MutableColor mutableColor, double transparency) {
        return new ColorDefinition((double)mutableColor.getX(), (double)mutableColor.getY(), (double)mutableColor.getZ(), 1.0 - transparency);
    }

    public static MaterialDefinition toMaterialDefinition(AppearanceDefinition appearanceDefinition) {
        if (appearanceDefinition == null) {
            return null;
        }
        MaterialDefinition output = new MaterialDefinition();
        if (!(appearanceDefinition instanceof SDFAppearance)) {
            if (appearanceDefinition instanceof YoAppearanceMaterial) {
                YoAppearanceMaterial yoAppearanceMaterial = (YoAppearanceMaterial)appearanceDefinition;
                output.setDiffuseColor(VisualsConversionTools.toColorDefinition(yoAppearanceMaterial.getDiffuseColor(), yoAppearanceMaterial.getTransparency()));
                output.setSpecularColor(VisualsConversionTools.toColorDefinition(yoAppearanceMaterial.getSpecularColor(), yoAppearanceMaterial.getTransparency()));
                output.setShininess((double)yoAppearanceMaterial.getShininess());
                output.setAmbientColor(VisualsConversionTools.toColorDefinition(yoAppearanceMaterial.getAmbientColor(), yoAppearanceMaterial.getTransparency()));
            } else if (appearanceDefinition instanceof YoAppearanceRGBColor) {
                YoAppearanceRGBColor yoAppearanceRGBColor = (YoAppearanceRGBColor)appearanceDefinition;
                output.setDiffuseColor(VisualsConversionTools.toColorDefinition(yoAppearanceRGBColor.getColor(), yoAppearanceRGBColor.getTransparency()));
            } else if (appearanceDefinition instanceof YoAppearanceTexture) {
                YoAppearanceTexture yoAppearanceTexture = (YoAppearanceTexture)appearanceDefinition;
                TextureDefinition textureDefinition = new TextureDefinition();
                textureDefinition.setFilename(yoAppearanceTexture.getPath());
                textureDefinition.setImage(yoAppearanceTexture.getBufferedImage());
                output.setDiffuseMap(textureDefinition);
            } else {
                throw new UnsupportedOperationException("Unsupported appearance definition type: " + String.valueOf(appearanceDefinition));
            }
        }
        return output;
    }

    public static List<VisualDefinition> toVisualDefinitions(Graphics3DObject graphics3DObject) {
        if (graphics3DObject == null) {
            return Collections.emptyList();
        }
        ArrayList<VisualDefinition> visualDefinitions = new ArrayList<VisualDefinition>();
        AffineTransform currentTransform = new AffineTransform();
        for (Graphics3DPrimitiveInstruction instruction : graphics3DObject.getGraphics3DInstructions()) {
            if (instruction instanceof Graphics3DIdentityInstruction) {
                currentTransform.setIdentity();
                continue;
            }
            if (instruction instanceof Graphics3DRotateInstruction) {
                currentTransform.appendOrientation((Orientation3DReadOnly)((Graphics3DRotateInstruction)instruction).getRotationMatrix());
                continue;
            }
            if (instruction instanceof Graphics3DScaleInstruction) {
                currentTransform.appendScale((Tuple3DReadOnly)((Graphics3DScaleInstruction)instruction).getScaleFactor());
                continue;
            }
            if (instruction instanceof Graphics3DTranslateInstruction) {
                currentTransform.appendTranslation((Tuple3DReadOnly)((Graphics3DTranslateInstruction)instruction).getTranslation());
                continue;
            }
            if (instruction instanceof Graphics3DInstruction) {
                Graphics3DInstruction extrusion;
                VisualDefinition visualDefinition = new VisualDefinition();
                visualDefinition.setOriginPose((AffineTransformReadOnly)new AffineTransform((AffineTransformReadOnly)currentTransform));
                visualDefinition.setMaterialDefinition(VisualsConversionTools.toMaterialDefinition(((Graphics3DInstruction)instruction).getAppearance()));
                visualDefinitions.add(visualDefinition);
                if (instruction instanceof PrimitiveGraphics3DInstruction) {
                    PrimitiveGraphics3DInstruction cone;
                    if (instruction instanceof ArcTorusGraphics3DInstruction) {
                        ArcTorusGraphics3DInstruction arcTorus = (ArcTorusGraphics3DInstruction)instruction;
                        visualDefinition.setGeometryDefinition((GeometryDefinition)new ArcTorus3DDefinition(arcTorus.getStartAngle(), arcTorus.getEndAngle(), arcTorus.getMajorRadius(), arcTorus.getMinorRadius(), arcTorus.getResolution()));
                        continue;
                    }
                    if (instruction instanceof CapsuleGraphics3DInstruction) {
                        CapsuleGraphics3DInstruction capsule = (CapsuleGraphics3DInstruction)instruction;
                        visualDefinition.setGeometryDefinition((GeometryDefinition)new Capsule3DDefinition(capsule.getHeight(), capsule.getXRadius(), capsule.getYRadius(), capsule.getZRadius(), capsule.getResolution()));
                        continue;
                    }
                    if (instruction instanceof ConeGraphics3DInstruction) {
                        cone = (ConeGraphics3DInstruction)instruction;
                        visualDefinition.setGeometryDefinition((GeometryDefinition)new Cone3DDefinition(((ConeGraphics3DInstruction)cone).getHeight(), ((ConeGraphics3DInstruction)cone).getRadius(), ((ConeGraphics3DInstruction)cone).getResolution()));
                        continue;
                    }
                    if (instruction instanceof CubeGraphics3DInstruction) {
                        CubeGraphics3DInstruction cube = (CubeGraphics3DInstruction)instruction;
                        visualDefinition.setGeometryDefinition((GeometryDefinition)new Box3DDefinition(cube.getLength(), cube.getWidth(), cube.getHeight(), cube.getCenteredInTheCenter()));
                        continue;
                    }
                    if (instruction instanceof CylinderGraphics3DInstruction) {
                        CylinderGraphics3DInstruction cylinder = (CylinderGraphics3DInstruction)instruction;
                        visualDefinition.setGeometryDefinition((GeometryDefinition)new Cylinder3DDefinition(cylinder.getHeight(), cylinder.getRadius(), false));
                        continue;
                    }
                    if (instruction instanceof EllipsoidGraphics3DInstruction) {
                        EllipsoidGraphics3DInstruction ellipsoid = (EllipsoidGraphics3DInstruction)instruction;
                        visualDefinition.setGeometryDefinition((GeometryDefinition)new Ellipsoid3DDefinition(ellipsoid.getXRadius(), ellipsoid.getYRadius(), ellipsoid.getZRadius(), ellipsoid.getResolution()));
                        continue;
                    }
                    if (instruction instanceof ExtrudedPolygonGraphics3DInstruction) {
                        extrusion = (ExtrudedPolygonGraphics3DInstruction)instruction;
                        visualDefinition.setGeometryDefinition((GeometryDefinition)new ExtrudedPolygon2DDefinition(ExtrudedPolygon2DDefinition.toPoint2DDefinitionList(((ExtrudedPolygonGraphics3DInstruction)extrusion).getPolygonPoints()), true, ((ExtrudedPolygonGraphics3DInstruction)extrusion).getExtrusionHeight()));
                        continue;
                    }
                    if (instruction instanceof HemiEllipsoidGraphics3DInstruction) {
                        HemiEllipsoidGraphics3DInstruction hemiEllipsoid = (HemiEllipsoidGraphics3DInstruction)instruction;
                        visualDefinition.setGeometryDefinition((GeometryDefinition)new HemiEllipsoid3DDefinition(hemiEllipsoid.getXRadius(), hemiEllipsoid.getYRadius(), hemiEllipsoid.getZRadius(), hemiEllipsoid.getResolution()));
                        continue;
                    }
                    if (instruction instanceof PolygonGraphics3DInstruction) {
                        PolygonGraphics3DInstruction polygon = (PolygonGraphics3DInstruction)instruction;
                        visualDefinition.setGeometryDefinition((GeometryDefinition)new Polygon3DDefinition(Polygon3DDefinition.toPoint3DDefinitionList(polygon.getPolygonPoints()), true));
                        continue;
                    }
                    if (instruction instanceof PyramidCubeGraphics3DInstruction) {
                        PyramidCubeGraphics3DInstruction pyramid = (PyramidCubeGraphics3DInstruction)instruction;
                        visualDefinition.setGeometryDefinition((GeometryDefinition)new PyramidBox3DDefinition(pyramid.getLengthX(), pyramid.getWidthY(), pyramid.getHeightZ(), pyramid.getPyramidHeight()));
                        continue;
                    }
                    if (instruction instanceof SphereGraphics3DInstruction) {
                        SphereGraphics3DInstruction sphere = (SphereGraphics3DInstruction)instruction;
                        visualDefinition.setGeometryDefinition((GeometryDefinition)new Sphere3DDefinition(sphere.getRadius(), sphere.getResolution()));
                        continue;
                    }
                    if (instruction instanceof TruncatedConeGraphics3DInstruction) {
                        cone = (TruncatedConeGraphics3DInstruction)instruction;
                        visualDefinition.setGeometryDefinition((GeometryDefinition)new TruncatedCone3DDefinition(((TruncatedConeGraphics3DInstruction)cone).getHeight(), ((TruncatedConeGraphics3DInstruction)cone).getXTopRadius(), ((TruncatedConeGraphics3DInstruction)cone).getYTopRadius(), ((TruncatedConeGraphics3DInstruction)cone).getXBaseRadius(), ((TruncatedConeGraphics3DInstruction)cone).getYBaseRadius(), false, ((TruncatedConeGraphics3DInstruction)cone).getResolution()));
                        continue;
                    }
                    if (!(instruction instanceof WedgeGraphics3DInstruction)) continue;
                    WedgeGraphics3DInstruction wedge = (WedgeGraphics3DInstruction)instruction;
                    visualDefinition.setGeometryDefinition((GeometryDefinition)new Ramp3DDefinition(wedge.getLengthX(), wedge.getWidthY(), wedge.getHeightZ()));
                    continue;
                }
                if (instruction instanceof Graphics3DAddExtrusionInstruction) {
                    extrusion = (Graphics3DAddExtrusionInstruction)instruction;
                    visualDefinition.setGeometryDefinition((GeometryDefinition)new ExtrusionDefinition(((Graphics3DAddExtrusionInstruction)extrusion).getBufferedImage(), ((Graphics3DAddExtrusionInstruction)extrusion).getHeight()));
                    continue;
                }
                if (instruction instanceof Graphics3DAddHeightMapInstruction) {
                    throw new UnsupportedOperationException("Unsupported instruction");
                }
                if (instruction instanceof Graphics3DAddMeshDataInstruction) {
                    Graphics3DAddMeshDataInstruction mesh = (Graphics3DAddMeshDataInstruction)instruction;
                    visualDefinition.setGeometryDefinition((GeometryDefinition)new TriangleMesh3DDefinition(mesh.getMeshData().getName(), mesh.getMeshData().getVertices(), (Point2D32[])Stream.of(mesh.getMeshData().getTexturePoints()).map(Point2D32::new).toArray(Point2D32[]::new), mesh.getMeshData().getVertexNormals(), mesh.getMeshData().getTriangleIndices()));
                    continue;
                }
                if (instruction instanceof Graphics3DAddModelFileInstruction) {
                    Graphics3DAddModelFileInstruction model = (Graphics3DAddModelFileInstruction)instruction;
                    ModelFileGeometryDefinition definition = new ModelFileGeometryDefinition();
                    definition.setFileName(model.getFileName());
                    definition.setResourceClassLoader(model.getResourceClassLoader());
                    definition.setResourceDirectories(model.getResourceDirectories());
                    definition.setSubmeshes(Collections.singletonList(new ModelFileGeometryDefinition.SubMeshDefinition(model.getSubmesh(), model.centerSubmesh())));
                    visualDefinition.setGeometryDefinition((GeometryDefinition)definition);
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported instruction type: " + String.valueOf(instruction));
            }
            throw new UnsupportedOperationException("Unsupported instruction type: " + String.valueOf(instruction));
        }
        return visualDefinitions;
    }
}

