/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import gnu.trove.list.array.TDoubleArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.GraphicsUpdatable;
import us.ihmc.graphicsDescription.PointCloud3DMeshGenerator;
import us.ihmc.graphicsDescription.SegmentedLine3DMeshDataGenerator;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicJob;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoGraphicPolynomial3D
extends YoGraphic
implements RemoteYoGraphic,
GraphicsUpdatable {
    private static final int COLOR_RESOLUTION = 128;
    private static final AppearanceDefinition BLACK_APPEARANCE = YoAppearance.Black();
    private final YoGraphicJob yoGraphicJob;
    private final double radius;
    private final int resolution;
    private final int radialResolution;
    private final Graphics3DObject graphics3dObject = new Graphics3DObject();
    private final AppearanceDefinition[] colorPalette = YoGraphicPolynomial3D.createColorPalette(128);
    private final SegmentedLine3DMeshDataGenerator segmentedLine3DMeshGenerator;
    private final PointCloud3DMeshGenerator pointCloud3DMeshGenerator;
    private final Graphics3DAddMeshDataInstruction[] graphics3DAddMeshDataInstructions;
    private final Point3D[] intermediatePositions;
    private final Vector3D[] intermediateVelocities;
    private final Vector3D[] intermediateAccelerations;
    private final boolean hasPoseDefined;
    private final YoFramePose3D poseToWorldFrame;
    private final int numberOfPolynomials;
    private final Polynomial3DVariables[] yoPolynomial3Ds;
    private final int[] yoPolynomialSizes;
    private final YoDouble[] waypointTimes;
    private final YoEnum<?> currentGraphicType;
    private final YoEnum<?> currentColorType;
    private final YoBoolean readerExists;
    private final AtomicBoolean dirtyGraphic = new AtomicBoolean(false);
    private final RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();

    public YoGraphicPolynomial3D(String name, Polynomial3DVariableHolder yoPolynomial3D, YoDouble trajectoryTime, double radius, int resolution, int radialResolution, YoRegistry registry) {
        this(name, null, yoPolynomial3D, trajectoryTime, radius, resolution, radialResolution, registry);
    }

    public YoGraphicPolynomial3D(String name, YoFramePose3D poseFromTrajectoryFrameToWorldFrame, Polynomial3DVariableHolder yoPolynomial3D, YoDouble trajectoryTime, double radius, int resolution, int radialResolution, YoRegistry registry) {
        this(name, poseFromTrajectoryFrameToWorldFrame, Collections.singletonList(yoPolynomial3D), Collections.singletonList(trajectoryTime), radius, resolution, radialResolution, registry);
    }

    public YoGraphicPolynomial3D(String name, List<? extends Polynomial3DVariableHolder> yoPolynomial3Ds, List<YoDouble> waypointTimes, double radius, int resolution, int radialResolution, YoRegistry registry) {
        this(name, null, yoPolynomial3Ds, waypointTimes, radius, resolution, radialResolution, registry);
    }

    public YoGraphicPolynomial3D(String name, Polynomial3DVariableHolder[] yoPolynomial3Ds, YoDouble[] waypointTimes, double radius, int resolution, int radialResolution, YoRegistry registry) {
        this(name, null, yoPolynomial3Ds, waypointTimes, radius, resolution, radialResolution, registry);
    }

    public YoGraphicPolynomial3D(String name, YoFramePose3D poseFromTrajectoryFrameToWorldFrame, List<? extends Polynomial3DVariableHolder> yoPolynomial3Ds, List<YoDouble> waypointTimes, double radius, int resolution, int radialResolution, YoRegistry registry) {
        this(name, poseFromTrajectoryFrameToWorldFrame, yoPolynomial3Ds.toArray(new Polynomial3DVariableHolder[0]), YoGraphicPolynomial3D.toArray(waypointTimes), radius, resolution, radialResolution, registry);
    }

    public YoGraphicPolynomial3D(String name, YoFramePose3D poseFromTrajectoryFrameToWorldFrame, Polynomial3DVariableHolder[] yoPolynomial3Ds, YoDouble[] waypointTimes, double radius, int resolution, int radialResolution, YoRegistry registry) {
        super(name);
        int i;
        this.yoGraphicJob = YoGraphicJob.WRITER;
        if (yoPolynomial3Ds.length != waypointTimes.length) {
            throw new RuntimeException("Inconsistent number of YoPolynomial3Ds ( " + yoPolynomial3Ds.length + " ) and waypoint times ( " + waypointTimes.length + " ).");
        }
        this.radius = radius;
        this.resolution = resolution;
        this.radialResolution = radialResolution;
        this.yoPolynomial3Ds = (Polynomial3DVariables[])Stream.of(yoPolynomial3Ds).map(Polynomial3DVariables::new).toArray(Polynomial3DVariables[]::new);
        this.waypointTimes = waypointTimes;
        this.hasPoseDefined = poseFromTrajectoryFrameToWorldFrame != null;
        this.poseToWorldFrame = poseFromTrajectoryFrameToWorldFrame;
        this.numberOfPolynomials = yoPolynomial3Ds.length;
        this.yoPolynomialSizes = new int[3 * this.numberOfPolynomials];
        for (i = 0; i < this.numberOfPolynomials; ++i) {
            this.yoPolynomialSizes[3 * i + 0] = this.yoPolynomial3Ds[i].getYoPolynomialX().getMaximumNumberOfCoefficients() + 1;
            this.yoPolynomialSizes[3 * i + 1] = this.yoPolynomial3Ds[i].getYoPolynomialY().getMaximumNumberOfCoefficients() + 1;
            this.yoPolynomialSizes[3 * i + 2] = this.yoPolynomial3Ds[i].getYoPolynomialZ().getMaximumNumberOfCoefficients() + 1;
        }
        this.currentGraphicType = new YoEnum(name + "CurrentGraphicType", registry, TrajectoryGraphicType.class, false);
        this.currentColorType = new YoEnum(name + "CurrentColorType", registry, TrajectoryColorType.class, false);
        this.readerExists = new YoBoolean(name + "ReaderExists", registry);
        this.intermediatePositions = new Point3D[resolution];
        this.intermediateVelocities = new Vector3D[resolution];
        this.intermediateAccelerations = new Vector3D[resolution];
        for (i = 0; i < resolution; ++i) {
            this.intermediatePositions[i] = new Point3D();
            this.intermediateVelocities[i] = new Vector3D();
            this.intermediateAccelerations[i] = new Vector3D();
        }
        this.segmentedLine3DMeshGenerator = new SegmentedLine3DMeshDataGenerator(resolution, radialResolution, radius);
        this.pointCloud3DMeshGenerator = new PointCloud3DMeshGenerator(resolution, radialResolution, radius);
        this.graphics3DAddMeshDataInstructions = new Graphics3DAddMeshDataInstruction[resolution - 1];
        this.graphics3dObject.setChangeable(true);
        for (i = 0; i < resolution - 1; ++i) {
            this.graphics3DAddMeshDataInstructions[i] = this.graphics3dObject.addMeshData(this.segmentedLine3DMeshGenerator.getMeshDataHolders()[i], YoAppearance.AliceBlue());
        }
        this.setupDirtyGraphicListener();
    }

    public static YoGraphicPolynomial3D createAsRemoteYoGraphic(String name, YoVariable[] yoVariables, double[] constants) {
        return new YoGraphicPolynomial3D(name, yoVariables, constants);
    }

    private YoGraphicPolynomial3D(String name, YoVariable[] yoVariables, double[] constants) {
        super(name);
        int i;
        this.yoGraphicJob = YoGraphicJob.READER;
        int index = 0;
        this.radius = constants[index++];
        this.resolution = (int)constants[index++];
        this.radialResolution = (int)constants[index++];
        this.hasPoseDefined = (int)constants[index++] == 1;
        this.numberOfPolynomials = (int)constants[index++];
        this.yoPolynomialSizes = YoGraphicPolynomial3D.subArray(constants, index, 3 * this.numberOfPolynomials);
        index = 0;
        if (this.hasPoseDefined) {
            YoDouble xVariable = (YoDouble)yoVariables[index++];
            YoDouble yVariable = (YoDouble)yoVariables[index++];
            YoDouble zVariable = (YoDouble)yoVariables[index++];
            YoFramePoint3D position = new YoFramePoint3D(xVariable, yVariable, zVariable, ReferenceFrame.getWorldFrame());
            YoDouble qx = (YoDouble)yoVariables[index++];
            YoDouble qy = (YoDouble)yoVariables[index++];
            YoDouble qz = (YoDouble)yoVariables[index++];
            YoDouble qs = (YoDouble)yoVariables[index++];
            YoFrameQuaternion orientation = new YoFrameQuaternion(qx, qy, qz, qs, ReferenceFrame.getWorldFrame());
            this.poseToWorldFrame = new YoFramePose3D(position, orientation);
        } else {
            this.poseToWorldFrame = null;
        }
        this.yoPolynomial3Ds = new Polynomial3DVariables[this.numberOfPolynomials];
        for (i = 0; i < this.numberOfPolynomials; ++i) {
            int xSize = this.yoPolynomialSizes[3 * i + 0];
            int ySize = this.yoPolynomialSizes[3 * i + 1];
            int zSize = this.yoPolynomialSizes[3 * i + 2];
            PolynomialVariables xPolynomial = new PolynomialVariables(YoGraphicPolynomial3D.subArray(yoVariables, index + 1, xSize - 1), (YoInteger)yoVariables[index]);
            PolynomialVariables yPolynomial = new PolynomialVariables(YoGraphicPolynomial3D.subArray(yoVariables, (index += xSize) + 1, ySize - 1), (YoInteger)yoVariables[index]);
            PolynomialVariables zPolynomial = new PolynomialVariables(YoGraphicPolynomial3D.subArray(yoVariables, (index += ySize) + 1, zSize - 1), (YoInteger)yoVariables[index]);
            index += zSize;
            this.yoPolynomial3Ds[i] = new Polynomial3DVariables(xPolynomial, yPolynomial, zPolynomial);
        }
        this.waypointTimes = YoGraphicPolynomial3D.subArray(yoVariables, index, this.numberOfPolynomials);
        index += this.numberOfPolynomials;
        this.currentGraphicType = (YoEnum)yoVariables[index++];
        this.currentColorType = (YoEnum)yoVariables[index++];
        this.readerExists = (YoBoolean)yoVariables[index++];
        this.intermediatePositions = new Point3D[this.resolution];
        this.intermediateVelocities = new Vector3D[this.resolution];
        this.intermediateAccelerations = new Vector3D[this.resolution];
        for (i = 0; i < this.resolution; ++i) {
            this.intermediatePositions[i] = new Point3D();
            this.intermediateVelocities[i] = new Vector3D();
            this.intermediateAccelerations[i] = new Vector3D();
        }
        this.segmentedLine3DMeshGenerator = new SegmentedLine3DMeshDataGenerator(this.resolution, this.radialResolution, this.radius);
        this.pointCloud3DMeshGenerator = new PointCloud3DMeshGenerator(this.resolution, this.radialResolution);
        this.graphics3DAddMeshDataInstructions = new Graphics3DAddMeshDataInstruction[this.resolution - 1];
        this.graphics3dObject.setChangeable(true);
        for (i = 0; i < this.resolution - 1; ++i) {
            this.graphics3DAddMeshDataInstructions[i] = this.graphics3dObject.addMeshData(this.segmentedLine3DMeshGenerator.getMeshDataHolders()[i], YoAppearance.AliceBlue());
        }
        this.setupDirtyGraphicListener();
    }

    private void setupDirtyGraphicListener() {
        this.getVariablesDefiningGraphic().forEach(variable -> variable.addListener(v -> this.dirtyGraphic.set(true)));
    }

    private static int[] subArray(double[] source, int start, int length) {
        int[] subArray = new int[length];
        for (int i = 0; i < length; ++i) {
            subArray[i] = (int)source[i + start];
        }
        return subArray;
    }

    private static YoDouble[] toArray(List<YoDouble> list) {
        return list.toArray(new YoDouble[0]);
    }

    private static YoDouble[] subArray(YoVariable[] source, int start, int length) {
        YoDouble[] subArray = new YoDouble[length];
        for (int i = 0; i < length; ++i) {
            subArray[i] = (YoDouble)source[i + start];
        }
        return subArray;
    }

    private static AppearanceDefinition[] createColorPalette(int size) {
        AppearanceDefinition[] colorPalette = new AppearanceDefinition[size];
        for (int i = 0; i < size; ++i) {
            float hue = 240.0f * (1.0f - (float)i / ((float)size - 1.0f)) / 360.0f;
            colorPalette[i] = YoAppearance.Color(Color.getHSBColor(hue, 0.9f, 0.9f));
        }
        return colorPalette;
    }

    public void setColorType(TrajectoryColorType colorType) {
        this.setCurrentColorType(colorType);
    }

    public void showGraphic() {
        this.setGraphicType(TrajectoryGraphicType.SHOW_AS_LINE);
    }

    public void hideGraphic() {
        this.setGraphicType(TrajectoryGraphicType.HIDE);
    }

    public void setGraphicType(TrajectoryGraphicType graphicType) {
        this.setCurrentGraphicType(graphicType);
        if (graphicType != TrajectoryGraphicType.HIDE) {
            this.dirtyGraphic.set(true);
            this.update();
        }
    }

    @Override
    public void update() {
        if (this.yoGraphicJob == YoGraphicJob.READER) {
            this.readerExists.set(true);
        }
        switch (this.yoGraphicJob) {
            case READER: {
                this.computeTrajectoryMesh();
                break;
            }
            case WRITER: {
                if (this.readerExists.getBooleanValue()) break;
                this.computeTrajectoryMesh();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void computeTrajectoryMesh() {
        int i;
        if (!this.dirtyGraphic.get()) {
            return;
        }
        if (this.getCurrentGraphicType() == TrajectoryGraphicType.HIDE) {
            for (Graphics3DAddMeshDataInstruction graphics3DAddMeshDataInstruction : this.graphics3DAddMeshDataInstructions) {
                graphics3DAddMeshDataInstruction.setMesh(null);
            }
            this.dirtyGraphic.set(false);
            return;
        }
        for (Point3D point3D : this.intermediatePositions) {
            point3D.setToZero();
        }
        for (Point3D point3D : this.intermediateVelocities) {
            point3D.setToZero();
        }
        for (Point3D point3D : this.intermediateAccelerations) {
            point3D.setToZero();
        }
        int index = 0;
        double trajectoryTime = 0.0;
        while (index < this.waypointTimes.length && trajectoryTime < this.waypointTimes[index].getDoubleValue()) {
            trajectoryTime = this.waypointTimes[index++].getDoubleValue();
        }
        boolean bl = false;
        double maxVelocity = 0.0;
        double maxAcceleration = 0.0;
        for (i = 0; i < this.resolution; ++i) {
            void var4_16;
            double t = (double)i / ((double)this.resolution - 1.0) * trajectoryTime;
            while (t > this.waypointTimes[var4_16].getDoubleValue()) {
                ++var4_16;
            }
            Polynomial3DVariables activePolynomial3D = this.yoPolynomial3Ds[var4_16];
            activePolynomial3D.compute(t);
            this.intermediatePositions[i].set((Tuple3DReadOnly)activePolynomial3D.getPosition());
            this.intermediateVelocities[i].set((Tuple3DReadOnly)activePolynomial3D.getVelocity());
            this.intermediateAccelerations[i].set((Tuple3DReadOnly)activePolynomial3D.getAcceleration());
            maxVelocity = Math.max(maxVelocity, activePolynomial3D.getVelocity().lengthSquared());
            maxAcceleration = Math.max(maxAcceleration, activePolynomial3D.getAcceleration().lengthSquared());
        }
        maxVelocity = Math.sqrt(maxVelocity);
        maxAcceleration = Math.sqrt(maxAcceleration);
        switch (this.getCurrentColorType()) {
            case BLACK: {
                for (Graphics3DAddMeshDataInstruction meshDataInstruction : this.graphics3DAddMeshDataInstructions) {
                    meshDataInstruction.setAppearance(BLACK_APPEARANCE);
                }
                break;
            }
            case VELOCITY_BASED: {
                for (i = 0; i < this.resolution - 1; ++i) {
                    double velocity = this.intermediateVelocities[i].length();
                    int colorIndex = (int)Math.round(((double)this.colorPalette.length - 1.0) * (velocity / maxVelocity));
                    this.graphics3DAddMeshDataInstructions[i].setAppearance(this.colorPalette[colorIndex]);
                }
                break;
            }
            case ACCELERATION_BASED: {
                for (i = 0; i < this.resolution - 1; ++i) {
                    double acceleration = this.intermediateAccelerations[i].length();
                    int colorIndex = (int)Math.round(((double)this.colorPalette.length - 1.0) * (acceleration / maxAcceleration));
                    this.graphics3DAddMeshDataInstructions[i].setAppearance(this.colorPalette[colorIndex]);
                }
                break;
            }
        }
        switch (this.getCurrentGraphicType()) {
            case SHOW_AS_LINE: {
                if (this.globalScaleProvider != null) {
                    this.segmentedLine3DMeshGenerator.setLineRadius(this.radius * this.globalScaleProvider.getValue());
                }
                this.segmentedLine3DMeshGenerator.compute((Point3DReadOnly[])this.intermediatePositions, (Vector3DReadOnly[])this.intermediateVelocities);
                for (i = 0; i < this.resolution - 1; ++i) {
                    this.graphics3DAddMeshDataInstructions[i].setMesh(this.segmentedLine3DMeshGenerator.getMeshDataHolders()[i]);
                }
                break;
            }
            case SHOW_AS_POINTS: {
                if (this.globalScaleProvider != null) {
                    this.pointCloud3DMeshGenerator.setPointRadius(this.radius * this.globalScaleProvider.getValue());
                }
                this.pointCloud3DMeshGenerator.compute((Point3DReadOnly[])this.intermediatePositions);
                for (i = 0; i < this.resolution - 1; ++i) {
                    this.graphics3DAddMeshDataInstructions[i].setMesh(this.pointCloud3DMeshGenerator.getMeshDataHolders()[i]);
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected state: " + this.getCurrentGraphicType());
            }
        }
        this.dirtyGraphic.set(false);
    }

    private void setCurrentGraphicType(TrajectoryGraphicType graphicType) {
        this.currentGraphicType.set(graphicType.ordinal());
    }

    private TrajectoryGraphicType getCurrentGraphicType() {
        return TrajectoryGraphicType.values[this.currentGraphicType.getOrdinal()];
    }

    private void setCurrentColorType(TrajectoryColorType colorType) {
        this.currentColorType.set(colorType.ordinal());
    }

    private TrajectoryColorType getCurrentColorType() {
        return TrajectoryColorType.values[this.currentColorType.getOrdinal()];
    }

    @Override
    public YoVariable[] getVariables() {
        ArrayList<Object> allVariables = new ArrayList<Object>();
        allVariables.addAll(this.getVariablesDefiningGraphic());
        allVariables.add(this.readerExists);
        return allVariables.toArray(new YoVariable[0]);
    }

    private List<YoVariable> getVariablesDefiningGraphic() {
        ArrayList<YoVariable> graphicVariables = new ArrayList<YoVariable>();
        if (this.poseToWorldFrame != null) {
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoX());
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoY());
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoZ());
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoQx());
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoQy());
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoQz());
            graphicVariables.add((YoVariable)this.poseToWorldFrame.getYoQs());
        }
        for (int i = 0; i < this.numberOfPolynomials; ++i) {
            for (int index = 0; index < 3; ++index) {
                PolynomialVariables yoPolynomial = this.yoPolynomial3Ds[i].getYoPolynomial(index);
                graphicVariables.add((YoVariable)yoPolynomial.getYoNumberOfCoefficients());
                for (YoDouble coefficient : yoPolynomial.getYoCoefficients()) {
                    graphicVariables.add((YoVariable)coefficient);
                }
            }
        }
        for (YoDouble waypointTime : this.waypointTimes) {
            graphicVariables.add((YoVariable)waypointTime);
        }
        graphicVariables.add((YoVariable)this.currentGraphicType);
        graphicVariables.add((YoVariable)this.currentColorType);
        return graphicVariables;
    }

    @Override
    public double[] getConstants() {
        TDoubleArrayList allConstants = new TDoubleArrayList();
        allConstants.add(this.radius);
        allConstants.add((double)this.resolution);
        allConstants.add((double)this.radialResolution);
        allConstants.add(this.hasPoseDefined ? 1.0 : 0.0);
        allConstants.add((double)this.numberOfPolynomials);
        for (int yoPolynomialSize : this.yoPolynomialSizes) {
            allConstants.add((double)yoPolynomialSize);
        }
        return allConstants.toArray();
    }

    @Override
    public AppearanceDefinition getAppearance() {
        return YoAppearance.AliceBlue();
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.graphics3dObject;
    }

    @Override
    protected void computeRotationTranslation(AffineTransform transform) {
        if (this.getCurrentGraphicType() == TrajectoryGraphicType.HIDE) {
            return;
        }
        if (this.poseToWorldFrame != null) {
            this.poseToWorldFrame.get((RigidBodyTransformBasics)this.rigidBodyTransform);
            transform.set((RigidBodyTransformReadOnly)this.rigidBodyTransform);
        } else {
            transform.setIdentity();
        }
        this.update();
    }

    @Override
    protected boolean containsNaN() {
        return this.getCurrentGraphicType() == TrajectoryGraphicType.HIDE;
    }

    @Override
    public YoGraphicPolynomial3D duplicate(YoRegistry newRegistry) {
        return YoGraphicPolynomial3D.createAsRemoteYoGraphic(this.getName(), this.getVariables(), this.getConstants());
    }

    @Override
    public Artifact createArtifact() {
        throw new RuntimeException("Implement Me!");
    }

    public static interface Polynomial3DVariableHolder {
        public PolynomialVariableHolder getYoPolynomialX();

        public PolynomialVariableHolder getYoPolynomialY();

        public PolynomialVariableHolder getYoPolynomialZ();
    }

    static class Polynomial3DVariables
    implements Polynomial3DVariableHolder {
        private final PolynomialVariables xPolynomial;
        private final PolynomialVariables yPolynomial;
        private final PolynomialVariables zPolynomial;
        private final Point3DReadOnly position;
        private final Vector3DReadOnly velocity;
        private final Vector3DReadOnly acceleration;

        private Polynomial3DVariables(Polynomial3DVariableHolder holder) {
            this(holder.getYoPolynomialX(), holder.getYoPolynomialY(), holder.getYoPolynomialZ());
        }

        Polynomial3DVariables(PolynomialVariableHolder xPolynomial, PolynomialVariableHolder yPolynomial, PolynomialVariableHolder zPolynomial) {
            this(new PolynomialVariables(xPolynomial), new PolynomialVariables(yPolynomial), new PolynomialVariables(zPolynomial));
        }

        private Polynomial3DVariables(PolynomialVariables xPolynomial, PolynomialVariables yPolynomial, PolynomialVariables zPolynomial) {
            this.xPolynomial = xPolynomial;
            this.yPolynomial = yPolynomial;
            this.zPolynomial = zPolynomial;
            this.position = EuclidCoreFactories.newLinkedPoint3DReadOnly(xPolynomial::getPosition, yPolynomial::getPosition, zPolynomial::getPosition);
            this.velocity = EuclidCoreFactories.newLinkedVector3DReadOnly(xPolynomial::getVelocity, yPolynomial::getVelocity, zPolynomial::getVelocity);
            this.acceleration = EuclidCoreFactories.newLinkedVector3DReadOnly(xPolynomial::getAcceleration, yPolynomial::getAcceleration, zPolynomial::getAcceleration);
        }

        public void compute(double x) {
            this.xPolynomial.compute(x);
            this.yPolynomial.compute(x);
            this.zPolynomial.compute(x);
        }

        public Point3DReadOnly getPosition() {
            return this.position;
        }

        public Vector3DReadOnly getVelocity() {
            return this.velocity;
        }

        public Vector3DReadOnly getAcceleration() {
            return this.acceleration;
        }

        public PolynomialVariables getYoPolynomial(int index) {
            switch (index) {
                case 0: {
                    return this.getYoPolynomialX();
                }
                case 1: {
                    return this.getYoPolynomialY();
                }
                case 2: {
                    return this.getYoPolynomialZ();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }

        @Override
        public PolynomialVariables getYoPolynomialX() {
            return this.xPolynomial;
        }

        @Override
        public PolynomialVariables getYoPolynomialY() {
            return this.yPolynomial;
        }

        @Override
        public PolynomialVariables getYoPolynomialZ() {
            return this.zPolynomial;
        }
    }

    static class PolynomialVariables
    implements PolynomialVariableHolder {
        private final YoDouble[] coefficients;
        private final YoInteger numberOfCoefficients;
        private final double[] xPowers;
        private double pos;
        private double vel;
        private double acc;

        private PolynomialVariables(PolynomialVariableHolder holder) {
            this(holder.getYoCoefficients(), holder.getYoNumberOfCoefficients());
        }

        PolynomialVariables(String name, int maximumNumberOfCoefficients, YoRegistry registry) {
            this.coefficients = new YoDouble[maximumNumberOfCoefficients];
            this.numberOfCoefficients = new YoInteger(name + "_nCoeffs", registry);
            for (int i = 0; i < maximumNumberOfCoefficients; ++i) {
                this.coefficients[i] = new YoDouble(name + "_a" + i, registry);
            }
            this.xPowers = new double[this.coefficients.length];
        }

        private PolynomialVariables(YoDouble[] coefficients, YoInteger numberOfCoefficients) {
            this.coefficients = coefficients;
            this.numberOfCoefficients = numberOfCoefficients;
            this.xPowers = new double[coefficients.length];
        }

        public void compute(double x) {
            int i;
            this.setXPowers(this.xPowers, x);
            this.acc = 0.0;
            this.vel = 0.0;
            this.pos = 0.0;
            for (i = 0; i < this.numberOfCoefficients.getIntegerValue(); ++i) {
                this.pos += this.coefficients[i].getDoubleValue() * this.xPowers[i];
            }
            for (i = 1; i < this.numberOfCoefficients.getIntegerValue(); ++i) {
                this.vel += (double)i * this.coefficients[i].getDoubleValue() * this.xPowers[i - 1];
            }
            for (i = 2; i < this.numberOfCoefficients.getIntegerValue(); ++i) {
                this.acc += (double)((i - 1) * i) * this.coefficients[i].getDoubleValue() * this.xPowers[i - 2];
            }
        }

        public void setXPowers(double[] xPowers, double x) {
            xPowers[0] = 1.0;
            for (int i = 1; i < xPowers.length; ++i) {
                xPowers[i] = xPowers[i - 1] * x;
            }
        }

        private int getMaximumNumberOfCoefficients() {
            return this.coefficients.length;
        }

        public double getPosition() {
            return this.pos;
        }

        public double getVelocity() {
            return this.vel;
        }

        public double getAcceleration() {
            return this.acc;
        }

        @Override
        public YoDouble[] getYoCoefficients() {
            return this.coefficients;
        }

        @Override
        public YoInteger getYoNumberOfCoefficients() {
            return this.numberOfCoefficients;
        }
    }

    public static enum TrajectoryGraphicType {
        HIDE,
        SHOW_AS_LINE,
        SHOW_AS_POINTS;

        public static TrajectoryGraphicType[] values;

        static {
            values = TrajectoryGraphicType.values();
        }
    }

    public static enum TrajectoryColorType {
        BLACK,
        VELOCITY_BASED,
        ACCELERATION_BASED;

        public static TrajectoryColorType[] values;

        static {
            values = TrajectoryColorType.values();
        }
    }

    public static interface PolynomialVariableHolder {
        public YoDouble[] getYoCoefficients();

        public YoInteger getYoNumberOfCoefficients();
    }
}

