/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.instructions;

import java.util.List;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddExtrusionInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddHeightMapInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddModelFileInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DPrimitiveInstruction;
import us.ihmc.graphicsDescription.instructions.PrimitiveGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DIdentityInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DRotateInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DScaleInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DTranslateInstruction;

public abstract class Graphics3DInstructionExecutor {
    protected void setUpGraphicsFromDefinition(List<Graphics3DPrimitiveInstruction> instructions) {
        for (Graphics3DPrimitiveInstruction instruction : instructions) {
            if (instruction instanceof Graphics3DAddModelFileInstruction) {
                Graphics3DAddModelFileInstruction graphics3DAddModelFile = (Graphics3DAddModelFileInstruction)instruction;
                this.doAddModelFileInstruction(graphics3DAddModelFile);
                continue;
            }
            if (instruction instanceof Graphics3DAddMeshDataInstruction) {
                Graphics3DAddMeshDataInstruction meshDataInstruction = (Graphics3DAddMeshDataInstruction)instruction;
                this.doAddMeshDataInstruction(meshDataInstruction);
                continue;
            }
            if (instruction instanceof PrimitiveGraphics3DInstruction) {
                PrimitiveGraphics3DInstruction primitiveInstruction = (PrimitiveGraphics3DInstruction)instruction;
                this.doAddPrimitiveInstruction(primitiveInstruction);
                continue;
            }
            if (instruction instanceof Graphics3DIdentityInstruction) {
                this.doIdentityInstruction();
                continue;
            }
            if (instruction instanceof Graphics3DRotateInstruction) {
                Graphics3DRotateInstruction graphics3DRotateMatrix = (Graphics3DRotateInstruction)instruction;
                this.doRotateInstruction(graphics3DRotateMatrix);
                continue;
            }
            if (instruction instanceof Graphics3DScaleInstruction) {
                Graphics3DScaleInstruction graphics3DScale = (Graphics3DScaleInstruction)instruction;
                this.doScaleInstruction(graphics3DScale);
                continue;
            }
            if (instruction instanceof Graphics3DTranslateInstruction) {
                Graphics3DTranslateInstruction graphics3DTranslate = (Graphics3DTranslateInstruction)instruction;
                this.doTranslateInstruction(graphics3DTranslate);
                continue;
            }
            if (instruction instanceof Graphics3DAddExtrusionInstruction) {
                Graphics3DAddExtrusionInstruction graphics3DAddExtrusion = (Graphics3DAddExtrusionInstruction)instruction;
                this.doAddExtrusionInstruction(graphics3DAddExtrusion);
                continue;
            }
            if (instruction instanceof Graphics3DAddHeightMapInstruction) {
                Graphics3DAddHeightMapInstruction graphics3DAddHeightMap = (Graphics3DAddHeightMapInstruction)instruction;
                this.doAddHeightMapInstruction(graphics3DAddHeightMap);
                continue;
            }
            System.err.println("Unknown graphics3DDefinition: " + instruction.getClass().getSimpleName());
        }
    }

    protected abstract void doAddPrimitiveInstruction(PrimitiveGraphics3DInstruction var1);

    protected abstract void doAddMeshDataInstruction(Graphics3DAddMeshDataInstruction var1);

    protected abstract void doAddHeightMapInstruction(Graphics3DAddHeightMapInstruction var1);

    protected abstract void doAddExtrusionInstruction(Graphics3DAddExtrusionInstruction var1);

    protected abstract void doAddModelFileInstruction(Graphics3DAddModelFileInstruction var1);

    protected abstract void doIdentityInstruction();

    protected abstract void doRotateInstruction(Graphics3DRotateInstruction var1);

    protected abstract void doScaleInstruction(Graphics3DScaleInstruction var1);

    protected abstract void doTranslateInstruction(Graphics3DTranslateInstruction var1);
}

