/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics.plotting;

import java.awt.Color;
import java.util.ArrayList;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public abstract class YoArtifact
extends Artifact
implements RemoteYoGraphic {
    private final YoVariable[] variableArray;
    private final double[] constants;
    private final AppearanceDefinition appearance;
    private final ArrayList<double[]> historicalData = new ArrayList();

    public YoArtifact(String name, double[] constants, Color color, YoVariable ... variableArray) {
        super(name);
        this.variableArray = variableArray;
        this.constants = constants;
        this.appearance = new YoAppearanceRGBColor(color, 0.0);
        this.color = color;
    }

    public abstract void drawHistoryEntry(Graphics2DAdapter var1, double[] var2);

    @Override
    public YoVariable[] getVariables() {
        return this.variableArray;
    }

    @Override
    public final double[] getConstants() {
        return this.constants;
    }

    @Override
    public final AppearanceDefinition getAppearance() {
        return this.appearance;
    }

    @Override
    public final String getName() {
        return this.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void takeHistorySnapshot() {
        if (this.getRecordHistory()) {
            ArrayList<double[]> arrayList = this.historicalData;
            synchronized (arrayList) {
                double[] values = new double[this.variableArray.length];
                for (int i = 0; i < this.variableArray.length; ++i) {
                    values[i] = this.variableArray[i].getValueAsDouble();
                }
                this.historicalData.add(values);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void drawHistory(Graphics2DAdapter graphics) {
        ArrayList<double[]> arrayList = this.historicalData;
        synchronized (arrayList) {
            for (double[] data : this.historicalData) {
                this.drawHistoryEntry(graphics, data);
            }
        }
    }

    @Override
    public abstract YoArtifact duplicate(YoRegistry var1);
}

