/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.input.SelectedListener;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.tools.inputDevices.keyboard.ModifierKeyInterface;

public class Graphics3DNode {
    private static final Graphics3DNodeType DEFAULT_NODE_TYPE = Graphics3DNodeType.JOINT;
    private final String name;
    private final Graphics3DNodeType nodeType;
    private final AffineTransform transform = new AffineTransform();
    private Graphics3DObject graphicsObject;
    private boolean hasGraphicsObjectChanged = false;
    private final ArrayList<Graphics3DNode> childeren = new ArrayList();
    private final ArrayList<SelectedListener> selectedListeners = new ArrayList();

    public Graphics3DNode(String name, Graphics3DNodeType nodeType, Graphics3DObject graphicsObject) {
        this.name = name;
        this.nodeType = nodeType;
        if (graphicsObject != null) {
            this.setGraphicsObject(graphicsObject);
        }
    }

    public Graphics3DNode(String name, Graphics3DObject graphicsObject) {
        this(name, DEFAULT_NODE_TYPE, graphicsObject);
    }

    public Graphics3DNode(String name, Graphics3DNodeType nodeType) {
        this(name, nodeType, null);
    }

    public Graphics3DNode(String name) {
        this(name, DEFAULT_NODE_TYPE, null);
    }

    public synchronized AffineTransform getTransform() {
        return this.transform;
    }

    public synchronized void setTransform(RigidBodyTransformReadOnly transform) {
        this.transform.set(transform);
    }

    public synchronized void setTransform(AffineTransform transform) {
        this.transform.set(transform);
    }

    public void translate(double distance, Axis3D axis) {
        if (axis == Axis3D.X) {
            this.translate(distance, 0.0, 0.0);
        } else if (axis == Axis3D.Y) {
            this.translate(0.0, distance, 0.0);
        } else if (axis == Axis3D.Z) {
            this.translate(0.0, 0.0, distance);
        }
    }

    public void translate(double x, double y, double z) {
        this.transform.appendTranslation(x, y, z);
    }

    public void translateTo(double x, double y, double z) {
        this.translateTo((Tuple3DReadOnly)new Vector3D(x, y, z));
    }

    public void translateTo(Tuple3DReadOnly translation) {
        this.transform.setIdentity();
        this.transform.setTranslation(translation);
    }

    public void rotate(double angle, Axis3D axis) {
        switch (axis) {
            case X: {
                this.transform.appendRollRotation(angle);
                break;
            }
            case Y: {
                this.transform.appendPitchRotation(angle);
                break;
            }
            case Z: {
                this.transform.appendYawRotation(angle);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled value of Axis: " + axis);
            }
        }
    }

    public Vector3D getTranslation() {
        return new Vector3D((Tuple3DReadOnly)this.getTransform().getTranslation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(Graphics3DNode child) {
        ArrayList<Graphics3DNode> arrayList = this.childeren;
        synchronized (arrayList) {
            this.childeren.add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Graphics3DNode> getChildrenNodes() {
        ArrayList<Graphics3DNode> arrayList = this.childeren;
        synchronized (arrayList) {
            return Collections.unmodifiableList(this.childeren);
        }
    }

    public Graphics3DObject getGraphics3DObject() {
        return this.graphicsObject;
    }

    public synchronized Graphics3DObject getGraphicsObjectAndResetHasGraphicsObjectChanged() {
        Graphics3DObject ret = this.graphicsObject;
        this.setHasGraphicsObjectChanged(false);
        return ret;
    }

    public synchronized void setHasGraphicsObjectChanged(boolean hasGraphicsObjectChanged) {
        this.hasGraphicsObjectChanged = hasGraphicsObjectChanged;
    }

    public boolean getHasGraphicsObjectChanged() {
        return this.hasGraphicsObjectChanged;
    }

    public void setGraphicsObject(Graphics3DObject graphicsObject) {
        this.graphicsObject = graphicsObject;
        this.setHasGraphicsObjectChanged(true);
    }

    public String getName() {
        return this.name;
    }

    public Graphics3DNodeType getNodeType() {
        return this.nodeType;
    }

    public void notifySelectedListeners(ModifierKeyInterface modifierKeys, Point3DReadOnly location, Point3DReadOnly cameraPosition, QuaternionReadOnly cameraRotation) {
        for (SelectedListener selectedListener : this.selectedListeners) {
            selectedListener.selected(this, modifierKeys, location, cameraPosition, cameraRotation);
        }
        this.graphicsObject.notifySelectedListeners(this, modifierKeys, location, cameraPosition, cameraRotation);
    }

    public void addSelectedListener(SelectedListener selectedListener) {
        this.selectedListeners.add(selectedListener);
    }
}

