/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.GraphicsUpdatable;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoGraphicPolygon3D
extends YoGraphic
implements RemoteYoGraphic,
GraphicsUpdatable {
    private static final MeshDataHolder EMPTY_MESH = MeshDataGenerator.Tetrahedron(0.0);
    private final YoInteger numberOfPoints;
    private final YoFramePoint3D[] ccwOrderedYoFramePoints;
    private final List<Point3D> ccwOrderedPoints;
    private final double height;
    private AppearanceDefinition appearance;
    private final Graphics3DObject graphics3dObject;
    private final Graphics3DAddMeshDataInstruction instruction;

    public YoGraphicPolygon3D(String name, int maxNumberOfPolygonVertices, double height, AppearanceDefinition appearance, YoRegistry registry) {
        super(name);
        this.ccwOrderedYoFramePoints = new YoFramePoint3D[maxNumberOfPolygonVertices];
        this.ccwOrderedPoints = new ArrayList<Point3D>(maxNumberOfPolygonVertices);
        for (int i = 0; i < maxNumberOfPolygonVertices; ++i) {
            this.ccwOrderedYoFramePoints[i] = new YoFramePoint3D(name + "Point" + i, ReferenceFrame.getWorldFrame(), registry);
            this.ccwOrderedYoFramePoints[i].setToNaN();
            this.ccwOrderedPoints.add(new Point3D());
        }
        this.height = height;
        this.appearance = appearance;
        this.numberOfPoints = new YoInteger(name + "NumberOfPoints", registry);
        this.graphics3dObject = new Graphics3DObject();
        this.graphics3dObject.setChangeable(true);
        this.instruction = new Graphics3DAddMeshDataInstruction(EMPTY_MESH, appearance);
        this.graphics3dObject.addInstruction(this.instruction);
    }

    public YoGraphicPolygon3D(String name, YoInteger numberOfPoints, YoFramePoint3D[] ccwOrderedYoFramePoints, double height, AppearanceDefinition appearance) {
        super(name);
        this.numberOfPoints = numberOfPoints;
        this.ccwOrderedYoFramePoints = ccwOrderedYoFramePoints;
        this.ccwOrderedPoints = new ArrayList<Point3D>(ccwOrderedYoFramePoints.length);
        for (int i = 0; i < ccwOrderedYoFramePoints.length; ++i) {
            this.ccwOrderedPoints.add(new Point3D());
        }
        this.height = height;
        this.appearance = appearance;
        this.graphics3dObject = new Graphics3DObject();
        this.graphics3dObject.setChangeable(true);
        this.instruction = new Graphics3DAddMeshDataInstruction(EMPTY_MESH, appearance);
        this.graphics3dObject.addInstruction(this.instruction);
    }

    @Override
    public YoVariable[] getVariables() {
        YoVariable[] yoVariableList = new YoVariable[3 * this.ccwOrderedYoFramePoints.length + 1];
        for (int i = 0; i < this.ccwOrderedYoFramePoints.length; ++i) {
            yoVariableList[i * 3] = this.ccwOrderedYoFramePoints[i].getYoX();
            yoVariableList[i * 3 + 1] = this.ccwOrderedYoFramePoints[i].getYoY();
            yoVariableList[i * 3 + 2] = this.ccwOrderedYoFramePoints[i].getYoZ();
        }
        yoVariableList[this.ccwOrderedYoFramePoints.length * 3] = this.numberOfPoints;
        return yoVariableList;
    }

    public void setAppearance(AppearanceDefinition appearance) {
        this.appearance = appearance;
    }

    public void set(FramePoint3DReadOnly[] points) {
        for (int i = 0; i < points.length; ++i) {
            points[i].checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        }
        this.set((Point3DReadOnly[])points);
    }

    public void set(Point3DReadOnly[] points) {
        int i;
        if (points.length > this.ccwOrderedYoFramePoints.length) {
            throw new RuntimeException("Cannot plot more vertices than the maximum number");
        }
        this.numberOfPoints.set(points.length);
        for (i = 0; i < this.numberOfPoints.getValue(); ++i) {
            this.ccwOrderedYoFramePoints[i].set((Tuple3DReadOnly)points[i]);
        }
        for (i = this.numberOfPoints.getValue(); i < this.ccwOrderedYoFramePoints.length; ++i) {
            this.ccwOrderedYoFramePoints[i].setToNaN();
        }
    }

    public void set(List<? extends Point3DReadOnly> points) {
        int i;
        if (points.size() > this.ccwOrderedYoFramePoints.length) {
            throw new RuntimeException("Cannot plot more vertices than the maximum number");
        }
        this.numberOfPoints.set(points.size());
        for (i = 0; i < this.numberOfPoints.getValue(); ++i) {
            this.ccwOrderedYoFramePoints[i].set((Tuple3DReadOnly)points.get(i));
        }
        for (i = this.numberOfPoints.getValue(); i < this.ccwOrderedYoFramePoints.length; ++i) {
            this.ccwOrderedYoFramePoints[i].setToNaN();
        }
    }

    @Override
    protected void computeRotationTranslation(AffineTransform transform3d) {
    }

    @Override
    public void update() {
        if (this.numberOfPoints.getIntegerValue() < 3) {
            this.instruction.setMesh(EMPTY_MESH);
            return;
        }
        for (int i = 0; i < this.numberOfPoints.getIntegerValue(); ++i) {
            this.ccwOrderedPoints.get(i).set((Tuple3DReadOnly)this.ccwOrderedYoFramePoints[i]);
        }
        this.instruction.setMesh(MeshDataGenerator.Polygon(this.ccwOrderedPoints, this.numberOfPoints.getIntegerValue()));
        this.instruction.setAppearance(this.appearance);
    }

    public void setToNaN() {
        for (int i = 0; i < this.ccwOrderedYoFramePoints.length; ++i) {
            this.ccwOrderedYoFramePoints[i].setToNaN();
        }
    }

    @Override
    public double[] getConstants() {
        return new double[]{this.height};
    }

    @Override
    public AppearanceDefinition getAppearance() {
        return this.appearance;
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.graphics3dObject;
    }

    @Override
    protected boolean containsNaN() {
        for (int i = 0; i < this.numberOfPoints.getIntegerValue(); ++i) {
            if (!this.ccwOrderedYoFramePoints[i].containsNaN()) continue;
            return true;
        }
        return false;
    }

    @Override
    public YoGraphicPolygon3D duplicate(YoRegistry newRegistry) {
        return new YoGraphicPolygon3D(this.getName(), this.numberOfPoints, this.ccwOrderedYoFramePoints, this.height, this.appearance);
    }

    @Override
    public Artifact createArtifact() {
        throw new RuntimeException("Implement Me!");
    }
}

