/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoGraphicEllipsoid
extends YoGraphicCoordinateSystem {
    private Vector3D radii = new Vector3D();
    private final AppearanceDefinition appearance;

    public YoGraphicEllipsoid(String name, YoFramePoseUsingYawPitchRoll pose, AppearanceDefinition appearance, Vector3DReadOnly radii) {
        super(name, pose, 1.0);
        this.appearance = appearance;
        this.radii.set((Tuple3DReadOnly)radii);
    }

    public YoGraphicEllipsoid(String name, YoFramePoint3D framePoint, YoFrameYawPitchRoll orientation, AppearanceDefinition appearance, Vector3DReadOnly radii) {
        super(name, framePoint, orientation, 1.0);
        this.appearance = appearance;
        this.radii.set((Tuple3DReadOnly)radii);
    }

    public YoGraphicEllipsoid(String namePrefix, String nameSuffix, YoRegistry registry, AppearanceDefinition appearance, Vector3DReadOnly radii) {
        super(namePrefix, nameSuffix, registry, true, 1.0, appearance);
        this.appearance = appearance;
        this.radii.set((Tuple3DReadOnly)radii);
    }

    public void setRadii(Vector3D radii) {
        this.radii.set(radii);
    }

    @Override
    protected void computeRotationTranslation(AffineTransform transform3D) {
        transform3D.setIdentity();
        transform3D.setLinearTransform((Orientation3DReadOnly)this.yawPitchRoll);
        transform3D.appendScale(this.scale * this.radii.getX(), this.scale * this.radii.getY(), this.scale * this.radii.getZ());
        transform3D.setTranslation((Tuple3DReadOnly)this.position);
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addEllipsoid(1.0, 1.0, 1.0, this.appearance);
        return linkGraphics;
    }

    @Override
    public YoGraphicEllipsoid duplicate(YoRegistry newRegistry) {
        return new YoGraphicEllipsoid(this.getName(), this.position.duplicate(newRegistry), this.yawPitchRoll.duplicate(newRegistry), this.appearance, (Vector3DReadOnly)this.radii);
    }
}

