/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.plotting.artifact;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.Plotter2DAdapter;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;

public class ShapeArtifact
extends Artifact {
    private static final double LEGEND_RADIUS = 20.0;
    private final Point2D pose = new Point2D();
    private double height;
    private double width;
    private final Point2D tempCenter = new Point2D();
    private final Vector2D tempRadii = new Vector2D();

    public ShapeArtifact(String id, String type, double height, double width, Point2DReadOnly pose) {
        super(id);
        this.setType(type);
        this.setLevel(1);
        this.pose.set((Tuple2DReadOnly)pose);
        this.height = height;
        this.width = width;
    }

    public void setPose(Point2DReadOnly pose) {
        this.pose.set((Tuple2DReadOnly)pose);
    }

    public Point2D getPose() {
        return this.pose;
    }

    @Override
    public void draw(Graphics2DAdapter graphics) {
        if (this.pose == null) {
            System.out.println("problem...shape with null pose:" + this.getID());
            return;
        }
        graphics.setColor(this.color);
        this.tempCenter.set(this.pose.getX(), this.pose.getY());
        this.tempRadii.set(this.width / 2.0, this.height / 2.0);
        if (this.getType().equals("fillcircle")) {
            graphics.drawOvalFilled((Point2DReadOnly)this.tempCenter, (Vector2DReadOnly)this.tempRadii);
        } else if (this.getType().equals("circle")) {
            graphics.drawOval((Point2DReadOnly)this.tempCenter, (Vector2DReadOnly)this.tempRadii);
        } else if (this.getType().equals("fillrectangle")) {
            graphics.drawSquareFilled((Point2DReadOnly)this.tempCenter, (Vector2DReadOnly)this.tempRadii);
        } else if (this.getType().equals("rectangle")) {
            graphics.drawSquare((Point2DReadOnly)this.tempCenter, (Vector2DReadOnly)this.tempRadii);
        }
    }

    @Override
    public void drawLegend(Plotter2DAdapter graphics, Point2D origin) {
        graphics.setColor(this.color);
        this.tempCenter.set(origin);
        this.tempRadii.set(20.0, 20.0);
        if (this.getType().equals("fillcircle")) {
            graphics.drawOvalFilled(graphics.getScreenFrame(), (Point2DReadOnly)this.tempCenter, (Vector2DReadOnly)this.tempRadii);
        } else if (this.getType().equals("circle")) {
            graphics.drawOval(graphics.getScreenFrame(), (Point2DReadOnly)this.tempCenter, (Vector2DReadOnly)this.tempRadii);
        } else if (this.getType().equals("fillrectangle")) {
            graphics.drawSquareFilled(graphics.getScreenFrame(), (Point2DReadOnly)this.tempCenter, (Vector2DReadOnly)this.tempRadii);
        } else if (this.getType().equals("rectangle")) {
            graphics.drawRectangle(graphics.getScreenFrame(), (Point2DReadOnly)this.tempCenter, (Vector2DReadOnly)this.tempRadii);
        }
    }

    public void save(PrintWriter printWriter) {
        printWriter.println(this.pose.getX() + " " + this.pose.getY() + " " + this.width + " " + this.height + " " + this.getType() + " " + this.id);
    }

    public static ShapeArtifact load(BufferedReader bufferedReader) {
        ShapeArtifact shapeArtifact = null;
        try {
            String line = bufferedReader.readLine();
            if (line == null) {
                return null;
            }
            StringTokenizer s = new StringTokenizer(line, " ");
            double x = Double.parseDouble(s.nextToken());
            double y = Double.parseDouble(s.nextToken());
            Point2D pose = new Point2D(x, y);
            double width = Double.parseDouble(s.nextToken());
            double height = Double.parseDouble(s.nextToken());
            String type = s.nextToken();
            String id = s.nextToken();
            shapeArtifact = new ShapeArtifact(id, type, height, width, (Point2DReadOnly)pose);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shapeArtifact;
    }

    public ShapeArtifact getCopy() {
        ShapeArtifact shapeCopy = new ShapeArtifact(this.getID(), this.getType(), this.height, this.width, (Point2DReadOnly)this.getPose());
        shapeCopy.setColor(this.getColor());
        return shapeCopy;
    }

    @Override
    public void drawHistory(Graphics2DAdapter graphics) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void takeHistorySnapshot() {
        throw new RuntimeException("Not implemented!");
    }
}

