/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.GraphicsUpdatable;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.color.MutableColor;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactLineSegment2d;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLineSegment2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoGraphicVector
extends YoGraphic
implements RemoteYoGraphic,
GraphicsUpdatable {
    private double lineRadiusWhenOneMeterLong = 0.015;
    private double minRadiusScaleFactor = 0.3;
    private double maxRadiusScaleFactor = 3.0;
    private final YoFramePoint3D base;
    private final YoFrameVector3D vector;
    protected final double scaleFactor;
    private boolean drawArrowhead;
    private final AppearanceDefinition appearance;
    private Vector3D translationVector = new Vector3D();
    private Vector3D z_rot = new Vector3D();
    private Vector3D y_rot = new Vector3D();
    private Vector3D x_rot = new Vector3D();
    private RotationMatrix rotMatrix = new RotationMatrix();

    public YoGraphicVector(String name, YoFramePoint3D startPoint, YoFrameVector3D frameVector, AppearanceDefinition appearance) {
        this(name, startPoint, frameVector, 1.0, appearance);
    }

    public YoGraphicVector(String name, YoFramePoint3D startPoint, YoFrameVector3D frameVector, double scale) {
        this(name, startPoint, frameVector, scale, YoAppearance.Black(), true);
    }

    public YoGraphicVector(String name, YoFramePoint3D startPoint, YoFrameVector3D frameVector, double scale, AppearanceDefinition appearance) {
        this(name, startPoint, frameVector, scale, appearance, true);
    }

    public YoGraphicVector(String name, YoFramePoint3D startPoint, YoFrameVector3D directionVector, double scale, AppearanceDefinition appearance, boolean drawArrowhead, double lineRadiusWhenOneMeterLong) {
        this(name, startPoint, directionVector, scale, appearance, drawArrowhead);
        this.setLineRadiusWhenOneMeterLong(lineRadiusWhenOneMeterLong);
    }

    public YoGraphicVector(String name, YoFramePoint3D startPoint, YoFrameVector3D frameVector, double scale, AppearanceDefinition appearance, boolean drawArrowhead) {
        this(name, startPoint.getYoX(), startPoint.getYoY(), startPoint.getYoZ(), frameVector.getYoX(), frameVector.getYoY(), frameVector.getYoZ(), scale, appearance, drawArrowhead);
        if (!startPoint.getReferenceFrame().isWorldFrame() || !frameVector.getReferenceFrame().isWorldFrame()) {
            System.err.println("Warning: Should be in a World Frame to create a YoGraphicVector. startPoint = " + startPoint + ", frameVector = " + frameVector);
        }
    }

    public YoGraphicVector(String name, YoDouble baseX, YoDouble baseY, YoDouble baseZ, YoDouble x, YoDouble y, YoDouble z, double scaleFactor, AppearanceDefinition appearance) {
        this(name, baseX, baseY, baseZ, x, y, z, scaleFactor, appearance, true);
    }

    public YoGraphicVector(String name, YoDouble baseX, YoDouble baseY, YoDouble baseZ, YoDouble x, YoDouble y, YoDouble z, double scaleFactor, AppearanceDefinition appearance, boolean drawArrowhead) {
        super(name);
        this.base = new YoFramePoint3D(baseX, baseY, baseZ, ReferenceFrame.getWorldFrame());
        this.vector = new YoFrameVector3D(x, y, z, ReferenceFrame.getWorldFrame());
        this.drawArrowhead = drawArrowhead;
        this.scaleFactor = scaleFactor;
        this.appearance = appearance;
    }

    public void setLineRadiusWhenOneMeterLong(double lineRadiusWhenOneMeterLong) {
        this.lineRadiusWhenOneMeterLong = lineRadiusWhenOneMeterLong;
    }

    public void setMinAndMaxRadiusScaleFactors(double minRadiusScaleFactor, double maxRadiusScaleFactor) {
        this.minRadiusScaleFactor = minRadiusScaleFactor;
        this.maxRadiusScaleFactor = maxRadiusScaleFactor;
    }

    public void setDrawArrowhead(boolean drawArrowhead) {
        this.drawArrowhead = drawArrowhead;
    }

    public void getBasePosition(Point3DBasics point3D) {
        point3D.set((Tuple3DReadOnly)this.base);
    }

    public void getBasePosition(FramePoint3DBasics framePoint3D) {
        framePoint3D.setIncludingFrame((FrameTuple3DReadOnly)this.base);
    }

    public void getVector(Vector3DBasics vector3D) {
        vector3D.set((Tuple3DReadOnly)this.vector);
    }

    public void getVector(FrameVector3DBasics frameVector3D) {
        frameVector3D.setIncludingFrame((FrameTuple3DReadOnly)this.vector);
    }

    public double getScale() {
        return this.scaleFactor;
    }

    @Override
    protected void computeRotationTranslation(AffineTransform transform3D) {
        double xyScaleFactor;
        transform3D.setIdentity();
        this.z_rot.set((Tuple3DReadOnly)this.vector);
        double length = this.z_rot.length();
        if (length < 1.0E-7) {
            this.z_rot.set(0.0, 0.0, 1.0);
        } else {
            this.z_rot.normalize();
        }
        if (Math.abs(this.z_rot.getX()) <= 0.99) {
            this.x_rot.set(1.0, 0.0, 0.0);
        } else {
            this.x_rot.set(0.0, 1.0, 0.0);
        }
        this.y_rot.cross((Tuple3DReadOnly)this.z_rot, (Tuple3DReadOnly)this.x_rot);
        this.y_rot.normalize();
        this.x_rot.cross((Tuple3DReadOnly)this.y_rot, (Tuple3DReadOnly)this.z_rot);
        this.x_rot.normalize();
        this.rotMatrix.setColumns((Tuple3DReadOnly)this.x_rot, (Tuple3DReadOnly)this.y_rot, (Tuple3DReadOnly)this.z_rot);
        this.translationVector.set((Tuple3DReadOnly)this.base);
        double globalScale = 1.0;
        if (this.globalScaleProvider != null) {
            globalScale = this.globalScaleProvider.getValue();
        }
        if ((xyScaleFactor = length * this.scaleFactor * globalScale) < this.minRadiusScaleFactor) {
            xyScaleFactor = this.minRadiusScaleFactor;
        }
        if (xyScaleFactor > this.maxRadiusScaleFactor) {
            xyScaleFactor = this.maxRadiusScaleFactor;
        }
        transform3D.setTranslation((Tuple3DReadOnly)this.translationVector);
        transform3D.setLinearTransform((RotationMatrixReadOnly)this.rotMatrix);
        transform3D.appendScale(xyScaleFactor, xyScaleFactor, length * this.scaleFactor * globalScale);
    }

    public void set(YoDouble baseX, YoDouble baseY, YoDouble baseZ, YoDouble x, YoDouble y, YoDouble z) {
        this.base.set(baseX.getValue(), baseY.getValue(), baseZ.getValue());
        this.vector.set(x.getValue(), y.getValue(), z.getValue());
    }

    public void set(FramePoint3DReadOnly base, FrameVector3DReadOnly vector) {
        this.base.set((FrameTuple3DReadOnly)base);
        this.vector.set((FrameTuple3DReadOnly)vector);
    }

    public void set(double baseX, double baseY, double baseZ, double x, double y, double z) {
        this.base.set(baseX, baseY, baseZ);
        this.vector.set(x, y, z);
    }

    @Override
    public Artifact createArtifact() {
        MutableColor color3f = this.appearance.getColor();
        YoDouble endPointX = new YoDouble(this.getName() + "ArtifactEndPointX", this.base.getYoX().getRegistry());
        YoDouble endPointY = new YoDouble(this.getName() + "ArtifactEndPointY", this.base.getYoY().getRegistry());
        this.base.getYoX().addListener(v -> endPointX.set(this.base.getX() + this.vector.getX()));
        this.base.getYoY().addListener(v -> endPointY.set(this.base.getY() + this.vector.getY()));
        this.vector.getYoX().addListener(v -> endPointX.set(this.base.getX() + this.vector.getX()));
        this.vector.getYoY().addListener(v -> endPointY.set(this.base.getY() + this.vector.getY()));
        return new YoArtifactLineSegment2d(this.getName(), new YoFrameLineSegment2D(this.base.getYoX(), this.base.getYoY(), endPointX, endPointY, ReferenceFrame.getWorldFrame()), color3f.get());
    }

    @Override
    public boolean containsNaN() {
        return this.base.containsNaN() || this.vector.containsNaN();
    }

    public void hide() {
        this.base.setToNaN();
        this.vector.setToNaN();
    }

    public YoDouble[] getVariables() {
        return new YoDouble[]{this.base.getYoX(), this.base.getYoY(), this.base.getYoZ(), this.vector.getYoX(), this.vector.getYoY(), this.vector.getYoZ()};
    }

    @Override
    public double[] getConstants() {
        return new double[]{this.scaleFactor};
    }

    public boolean getDrawArrowhead() {
        return this.drawArrowhead;
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        Graphics3DObject linkGraphics = new Graphics3DObject();
        if (this.drawArrowhead) {
            linkGraphics.addCylinder(0.9, this.lineRadiusWhenOneMeterLong, this.appearance);
            linkGraphics.translate(0.0, 0.0, 0.9);
            linkGraphics.addCone(0.1, 2.5 * this.lineRadiusWhenOneMeterLong, this.appearance);
        } else {
            linkGraphics.addCylinder(1.0, this.lineRadiusWhenOneMeterLong, this.appearance);
        }
        return linkGraphics;
    }

    @Override
    public AppearanceDefinition getAppearance() {
        return this.appearance;
    }

    @Override
    public YoGraphicVector duplicate(YoRegistry newRegistry) {
        return new YoGraphicVector(this.getName(), this.base.duplicate(newRegistry), this.vector.duplicate(newRegistry), this.scaleFactor, this.appearance, this.drawArrowhead, this.lineRadiusWhenOneMeterLong);
    }
}

