/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.GraphicsUpdatable;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicAbstractShape;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoGraphicPolygon
extends YoGraphicAbstractShape
implements RemoteYoGraphic,
GraphicsUpdatable {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double DEFAULT_HEIGHT = 0.01;
    private final double height;
    private YoFrameConvexPolygon2D yoFrameConvexPolygon2d;
    private final Graphics3DObject graphics3dObject;
    private final Graphics3DAddMeshDataInstruction instruction;
    private final AppearanceDefinition appearance;
    private final List<Point2DReadOnly> verticesToDisplay;

    public YoGraphicPolygon(String name, YoFramePose3D framePose, int maxNumberOfVertices, YoRegistry registry, double scale, AppearanceDefinition appearance) {
        this(name, new YoFrameConvexPolygon2D(name + "ConvexPolygon2d", worldFrame, maxNumberOfVertices, registry), framePose, scale, appearance);
    }

    public YoGraphicPolygon(String name, YoFrameConvexPolygon2D yoFrameConvexPolygon2d, YoFramePose3D framePose, double scale, AppearanceDefinition appearance) {
        this(name, yoFrameConvexPolygon2d, framePose.getPosition(), framePose.getOrientation(), scale, appearance);
    }

    public YoGraphicPolygon(String name, YoFrameConvexPolygon2D yoFrameConvexPolygon2d, YoFramePoint3D framePoint, YoFrameQuaternion orientation, double scale, AppearanceDefinition appearance) {
        this(name, yoFrameConvexPolygon2d, framePoint, orientation, scale, 0.01, appearance);
    }

    public YoGraphicPolygon(String name, YoFrameConvexPolygon2D yoFrameConvexPolygon2d, YoFramePoint3D framePoint, YoFrameQuaternion orientation, double scale, double height, AppearanceDefinition appearance) {
        this(name, yoFrameConvexPolygon2d, framePoint, null, orientation, scale, height, appearance);
    }

    public YoGraphicPolygon(String name, YoFrameConvexPolygon2D convexPolygon2d, String namePrefix, String nameSuffix, YoRegistry registry, boolean useYawPitchRoll, double scale, AppearanceDefinition appearance) {
        this(name, convexPolygon2d, new YoFramePoint3D(namePrefix, nameSuffix, worldFrame, registry), useYawPitchRoll ? new YoFrameYawPitchRoll(namePrefix, nameSuffix, worldFrame, registry) : null, useYawPitchRoll ? null : new YoFrameQuaternion(namePrefix, nameSuffix, worldFrame, registry), scale, 0.01, appearance);
    }

    public YoGraphicPolygon(String name, YoFramePoseUsingYawPitchRoll framePose, int maxNumberOfVertices, YoRegistry registry, double scale, AppearanceDefinition appearance) {
        this(name, new YoFrameConvexPolygon2D(name + "ConvexPolygon2d", worldFrame, maxNumberOfVertices, registry), framePose, scale, appearance);
    }

    public YoGraphicPolygon(String name, YoFrameConvexPolygon2D yoFrameConvexPolygon2d, YoFramePoseUsingYawPitchRoll framePose, double scale, AppearanceDefinition appearance) {
        this(name, yoFrameConvexPolygon2d, framePose.getPosition(), framePose.getYawPitchRoll(), scale, appearance);
    }

    public YoGraphicPolygon(String name, int maxNumberOfVertices, YoRegistry registry, boolean useYawPitchRoll, double scale, AppearanceDefinition appearance) {
        this(name, new YoFrameConvexPolygon2D(name + "ConvexPolygon2d", worldFrame, maxNumberOfVertices, registry), registry, useYawPitchRoll, scale, appearance);
    }

    public YoGraphicPolygon(String name, YoFrameConvexPolygon2D convexPolygon2d, YoRegistry registry, boolean useYawPitchRoll, double scale, AppearanceDefinition appearance) {
        this(name, convexPolygon2d, new YoFramePoint3D(name + "Position", worldFrame, registry), useYawPitchRoll ? new YoFrameYawPitchRoll(name + "Orientation", worldFrame, registry) : null, useYawPitchRoll ? null : new YoFrameQuaternion(name + "Orientation", worldFrame, registry), scale, 0.01, appearance);
    }

    public YoGraphicPolygon(String name, YoFrameConvexPolygon2D yoFrameConvexPolygon2d, YoFramePoint3D framePoint, YoFrameYawPitchRoll orientation, double scale, AppearanceDefinition appearance) {
        this(name, yoFrameConvexPolygon2d, framePoint, orientation, scale, 0.01, appearance);
    }

    public YoGraphicPolygon(String name, YoFrameConvexPolygon2D yoFrameConvexPolygon2d, YoFramePoint3D framePoint, YoFrameYawPitchRoll orientation, double scale, double height, AppearanceDefinition appearance) {
        this(name, yoFrameConvexPolygon2d, framePoint, orientation, null, scale, height, appearance);
    }

    private YoGraphicPolygon(String name, YoFrameConvexPolygon2D yoFrameConvexPolygon2d, YoFramePoint3D framePoint, YoFrameYawPitchRoll yawPitchRoll, YoFrameQuaternion quaternion, double scale, double height, AppearanceDefinition appearance) {
        super(name, framePoint, yawPitchRoll, quaternion, scale);
        if (yoFrameConvexPolygon2d.getNumberOfVertices() <= 0) {
            yoFrameConvexPolygon2d.set(Vertex2DSupplier.emptyVertex2DSupplier());
        }
        this.yoFrameConvexPolygon2d = yoFrameConvexPolygon2d;
        this.appearance = appearance;
        this.height = height;
        this.verticesToDisplay = new ArrayList<Point2DReadOnly>(yoFrameConvexPolygon2d.getMaxNumberOfVertices());
        this.graphics3dObject = new Graphics3DObject();
        this.graphics3dObject.setChangeable(true);
        MeshDataHolder meshDataHolder = MeshDataGenerator.ExtrudedPolygon((ConvexPolygon2DReadOnly)yoFrameConvexPolygon2d, height);
        this.instruction = new Graphics3DAddMeshDataInstruction(meshDataHolder, appearance);
        this.graphics3dObject.addInstruction(this.instruction);
    }

    static YoGraphicPolygon createAsRemoteYoGraphic(String name, YoVariable[] yoVariables, double[] constants, AppearanceDefinition appearance) {
        return new YoGraphicPolygon(name, yoVariables, constants, appearance);
    }

    private YoGraphicPolygon(String name, YoVariable[] yoVariables, double[] constants, AppearanceDefinition appearance) {
        super(name, Arrays.copyOfRange(yoVariables, 2 * (int)constants[1] + 1, yoVariables.length), constants[0]);
        int constantIndex = 1;
        int vertexBufferSize = (int)constants[constantIndex++];
        this.height = constants.length == 3 ? constants[constantIndex++] : 0.01;
        int yoIndex = 0;
        YoInteger numberOfVertices = (YoInteger)yoVariables[yoIndex++];
        ArrayList<YoFramePoint2D> yoFrameVertices = new ArrayList<YoFramePoint2D>();
        while (yoFrameVertices.size() < vertexBufferSize) {
            YoDouble xVariable = (YoDouble)yoVariables[yoIndex++];
            YoDouble yVariable = (YoDouble)yoVariables[yoIndex++];
            yoFrameVertices.add(new YoFramePoint2D(xVariable, yVariable, worldFrame));
        }
        this.yoFrameConvexPolygon2d = new YoFrameConvexPolygon2D(yoFrameVertices, numberOfVertices, worldFrame);
        this.verticesToDisplay = new ArrayList<Point2DReadOnly>(this.yoFrameConvexPolygon2d.getMaxNumberOfVertices());
        this.appearance = appearance;
        this.graphics3dObject = new Graphics3DObject();
        this.graphics3dObject.setChangeable(true);
        MeshDataHolder meshDataHolder = MeshDataGenerator.ExtrudedPolygon((ConvexPolygon2DReadOnly)this.yoFrameConvexPolygon2d, this.height);
        this.instruction = new Graphics3DAddMeshDataInstruction(meshDataHolder, appearance);
        this.graphics3dObject.addInstruction(this.instruction);
    }

    @Override
    public Artifact createArtifact() {
        throw new RuntimeException("Implement Me!");
    }

    @Override
    public void update() {
        this.verticesToDisplay.clear();
        for (int i = this.yoFrameConvexPolygon2d.getNumberOfVertices() - 1; i >= 0; --i) {
            this.verticesToDisplay.add((Point2DReadOnly)this.yoFrameConvexPolygon2d.getVertexUnsafe(i));
        }
        this.instruction.setMesh(MeshDataGenerator.ExtrudedPolygon(this.verticesToDisplay, this.height));
    }

    public void updateAppearance(AppearanceDefinition appearance) {
        this.instruction.setAppearance(appearance);
    }

    public void updateConvexPolygon2d(FrameConvexPolygon2DReadOnly frameConvexPolygon2d) {
        this.yoFrameConvexPolygon2d.set((FrameVertex2DSupplier)frameConvexPolygon2d);
        this.update();
    }

    public void updateConvexPolygon2d(ConvexPolygon2DReadOnly convexPolygon2d) {
        this.yoFrameConvexPolygon2d.set((Vertex2DSupplier)convexPolygon2d);
        this.update();
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.graphics3dObject;
    }

    @Override
    public YoVariable[] getVariables() {
        YoVariable[] superYoVariables = super.getVariables();
        YoVariable[] yoVariables = new YoVariable[1 + 2 * this.yoFrameConvexPolygon2d.getMaxNumberOfVertices() + superYoVariables.length];
        int i = 0;
        yoVariables[i++] = this.yoFrameConvexPolygon2d.getYoNumberOfVertices();
        for (YoFramePoint2D p : this.yoFrameConvexPolygon2d.getVertexBuffer()) {
            yoVariables[i++] = p.getYoX();
            yoVariables[i++] = p.getYoY();
        }
        for (YoVariable superYoVariable : superYoVariables) {
            yoVariables[i++] = superYoVariable;
        }
        return yoVariables;
    }

    @Override
    public double[] getConstants() {
        return new double[]{this.scale, this.yoFrameConvexPolygon2d.getVertexBuffer().size(), this.height};
    }

    @Override
    public YoGraphicPolygon duplicate(YoRegistry newRegistry) {
        if (this.isUsingYawPitchRoll()) {
            return new YoGraphicPolygon(this.getName(), this.yoFrameConvexPolygon2d.duplicate(newRegistry), this.yoFramePoint.duplicate(newRegistry), this.yoFrameYawPitchRoll.duplicate(newRegistry), this.scale, this.height, this.appearance);
        }
        return new YoGraphicPolygon(this.getName(), this.yoFrameConvexPolygon2d.duplicate(newRegistry), this.yoFramePoint.duplicate(newRegistry), this.yoFrameQuaternion.duplicate(newRegistry), this.scale, this.height, this.appearance);
    }

    @Override
    public AppearanceDefinition getAppearance() {
        return this.appearance;
    }
}

