/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.instructions;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.listeners.ExtrusionChangedListener;

public class Graphics3DAddExtrusionInstruction
extends Graphics3DInstruction {
    private BufferedImage bufferedImageToExtrude;
    private double thickness;
    private ExtrusionChangedListener extrusionChangedListener;
    private final Font font = new Font("Lucida Sans", 0, 40);
    private final FontRenderContext fontRenderContext;

    private Graphics3DAddExtrusionInstruction() {
        BufferedImage measurementImage = new BufferedImage(1, 1, 5);
        Graphics2D measurementGraphics = measurementImage.createGraphics();
        this.fontRenderContext = measurementGraphics.getFontRenderContext();
    }

    public Graphics3DAddExtrusionInstruction(String text, double thickness, AppearanceDefinition appearance) {
        this();
        this.thickness = thickness;
        this.setText(text);
        this.setAppearance(appearance);
    }

    public Graphics3DAddExtrusionInstruction(BufferedImage bufferedImageToExtrude, double thickness, AppearanceDefinition appearance) {
        this();
        this.thickness = thickness;
        this.setBufferedImage(bufferedImageToExtrude);
        this.setAppearance(appearance);
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImageToExtrude;
    }

    public void setBufferedImage(BufferedImage newImage) {
        this.bufferedImageToExtrude = newImage;
        this.notifyChangedListener();
    }

    public void setHeight(double height) {
        this.thickness = height;
        this.notifyChangedListener();
    }

    public void setText(String text) {
        Rectangle2D bounds = this.font.getStringBounds(text, this.fontRenderContext);
        int width = (int)bounds.getWidth();
        int height = (int)bounds.getHeight();
        this.bufferedImageToExtrude = new BufferedImage(width, height, 5);
        Graphics g = this.bufferedImageToExtrude.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        g.setFont(this.font);
        g.drawString(text, 0, (int)((double)height + bounds.getCenterY()));
        g.dispose();
        this.notifyChangedListener();
    }

    private void notifyChangedListener() {
        if (this.extrusionChangedListener != null) {
            this.extrusionChangedListener.extrusionChanged(this.bufferedImageToExtrude, this.thickness);
        }
    }

    public void setTextChangedListener(ExtrusionChangedListener textChangedListener) {
        this.extrusionChangedListener = textChangedListener;
    }

    public double getHeight() {
        return this.thickness;
    }
}

