/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import us.ihmc.euclid.tuple3D.Point3D32;

public class DepthImage {
    private final BufferedImage bufferedImage;
    private final float[] depths;
    private final int width;
    private final int height;
    private final byte[] imageArray;
    private float m00;
    private float m11;

    public DepthImage(int width, int height) {
        this.width = width;
        this.height = height;
        this.bufferedImage = new BufferedImage(width, height, 5);
        this.depths = new float[width * height];
        WritableRaster wr = this.bufferedImage.getRaster();
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        this.imageArray = db.getData();
    }

    private int getDataIndex(int x, int y) {
        return (this.height - y - 1) * this.width + x;
    }

    public void setTransform2D(float m00, float m11) {
        this.m00 = m00;
        this.m11 = m11;
    }

    public void setPoint(int x, int y, byte red, byte green, byte blue, float depth) {
        int dataIndex = this.getDataIndex(x, y);
        int lowerHalfPtr = dataIndex * 3;
        this.depths[dataIndex] = depth;
        this.imageArray[lowerHalfPtr + 0] = blue;
        this.imageArray[lowerHalfPtr + 1] = green;
        this.imageArray[lowerHalfPtr + 2] = red;
    }

    public float getDepth(int x, int y) {
        return this.depths[this.getDataIndex(x, y)];
    }

    public int getPoint(int x, int y, Point3D32 result) {
        int dataIndex = this.getDataIndex(x, y);
        int lowerHalfPtr = dataIndex * 3;
        if (result != null) {
            float depth = this.depths[dataIndex];
            if (Float.isInfinite(depth) || Float.isNaN(depth)) {
                result.setToNaN();
            } else {
                result.setY(-1.0f * ((float)x / (float)this.width * 2.0f - 1.0f) * this.m00);
                result.setZ(((float)y / (float)this.height * 2.0f - 1.0f) * this.m11);
                result.setX(1.0f);
                result.scale((double)depth);
            }
        }
        int a = 255;
        byte r = this.imageArray[lowerHalfPtr + 2];
        byte g = this.imageArray[lowerHalfPtr + 1];
        byte b = this.imageArray[lowerHalfPtr + 0];
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    public int getColor(int x, int y) {
        return this.getPoint(x, y, null);
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }
}

